package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;

import java.util.HashMap;
import java.util.Map;

public final class RPCJoinChannel extends
        ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceJoinRes> {

    public RPCJoinChannel(String channelId,
                          Map<String, String> joinProps,
                          RichCompletionArg<Map<String, String>> completion) {
        this.channelId    = channelId;
        this.extendProps  = joinProps;
        this.completion = completion;
    }

    @Override
    public String getFunctionName() {
        return "JoinChannelService";
    }

    @Override
    public String getServiceName() {
        return "channel_service_auther";
    }

    @Override
    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceJoinReq req = new ChannelYYProto.PCS_ChannelServiceJoinReq();
        req.appid      = Uint32.toUInt(HMRContext.appId);
        req.channelId     = this.channelId;
        req.uid         = Uint64.toUInt(HMR.getMe().getId());
        req.extendProps = this.extendProps == null ? new HashMap<String, String>() : this.extendProps;
        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceJoinRes res) {
        CompletionUtils.dispatchSuccess(completion, res.extendProps);
    }

    @Override
    public void handleError(@NonNull final Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private String channelId;
    private Map<String, String> extendProps;
    private RichCompletionArg<Map<String, String>> completion;
}
