package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletionArg;
import com.hummer.im.model.id.User;

import java.util.ArrayList;
import java.util.List;

public final class RPCFetchMembersByAttr extends ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceUserListWithPropertyRes> {

    public RPCFetchMembersByAttr(String channelId,
                                 String key,
                                 String prop,
                                 RichCompletionArg<List<User>> completion) {
        this.channelId = channelId;
        this.key = key;
        this.prop = prop;
        this.completion = completion;
    }

    @Override
    public String getServiceName() {
        return "channel_service_query";
    }

    @Override
    public String getFunctionName() {
        return "GetSpecificUserList";
    }

    @Override
    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceUserListWithPropertyReq req
                = new ChannelYYProto.PCS_ChannelServiceUserListWithPropertyReq();

        req.appid = Uint32.toUInt(HMRContext.appId);
        req.channelId = this.channelId;
        req.key = this.key;
        req.prop = this.prop;

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceUserListWithPropertyRes res) throws Throwable {
        List<User> users = new ArrayList<>();
        for (Uint64 id : res.users) {
            users.add(new User(id.longValue()));
        }

        CompletionUtils.dispatchSuccess(completion, users);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private String channelId;
    private String key;
    private String prop;
    private RichCompletionArg<List<User>> completion;
}
