package com.hummer.im.channel._internals.rpc;

import android.support.annotation.NonNull;

import com.hummer.im.Error;
import com.hummer.im.HMR;
import com.hummer.im._internals.HMRContext;
import com.hummer.im._internals.yyp.ChatRoomRPC;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im.channel._internals.proto.ChannelYYProto;
import com.hummer.im.model.completion.CompletionUtils;
import com.hummer.im.model.completion.RichCompletion;

import java.util.Set;

public class RPCDeleteUserInfo extends ChatRoomRPC<ChannelYYProto.PCS_ChannelServiceDeleteUserInfoRes> {

    public RPCDeleteUserInfo(String channelId, Set<String> props, RichCompletion completion) {
        this.channelId = channelId;
        this.props = props;
        this.completion = completion;
    }

    @Override
    public String getServiceName() {
        return "channel_service_auther";
    }

    @Override
    public String getFunctionName() {
        return "DeleteUserInfo";
    }

    @Override
    public Marshallable requestObj() {
        ChannelYYProto.PCS_ChannelServiceDeleteUserInfoReq req
                = new ChannelYYProto.PCS_ChannelServiceDeleteUserInfoReq();

        req.appid = Uint32.toUInt(HMRContext.appId);
        req.channelId = this.channelId;
        req.uid = Uint64.toUInt(HMR.getMe().getId());
        if (props != null) {
            req.keys = this.props;
        }

        return req;
    }

    @Override
    public void handleSuccess(@NonNull ChannelYYProto.PCS_ChannelServiceDeleteUserInfoRes res) throws Throwable {
        CompletionUtils.dispatchSuccess(completion);
    }

    @Override
    public void handleError(@NonNull Error err) {
        CompletionUtils.dispatchFailure(completion, err);
    }

    private String channelId;
    private Set<String> props;
    private RichCompletion completion;
}
