package com.hummer.im.channel._internals.proto;

import com.hummer.im._internals.yyp.packet.MarshalContainer;
import com.hummer.im._internals.yyp.packet.Marshallable;
import com.hummer.im._internals.yyp.packet.Pack;
import com.hummer.im._internals.yyp.packet.Uint32;
import com.hummer.im._internals.yyp.packet.Uint64;
import com.hummer.im._internals.yyp.packet.UnmarshalContainer;
import com.hummer.im._internals.yyp.packet.Unpack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ChannelYYProto {

    private static final int CHAT_ROOM_SVID = 205;

    /**
     * 频道用户在线状态变更通知
     */
    public static class PCS_UserGroupChangeBc implements Marshallable {
        public static final int uri = (13376 << 8 | CHAT_ROOM_SVID);

        public Uint32 appKey = new Uint32(0);
        public String groupid = "";
        public Set<Uint64> joinUsers = new HashSet<>();
        public Set<Uint64> leaveUsers = new HashSet<>();

        @Override
        public int getUri() {
            return uri;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack unpack) {
            appKey = unpack.popUint32();
            groupid = unpack.popString();
            UnmarshalContainer.unmarshalColUint64(unpack, joinUsers);
            UnmarshalContainer.unmarshalColUint64(unpack, leaveUsers);
        }
    }

    public static class PCS_ChannelServiceJoinReq implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Map<String, String> extendProps = new HashMap<>();

        @Override
        public int getUri() {
            return 20001 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid).push(uid).push(channelId);
            MarshalContainer.marshalMapStringString(pack, extendProps);
           }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceJoinRes implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Uint32 rescode = new Uint32(0);
        public String msg = "";
        public Map<String, String> extendProps = new HashMap<>();

        @Override
        public int getUri() {
            return 20002 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            uid = up.popUint64();
            channelId = up.popString();
            rescode = up.popUint32();
            msg = up.popString();
            UnmarshalContainer.unmarshalMapStringString(up, extendProps);
        }
    }

    public static class PCS_ChannelServiceLeaveReq implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Map<String, String> extendProps = new HashMap<>();

        @Override
        public int getUri() {
            return 20003 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid).push(uid).push(channelId);
            MarshalContainer.marshalMapStringString(pack, extendProps);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceLeaveRes implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Uint32 rescode = new Uint32(0);
        public String msg = "";

        @Override
        public int getUri() {
            return 20004 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            uid = up.popUint64();
            channelId = up.popString();
            rescode = up.popUint32();
            msg = up.popString();
        }
    }

    public static class PCS_ChannelServiceSetUserInfoReq implements Marshallable {

        public Uint32 appid;
        public Uint64 uid;
        public String channelId;
        public Map<String, String> extendProps;

        @Override
        public int getUri() {
            return 20005 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid).push(uid).push(channelId);
            MarshalContainer.marshalMapStringString(pack, extendProps);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceSetUserInfoRes implements Marshallable {

        public Uint32 appid;
        public Uint64 uid;
        public String channelId;
        public Uint32 rescode;
        public String msg;

        @Override
        public int getUri() {
            return 20006 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            uid = up.popUint64();
            channelId = up.popString();
            rescode = up.popUint32();
            msg = up.popString();
        }
    }

    public static class PCS_ChannelServiceDeleteUserInfoReq implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Set<String> keys = new HashSet<>();

        @Override
        public int getUri() {
            return 20007 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid).push(uid).push(channelId);
            MarshalContainer.marshalSetString(pack, keys);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceDeleteUserInfoRes implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Uint32 rescode = new Uint32(0);
        public String msg = "";

        @Override
        public int getUri() {
            return 20008 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            uid = up.popUint64();
            channelId = up.popString();
            rescode = up.popUint32();
            msg = up.popString();
        }
    }

    public static class PCS_ChannelServiceUserListWithPropertyReq implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public String channelId = "";
        public String key = "";
        public String prop = "";

        @Override
        public int getUri() {
            return 22003 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid).push(channelId).push(key).push(prop);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceUserListWithPropertyRes implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public String channelId = "";
        public List<Uint64> users = new ArrayList<>();
        public Uint32 rescode = new Uint32(0);
        public String msg = "";

        @Override
        public int getUri() {
            return 22004 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            channelId = up.popString();
            UnmarshalContainer.unmarshalColUint64(up, users);
            rescode = up.popUint32();
            msg = up.popString();
        }
    }

    public static class PCS_ChannelServiceUserListReq implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public String channelId = "";

        @Override
        public int getUri() {
            return 22001 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid).push(channelId);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceUserListRes implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public String channelId = "";
        public List<Uint64> users = new ArrayList<>();
        public Uint32 rescode = new Uint32(0);
        public String msg = "";

        @Override
        public int getUri() {
            return 22002 << 8 | CHAT_ROOM_SVID;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            channelId = up.popString();
            UnmarshalContainer.unmarshalColUint64(up, users);
            rescode = up.popUint32();
            msg = up.popString();
        }
    }

    public static class PCS_ChannelServiceSendBroadcastReq implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public String type = "";
        // string32
        public String content = "";
        public boolean reliable = false;

        @Override
        public int getUri() {
            return 20009 << 8 | 205;
        }

        @Override
        public void marshall(Pack pack) {
            pack.push(appid)
                    .push(uid)
                    .push(channelId)
                    .push(type)
                    .pushString32(content)
                    .push(reliable);
        }

        @Override
        public void unmarshall(Unpack up) {

        }
    }

    public static class PCS_ChannelServiceSendBroadcastRes implements Marshallable {

        public Uint32 appid = new Uint32(0);
        public Uint64 uid = new Uint64(0);
        public String channelId = "";
        public Uint32 rescode = new Uint32(0);
        public String msg = "";

        @Override
        public int getUri() {
            return 20011 << 8 | 205;
        }

        @Override
        public void marshall(Pack pack) {

        }

        @Override
        public void unmarshall(Unpack up) {
            appid = up.popUint32();
            uid = up.popUint64();
            channelId = up.popString();
            rescode = up.popUint32();
            msg = up.popString();
        }
    }
}
