/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.receipts.protocols.v1.models.fragments;

import com.gradle.protocols.util.Hasher;
import com.gradle.receipts.protocols.v1.models.Hashable;
import com.gradle.receipts.protocols.v1.models.ReceiptFragment;
import com.gradle.receipts.protocols.v1.models.ReceiptFragmentType;
import java.util.List;

public class DependenciesFragment
extends ReceiptFragment {
    private final List<Dependency> dependencies;

    public DependenciesFragment(List<Dependency> dependencies) {
        super(ReceiptFragmentType.DEPENDENCIES, Hasher.hashMultiple(dependencies));
        this.dependencies = dependencies;
    }

    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    public static class Dependency
    implements Hashable {
        private final String projectPath;
        private final String idHash;
        private final String dependencyProjectPath;
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String selectedHash;
        private final String parentHash;
        private final String configuration;
        private final String selectedReason;
        private final String attemptedReason;
        private final boolean isResolved;
        private final boolean isExpected;
        private final boolean isForced;
        private final boolean isSelectedByRule;
        private final boolean isConflictResolution;
        private final boolean failed;

        public Dependency(String projectPath, String idHash, String dependencyProjectPath, String groupId, String artifactId, String version, String selectedHash, String parentHash, String configuration, String selectedReason, String attemptedReason, boolean isResolved, boolean isExpected, boolean isForced, boolean isSelectedByRule, boolean isConflictResolution, boolean failed) {
            this.projectPath = projectPath;
            this.idHash = idHash;
            this.dependencyProjectPath = dependencyProjectPath;
            this.groupId = groupId;
            this.version = version;
            this.selectedHash = selectedHash;
            this.parentHash = parentHash;
            this.artifactId = artifactId;
            this.configuration = configuration;
            this.isResolved = isResolved;
            this.failed = failed;
            this.selectedReason = selectedReason;
            this.attemptedReason = attemptedReason;
            this.isExpected = isExpected;
            this.isForced = isForced;
            this.isSelectedByRule = isSelectedByRule;
            this.isConflictResolution = isConflictResolution;
        }

        public String getConfiguration() {
            return this.configuration;
        }

        public boolean isFailed() {
            return this.failed;
        }

        public String getSelectedReason() {
            return this.selectedReason;
        }

        public String getAttemptedReason() {
            return this.attemptedReason;
        }

        public boolean isExpected() {
            return this.isExpected;
        }

        public boolean isForced() {
            return this.isForced;
        }

        public boolean isSelectedByRule() {
            return this.isSelectedByRule;
        }

        public boolean isConflictResolution() {
            return this.isConflictResolution;
        }

        public String getIdHash() {
            return this.idHash;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getParentHash() {
            return this.parentHash;
        }

        public boolean isProjectDependent() {
            return this.projectPath != null;
        }

        public boolean isModuleDependent() {
            return this.groupId != null;
        }

        public boolean isResolved() {
            return this.isResolved;
        }

        public String getSelectedHash() {
            return this.selectedHash;
        }

        public String getDependencyProjectPath() {
            return this.dependencyProjectPath;
        }

        @Override
        public String getHash() {
            return Hasher.hashMultiple(this.projectPath, this.idHash, this.dependencyProjectPath, this.groupId, this.artifactId, this.version, this.selectedHash, this.parentHash, this.configuration, this.selectedReason, this.attemptedReason, "" + this.isResolved, "" + this.isExpected, "" + this.isForced, "" + this.isSelectedByRule, "" + this.isConflictResolution, "" + this.failed);
        }
    }
}

