/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.gradle.publish.InvalidPluginIdException;
import com.gradle.publish.MavenCoordinates;
import com.gradle.publish.PluginBundleExtension;
import com.gradle.publish.PluginConfig;
import com.gradle.publish.PluginId;
import com.gradle.publish.Util;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class PluginPublishValidator {
    private static final Collection<String> FORBIDDEN_NAMESPACES = ImmutableList.of((Object)"org.gradle", (Object)"com.gradleware", (Object)"com.gradle");
    private final String projectVersion;
    private final boolean skipNamespaceCheck;
    private final boolean versionOverride;
    private static final Pattern MAVEN_ID_REGEX = Pattern.compile("[A-Za-z0-9_\\-.]+");
    public static final Set<String> ILLEGAL_TAGS = ImmutableSet.of((Object)"gradle", (Object)"plugin");

    public PluginPublishValidator(String projectVersion, boolean skipNamespaceCheck, boolean versionOverride) {
        this.projectVersion = projectVersion;
        this.skipNamespaceCheck = skipNamespaceCheck;
        this.versionOverride = versionOverride;
    }

    public void validateMavenCoordinates(String groupId, String artifactId, String version, MavenCoordinates coordinates) {
        String specifiedArtifactId;
        if (Util.isBlank(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as no group ID set.\nPlease set the group at the project level or the group ID in the\nmavenCoordinates block inside your pluginBundle config.");
        }
        if (!MAVEN_ID_REGEX.matcher(groupId).matches()) {
            boolean specifiedGroupId = coordinates != null && !Util.isBlank(coordinates.getGroupId());
            String extraHelp = specifiedGroupId ? "" : "\nBy default the project group is used as the group ID. You can override this by setting\nthe groupId property in the mavenCoordinates block inside your pluginBundle config.";
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is invalid.\n" + "Valid group IDs may include alphanumeric characters, numbers, dashes,\n" + "underscores and dots." + extraHelp);
        }
        if (this.failsNamespaceCheck(groupId)) {
            throw new IllegalArgumentException("Cannot publish artifacts as group ID '" + groupId + "' is not allowed.\n" + "Group IDs cannot begin with org.gradle, com.gradleware, com.gradle");
        }
        String string = specifiedArtifactId = coordinates != null ? coordinates.getArtifactId() : null;
        if (!MAVEN_ID_REGEX.matcher(artifactId).matches()) {
            String extraHelp = !Util.isBlank(specifiedArtifactId) ? "" : "\nBy default the project name is used as the artifact ID. You can override this by setting\nthe artifactId property in the mavenCoordinates block inside your pluginBundle config.";
            throw new IllegalArgumentException("Cannot publish artifacts as artifact ID '" + artifactId + "' is invalid.\n" + "Valid artifact IDs may include alphanumeric characters, numbers, dashes,\n" + "underscores and dots." + extraHelp);
        }
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Cannot publish artifacts as no version set.\nPlease set the version at the project level or in the mavenCoordinates block\ninside your pluginBundle config.");
        }
    }

    public void validateBundle(PluginBundleExtension bundleConfig) {
        if (bundleConfig.getPlugins().isEmpty()) {
            throw new IllegalArgumentException("No plugins defined. Please declare at least one plugin in a pluginBundle plugins block");
        }
        if (Util.isBlank(bundleConfig.getWebsite())) {
            throw new IllegalArgumentException("Plugin bundle has no website, please set the website property in the pluginBundle config.\nExample: website = 'https://github.com/username/repo'");
        }
        if (Util.isBlank(bundleConfig.getVcsUrl())) {
            throw new IllegalArgumentException("Plugin bundle has no VCS URL, please set the vcsUrl property in the pluginBundle config.\nExample: vcsUrl = 'https://github.com/username/repo'");
        }
        this.validatePluginIdUniqueness(bundleConfig);
        for (PluginConfig plugin : bundleConfig.getPlugins()) {
            this.validatePluginConfig(bundleConfig, plugin);
        }
    }

    private void validateTags(PluginBundleExtension bundleConfig, PluginConfig plugin) {
        Collection<String> configTags = plugin.getTags();
        if (configTags.isEmpty()) {
            configTags = bundleConfig.getTags();
        }
        if (configTags.isEmpty()) {
            throw new IllegalArgumentException("Plugin bundle has no tags, please set the tags property in the pluginBundle config.\nExample: tags = ['test', 'integration']");
        }
        for (String tag : configTags) {
            if (ILLEGAL_TAGS.contains(tag.toLowerCase())) continue;
            return;
        }
        throw new IllegalArgumentException("Plugin bundle has no valid tags, please set the tags property in the pluginBundle config.\nTags of \"gradle\" and \"plugin\" are ignored.Example: tags = ['test', 'integration']");
    }

    public void validatePluginConfig(PluginBundleExtension bundleConfig, PluginConfig plugin) {
        String pluginName = plugin.getName();
        this.validatePluginId(pluginName, plugin.getId());
        String pluginVersion = plugin.getVersion() != null ? plugin.getVersion() : this.projectVersion;
        this.validateVersion(plugin.getName(), pluginVersion);
        if (Util.isBlank(plugin.getDisplayName())) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " has no display name, please set the displayName property in the plugin config.\n" + "Example: displayName = 'My Widget Plugin'");
        }
        String desc = plugin.getDescription();
        String string = desc = desc != null ? desc : bundleConfig.getDescription();
        if (Util.isBlank(desc)) {
            throw new IllegalArgumentException("Plugin " + plugin.getName() + " has no description, please set the description property\n" + "in the plugin config or the pluginBundle config.\n" + "Example: description = 'This plugin adds some tasks and makes you coffee'");
        }
        this.validateTags(bundleConfig, plugin);
    }

    private void validateVersion(String pluginName, String version) {
        if (this.versionOverride) {
            return;
        }
        String regExp = "[a-zA-Z0-9\\-\\.\\[\\]\\:\\+]*";
        String numberRegExp = ".*?[0-9].*?";
        if (Util.isBlank(version) || version.equals("unspecified")) {
            throw new IllegalArgumentException("Plugin " + pluginName + " does not define a version.\n" + "Please set the version property in the plugin config, or set the project version");
        }
        if (!version.matches(numberRegExp) || !version.matches(regExp) || version.length() > 20) {
            throw new RuntimeException("Invalid version '" + version + "'. Set 'version' property " + "string must with a string that: 1) is more than 1 and less than 20 " + "characters long; 2) includes a number; and 3) that matches the regular " + "expression: " + regExp);
        }
    }

    private void validatePluginId(String pluginName, String pluginId) {
        if (pluginId == null || pluginId.isEmpty()) {
            throw new IllegalArgumentException("Plugin " + pluginName + " does not define a plugin ID. Please set the 'id' property in the plugin config");
        }
        PluginId id = PluginId.of(pluginId);
        if (!id.isQualified()) {
            throw new InvalidPluginIdException(pluginId, "Plugin IDs should be namespaced, e.g. 'com.example." + pluginId + "'");
        }
        if (this.failsNamespaceCheck(pluginId)) {
            throw new InvalidPluginIdException(pluginId, "cannot begin with " + Joiner.on((String)", ").join(FORBIDDEN_NAMESPACES));
        }
    }

    private void validatePluginIdUniqueness(PluginBundleExtension bundleConfig) {
        HashSet usedPluginIds = Sets.newHashSet();
        for (PluginConfig plugin : bundleConfig.getPlugins()) {
            String pluginId = plugin.getId();
            if (usedPluginIds.contains(pluginId)) {
                throw new InvalidPluginIdException(pluginId, "multiple plugins are using the same ID");
            }
            usedPluginIds.add(pluginId);
        }
    }

    private boolean failsNamespaceCheck(String id) {
        if (!this.skipNamespaceCheck) {
            id = id.toLowerCase();
            for (String ns : FORBIDDEN_NAMESPACES) {
                if (!id.equals(ns) && !id.startsWith(ns + ".")) continue;
                return true;
            }
        }
        return false;
    }
}

