/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import com.google.common.base.CharMatcher;
import com.gradle.publish.InvalidPluginIdException;

public class PluginId {
    public static final String ID_SEPARATOR_ON_START_OR_END = "cannot begin or end with '.'";
    public static final String DOUBLE_SEPARATOR = "cannot contain '..'";
    public static final String PLUGIN_ID_VALID_CHARS_DESCRIPTION = "ASCII alphanumeric characters, '.', '_' and '-'";
    public static final CharMatcher INVALID_PLUGIN_ID_CHAR_MATCHER = CharMatcher.inRange((char)'a', (char)'z').or(CharMatcher.inRange((char)'A', (char)'Z')).or(CharMatcher.inRange((char)'0', (char)'9')).or(CharMatcher.anyOf((CharSequence)".-_")).negate();
    public static final String SEPARATOR = ".";
    private final String value;

    public PluginId(String value) {
        this.value = value;
    }

    public static PluginId of(String value) throws InvalidPluginIdException {
        PluginId.validate(value);
        return new PluginId(value);
    }

    public static void validate(String value) throws InvalidPluginIdException {
        if (value.startsWith(SEPARATOR) || value.endsWith(SEPARATOR)) {
            throw new InvalidPluginIdException(value, ID_SEPARATOR_ON_START_OR_END);
        }
        if (value.contains("..")) {
            throw new InvalidPluginIdException(value, DOUBLE_SEPARATOR);
        }
        int invalidCharIndex = INVALID_PLUGIN_ID_CHAR_MATCHER.indexIn((CharSequence)value);
        if (invalidCharIndex >= 0) {
            char invalidChar = value.charAt(invalidCharIndex);
            throw new InvalidPluginIdException(value, PluginId.invalidPluginIdCharMessage(invalidChar));
        }
    }

    public static String invalidPluginIdCharMessage(char invalidChar) {
        return "contains invalid char '" + invalidChar + "' (only " + PLUGIN_ID_VALID_CHARS_DESCRIPTION + " characters are valid)";
    }

    public boolean isQualified() {
        return this.value.contains(SEPARATOR);
    }

    public PluginId maybeQualify(String qualification) {
        return this.isQualified() ? this : new PluginId(qualification + SEPARATOR + this.value);
    }

    public String getNamespace() {
        return this.isQualified() ? this.value.substring(0, this.value.lastIndexOf(SEPARATOR)) : null;
    }

    public boolean inNamespace(String namespace) {
        return this.isQualified() && this.getNamespace().equals(namespace);
    }

    public String getName() {
        return this.isQualified() ? this.value.substring(this.value.lastIndexOf(SEPARATOR) + 1) : this.value;
    }

    public PluginId getUnqualified() {
        return this.isQualified() ? new PluginId(this.getName()) : this;
    }

    public String toString() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginId pluginId = (PluginId)o;
        return this.value.equals(pluginId.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

