/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.protocols.util;

import com.gradle.receipts.protocols.v1.models.Hashable;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.DatatypeConverter;

public class Hasher {
    static ThreadLocal<MessageDigest> md = new ThreadLocal<MessageDigest>(){

        @Override
        public MessageDigest initialValue() {
            try {
                return MessageDigest.getInstance("SHA-256");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    };

    public static String hashMultiple(Object ... hashes) {
        return Hasher.hashMultiple(Arrays.asList(hashes));
    }

    public static String hashMultiple(List<?> hashes) {
        if (hashes == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object hash : hashes) {
            Hasher.appendHash(stringBuilder, hash);
            stringBuilder.append("#");
        }
        return Hasher.hash(stringBuilder.toString());
    }

    private static void appendHash(StringBuilder sb, Object o) {
        sb.append(o instanceof Hashable ? ((Hashable)o).getHash() : o);
    }

    public static String hash(String s) {
        if (s == null) {
            return "";
        }
        return Hasher.hash(s.getBytes());
    }

    public static String hashBytesAsHexString(byte[] bytes) {
        return DatatypeConverter.printHexBinary((byte[])bytes).toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(byte[] bytes) {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            currentMd.update(bytes);
            String string = Hasher.hashBytesAsHexString(currentMd.digest());
            return string;
        }
        finally {
            currentMd.reset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hash(InputStream is) throws IOException {
        MessageDigest currentMd = md.get();
        currentMd.reset();
        try {
            byte[] buf = new byte[4096];
            int len = is.read(buf);
            while (len > 0) {
                currentMd.update(buf, 0, len);
                len = is.read(buf);
            }
            String string = Hasher.hashBytesAsHexString(currentMd.digest());
            return string;
        }
        finally {
            currentMd.reset();
        }
    }
}

