/*
 * Decompiled with CFR 0.152.
 */
package com.gradle.publish;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

final class RequestUtil {
    private static final String PUBLISH_PLUGIN_VERSION;

    private static String getVersionFallback() {
        ClassLoader cl = RequestUtil.class.getClassLoader();
        if (cl instanceof URLClassLoader) {
            URL url = ((URLClassLoader)cl).findResource("META-INF/MANIFEST.MF");
            if (url != null) {
                try {
                    Manifest manifest = new Manifest(url.openStream());
                    Attributes mainAttributes = manifest.getMainAttributes();
                    String pluginVersion = mainAttributes.getValue("Implementation-Version");
                    if (pluginVersion != null) {
                        return pluginVersion;
                    }
                    throw new IllegalStateException("MANIFEST file did not contain Implementation-Version");
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed loading MANIFEST", e);
                }
            }
            throw new IllegalStateException("META-INF/MANIFEST.MF couldn't be found");
        }
        throw new IllegalStateException("Classloader was not a URLClassLoader");
    }

    private RequestUtil() {
    }

    static void addClientVersionAsRequestHeader(URLConnection urlConnection) {
        urlConnection.addRequestProperty("Gradle-Publish-Plugin-Version", PUBLISH_PLUGIN_VERSION);
    }

    static {
        String version = RequestUtil.class.getPackage().getImplementationVersion();
        if (version == null) {
            try {
                version = RequestUtil.getVersionFallback();
            }
            catch (RuntimeException e) {
                throw new RuntimeException("Failed loading the plugin version using fallback logic. Please report this as an issue.", e);
            }
        }
        assert (version != null) : "version was null";
        PUBLISH_PLUGIN_VERSION = version;
    }
}

