/*
 * Decompiled with CFR 0.152.
 */
package com.google.maps.android.data.geojson;

import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.gms.maps.model.PolygonOptions;
import com.google.android.gms.maps.model.PolylineOptions;
import com.google.maps.android.data.Feature;
import com.google.maps.android.data.Geometry;
import com.google.maps.android.data.geojson.GeoJsonLineStringStyle;
import com.google.maps.android.data.geojson.GeoJsonPointStyle;
import com.google.maps.android.data.geojson.GeoJsonPolygonStyle;
import com.google.maps.android.data.geojson.GeoJsonStyle;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;

public class GeoJsonFeature
extends Feature
implements Observer {
    private final LatLngBounds mBoundingBox;
    private GeoJsonPointStyle mPointStyle;
    private GeoJsonLineStringStyle mLineStringStyle;
    private GeoJsonPolygonStyle mPolygonStyle;

    public GeoJsonFeature(Geometry geometry, String id2, HashMap<String, String> properties, LatLngBounds boundingBox) {
        super(geometry, id2, properties);
        this.mId = id2;
        this.mBoundingBox = boundingBox;
    }

    @Override
    public String setProperty(String property, String propertyValue) {
        return super.setProperty(property, propertyValue);
    }

    @Override
    public String removeProperty(String property) {
        return super.removeProperty(property);
    }

    public GeoJsonPointStyle getPointStyle() {
        return this.mPointStyle;
    }

    public void setPointStyle(GeoJsonPointStyle pointStyle) {
        if (pointStyle == null) {
            throw new IllegalArgumentException("Point style cannot be null");
        }
        if (this.mPointStyle != null) {
            this.mPointStyle.deleteObserver(this);
        }
        this.mPointStyle = pointStyle;
        this.mPointStyle.addObserver(this);
        this.checkRedrawFeature(this.mPointStyle);
    }

    public GeoJsonLineStringStyle getLineStringStyle() {
        return this.mLineStringStyle;
    }

    public void setLineStringStyle(GeoJsonLineStringStyle lineStringStyle) {
        if (lineStringStyle == null) {
            throw new IllegalArgumentException("Line string style cannot be null");
        }
        if (this.mLineStringStyle != null) {
            this.mLineStringStyle.deleteObserver(this);
        }
        this.mLineStringStyle = lineStringStyle;
        this.mLineStringStyle.addObserver(this);
        this.checkRedrawFeature(this.mLineStringStyle);
    }

    public GeoJsonPolygonStyle getPolygonStyle() {
        return this.mPolygonStyle;
    }

    public void setPolygonStyle(GeoJsonPolygonStyle polygonStyle) {
        if (polygonStyle == null) {
            throw new IllegalArgumentException("Polygon style cannot be null");
        }
        if (this.mPolygonStyle != null) {
            this.mPolygonStyle.deleteObserver(this);
        }
        this.mPolygonStyle = polygonStyle;
        this.mPolygonStyle.addObserver(this);
        this.checkRedrawFeature(this.mPolygonStyle);
    }

    public PolygonOptions getPolygonOptions() {
        return this.mPolygonStyle.toPolygonOptions();
    }

    public MarkerOptions getMarkerOptions() {
        return this.mPointStyle.toMarkerOptions();
    }

    public PolylineOptions getPolylineOptions() {
        return this.mLineStringStyle.toPolylineOptions();
    }

    private void checkRedrawFeature(GeoJsonStyle style2) {
        if (this.hasGeometry() && Arrays.asList(style2.getGeometryType()).contains(this.getGeometry().getGeometryType())) {
            this.setChanged();
            this.notifyObservers();
        }
    }

    @Override
    public void setGeometry(Geometry geometry) {
        super.setGeometry(geometry);
        this.setChanged();
        this.notifyObservers();
    }

    public LatLngBounds getBoundingBox() {
        return this.mBoundingBox;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Feature{");
        sb.append("\n bounding box=").append(this.mBoundingBox);
        sb.append(",\n geometry=").append(this.getGeometry());
        sb.append(",\n point style=").append(this.mPointStyle);
        sb.append(",\n line string style=").append(this.mLineStringStyle);
        sb.append(",\n polygon style=").append(this.mPolygonStyle);
        sb.append(",\n id=").append(this.mId);
        sb.append(",\n properties=").append(this.getProperties());
        sb.append("\n}\n");
        return sb.toString();
    }

    @Override
    public void update(Observable observable, Object data) {
        if (observable instanceof GeoJsonStyle) {
            this.checkRedrawFeature((GeoJsonStyle)((Object)observable));
        }
    }
}

