/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.internal.Annotations;
import com.google.inject.internal.BindingImpl;
import com.google.inject.internal.Errors;
import com.google.inject.internal.ErrorsException;
import com.google.inject.internal.InjectorImpl;
import com.google.inject.internal.InternalContext;
import com.google.inject.internal.InternalFactory;
import com.google.inject.internal.InternalProviderInstanceBindingImpl;
import com.google.inject.internal.InternalProvisionException;
import com.google.inject.multibindings.MultibindingsTargetVisitor;
import com.google.inject.multibindings.OptionalBinderBinding;
import com.google.inject.spi.BindingTargetVisitor;
import com.google.inject.spi.Dependency;
import com.google.inject.spi.Element;
import com.google.inject.spi.ProviderInstanceBinding;
import com.google.inject.spi.ProviderWithExtensionVisitor;
import com.google.inject.util.Types;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Set;
import javax.inject.Qualifier;

public final class RealOptionalBinder<T>
implements Module {
    private static final Class<?> JAVA_OPTIONAL_CLASS;
    private static final Object JAVA_OPTIONAL_EMPTY;
    private static final Method JAVA_OPTIONAL_OF_METHOD;
    private final BindingSelection<T> bindingSelection;
    private final Binder binder;

    public static <T> RealOptionalBinder<T> newRealOptionalBinder(Binder binder, Key<T> type) {
        binder = binder.skipSources(RealOptionalBinder.class);
        RealOptionalBinder<T> optionalBinder = new RealOptionalBinder<T>(binder, type);
        binder.install(optionalBinder);
        return optionalBinder;
    }

    private static Object invokeJavaOptionalOfNullable(Object o) {
        if (o == null) {
            return JAVA_OPTIONAL_EMPTY;
        }
        return RealOptionalBinder.invokeJavaOptionalOf(o);
    }

    private static Object invokeJavaOptionalOf(Object o) {
        try {
            return JAVA_OPTIONAL_OF_METHOD.invoke(null, o);
        }
        catch (IllegalAccessException e) {
            throw new SecurityException(e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e.getCause());
        }
    }

    static <T> TypeLiteral<Optional<T>> optionalOf(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{type.getType()}));
    }

    static <T> TypeLiteral<?> javaOptionalOf(TypeLiteral<T> type) {
        Preconditions.checkState((JAVA_OPTIONAL_CLASS != null ? 1 : 0) != 0, (Object)"java.util.Optional not found");
        return TypeLiteral.get(Types.newParameterizedType(JAVA_OPTIONAL_CLASS, type.getType()));
    }

    static <T> TypeLiteral<Optional<javax.inject.Provider<T>>> optionalOfJavaxProvider(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Types.newParameterizedType(javax.inject.Provider.class, new Type[]{type.getType()})}));
    }

    static <T> TypeLiteral<?> javaOptionalOfJavaxProvider(TypeLiteral<T> type) {
        Preconditions.checkState((JAVA_OPTIONAL_CLASS != null ? 1 : 0) != 0, (Object)"java.util.Optional not found");
        return TypeLiteral.get(Types.newParameterizedType(JAVA_OPTIONAL_CLASS, Types.newParameterizedType(javax.inject.Provider.class, new Type[]{type.getType()})));
    }

    static <T> TypeLiteral<Optional<Provider<T>>> optionalOfProvider(TypeLiteral<T> type) {
        return TypeLiteral.get(Types.newParameterizedType(Optional.class, new Type[]{Types.newParameterizedType(Provider.class, new Type[]{type.getType()})}));
    }

    static <T> TypeLiteral<?> javaOptionalOfProvider(TypeLiteral<T> type) {
        Preconditions.checkState((JAVA_OPTIONAL_CLASS != null ? 1 : 0) != 0, (Object)"java.util.Optional not found");
        return TypeLiteral.get(Types.newParameterizedType(JAVA_OPTIONAL_CLASS, Types.newParameterizedType(Provider.class, new Type[]{type.getType()})));
    }

    static <T> Key<Provider<T>> providerOf(Key<T> key) {
        ParameterizedType providerT = Types.providerOf(key.getTypeLiteral().getType());
        return key.ofType(providerT);
    }

    private RealOptionalBinder(Binder binder, Key<T> typeKey) {
        this.bindingSelection = new BindingSelection<T>(typeKey);
        this.binder = binder;
    }

    private void addDirectTypeBinding(Binder binder) {
        binder.bind(this.bindingSelection.getDirectKey()).toProvider(new RealDirectTypeProvider<T>(this.bindingSelection));
    }

    Key<T> getKeyForDefaultBinding() {
        this.bindingSelection.checkNotInitialized();
        this.addDirectTypeBinding(this.binder);
        return this.bindingSelection.getKeyForDefaultBinding();
    }

    public LinkedBindingBuilder<T> setDefault() {
        return this.binder.bind(this.getKeyForDefaultBinding());
    }

    Key<T> getKeyForActualBinding() {
        this.bindingSelection.checkNotInitialized();
        this.addDirectTypeBinding(this.binder);
        return this.bindingSelection.getKeyForActualBinding();
    }

    public LinkedBindingBuilder<T> setBinding() {
        return this.binder.bind(this.getKeyForActualBinding());
    }

    @Override
    public void configure(Binder binder) {
        this.bindingSelection.checkNotInitialized();
        Key<Object> key = this.bindingSelection.getDirectKey();
        RealOptionalProviderProvider<T> optionalProviderFactory = new RealOptionalProviderProvider<T>(this.bindingSelection);
        binder.bind(key.ofType(RealOptionalBinder.optionalOfProvider(key.getTypeLiteral()))).toProvider(optionalProviderFactory);
        RealOptionalProviderProvider<T> optionalJavaxProviderFactory = optionalProviderFactory;
        binder.bind(key.ofType(RealOptionalBinder.optionalOfJavaxProvider(key.getTypeLiteral()))).toProvider((Provider<Optional<javax.inject.Provider<T>>>)optionalJavaxProviderFactory);
        Key<Optional<T>> optionalKey = key.ofType(RealOptionalBinder.optionalOf(key.getTypeLiteral()));
        binder.bind(optionalKey).toProvider(new RealOptionalKeyProvider<T>(this.bindingSelection, optionalKey));
        this.bindJava8Optional(binder);
    }

    private void bindJava8Optional(Binder binder) {
        if (JAVA_OPTIONAL_CLASS != null) {
            Key<?> key = this.bindingSelection.getDirectKey();
            TypeLiteral<T> typeLiteral = key.getTypeLiteral();
            JavaOptionalProviderProvider javaOptionalProviderFactory = new JavaOptionalProviderProvider((BindingSelection<?>)this.bindingSelection);
            binder.bind(key.ofType(RealOptionalBinder.javaOptionalOfProvider(typeLiteral))).toProvider(javaOptionalProviderFactory);
            binder.bind(key.ofType(RealOptionalBinder.javaOptionalOfJavaxProvider(typeLiteral))).toProvider(javaOptionalProviderFactory);
            Key<T> javaOptionalKey = key.ofType(RealOptionalBinder.javaOptionalOf(typeLiteral));
            binder.bind(javaOptionalKey).toProvider(new JavaOptionalProvider(this.bindingSelection, javaOptionalKey));
        }
    }

    public boolean equals(Object o) {
        return o instanceof RealOptionalBinder && ((RealOptionalBinder)o).bindingSelection.equals(this.bindingSelection);
    }

    public int hashCode() {
        return this.bindingSelection.hashCode();
    }

    static {
        Class<?> optional = null;
        Object emptyObject = null;
        Method of = null;
        boolean useJavaOptional = false;
        try {
            optional = Class.forName("java.util.Optional");
            emptyObject = optional.getDeclaredMethod("empty", new Class[0]).invoke(null, new Object[0]);
            of = optional.getDeclaredMethod("of", Object.class);
            useJavaOptional = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        JAVA_OPTIONAL_CLASS = useJavaOptional ? optional : null;
        JAVA_OPTIONAL_EMPTY = useJavaOptional ? emptyObject : null;
        JAVA_OPTIONAL_OF_METHOD = useJavaOptional ? of : null;
    }

    static abstract class BaseAnnotation
    implements Serializable,
    Annotation {
        private final String value;
        private final Class<? extends Annotation> clazz;
        private static final long serialVersionUID = 0L;

        BaseAnnotation(Class<? extends Annotation> clazz, String value) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz, (Object)"clazz");
            this.value = (String)Preconditions.checkNotNull((Object)value, (Object)"value");
        }

        public String value() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return 127 * "value".hashCode() ^ this.value.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof Actual && this.clazz == Actual.class) {
                Actual other = (Actual)o;
                return this.value.equals(other.value());
            }
            if (o instanceof Default && this.clazz == Default.class) {
                Default other = (Default)o;
                return this.value.equals(other.value());
            }
            return false;
        }

        @Override
        public String toString() {
            return "@" + this.clazz.getName() + (this.value.isEmpty() ? "" : "(value=" + this.value + ")");
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return this.clazz;
        }
    }

    static class ActualImpl
    extends BaseAnnotation
    implements Actual {
        public ActualImpl(String value) {
            super(Actual.class, value);
        }
    }

    static class DefaultImpl
    extends BaseAnnotation
    implements Default {
        public DefaultImpl(String value) {
            super(Default.class, value);
        }
    }

    private static abstract class RealOptionalBinderProviderWithDependencies<T, P>
    extends InternalProviderInstanceBindingImpl.Factory<P> {
        protected final BindingSelection<T> bindingSelection;

        RealOptionalBinderProviderWithDependencies(BindingSelection<T> bindingSelection) {
            super(InternalProviderInstanceBindingImpl.InitializationTiming.DELAYED);
            this.bindingSelection = bindingSelection;
        }

        @Override
        final void initialize(InjectorImpl injector, Errors errors) throws ErrorsException {
            this.bindingSelection.initialize(injector);
            this.doInitialize();
        }

        abstract void doInitialize();

        public boolean equals(Object obj) {
            return obj != null && this.getClass() == obj.getClass() && this.bindingSelection.equals(((RealOptionalBinderProviderWithDependencies)obj).bindingSelection);
        }

        public int hashCode() {
            return this.bindingSelection.hashCode();
        }
    }

    private static final class BindingSelection<T> {
        private static final ImmutableSet<Dependency<?>> MODULE_DEPENDENCIES = ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
        BindingImpl<T> actualBinding;
        BindingImpl<T> defaultBinding;
        BindingImpl<T> binding;
        private boolean initialized;
        private final Key<T> key;
        private ImmutableSet<Dependency<?>> dependencies = MODULE_DEPENDENCIES;
        private ImmutableSet<Dependency<?>> providerDependencies = MODULE_DEPENDENCIES;
        private String bindingName;
        private Key<T> defaultBindingKey;
        private Key<T> actualBindingKey;

        BindingSelection(Key<T> key) {
            this.key = key;
        }

        void checkNotInitialized() {
            Errors.checkConfiguration(!this.initialized, "already initialized", new Object[0]);
        }

        void initialize(InjectorImpl injector) {
            if (this.initialized) {
                return;
            }
            this.actualBinding = injector.getExistingBinding((Key)this.getKeyForActualBinding());
            this.defaultBinding = injector.getExistingBinding((Key)this.getKeyForDefaultBinding());
            Binding userBinding = injector.getExistingBinding((Key)this.key);
            if (this.actualBinding != null) {
                this.binding = this.actualBinding;
            } else if (this.defaultBinding != null) {
                this.binding = this.defaultBinding;
            } else if (userBinding != null) {
                this.binding = userBinding;
                this.actualBinding = userBinding;
            }
            if (this.binding != null) {
                this.dependencies = ImmutableSet.of(Dependency.get(this.binding.getKey()));
                this.providerDependencies = ImmutableSet.of(Dependency.get(RealOptionalBinder.providerOf(this.binding.getKey())));
            } else {
                this.dependencies = ImmutableSet.of();
                this.providerDependencies = ImmutableSet.of();
            }
            this.initialized = true;
        }

        Key<T> getKeyForDefaultBinding() {
            if (this.defaultBindingKey == null) {
                this.defaultBindingKey = Key.get(this.key.getTypeLiteral(), (Annotation)new DefaultImpl(this.getBindingName()));
            }
            return this.defaultBindingKey;
        }

        Key<T> getKeyForActualBinding() {
            if (this.actualBindingKey == null) {
                this.actualBindingKey = Key.get(this.key.getTypeLiteral(), (Annotation)new ActualImpl(this.getBindingName()));
            }
            return this.actualBindingKey;
        }

        Key<T> getDirectKey() {
            return this.key;
        }

        private String getBindingName() {
            if (this.bindingName == null) {
                this.bindingName = Annotations.nameOf(this.key);
            }
            return this.bindingName;
        }

        BindingImpl<T> getBinding() {
            return this.binding;
        }

        BindingImpl<T> getDefaultBinding() {
            return this.defaultBinding;
        }

        BindingImpl<T> getActualBinding() {
            return this.actualBinding;
        }

        ImmutableSet<Dependency<?>> providerDependencies() {
            return this.providerDependencies;
        }

        ImmutableSet<Dependency<?>> dependencies() {
            return this.dependencies;
        }

        Dependency<?> getDependency() {
            return (Dependency)Iterables.getOnlyElement(this.dependencies);
        }

        boolean containsElement(Element element) {
            javax.inject.Provider providerInstance;
            if (element instanceof ProviderInstanceBinding && (providerInstance = ((ProviderInstanceBinding)element).getUserSuppliedProvider()) instanceof RealOptionalBinderProviderWithDependencies) {
                return ((RealOptionalBinderProviderWithDependencies)providerInstance).bindingSelection.equals(this);
            }
            if (element instanceof Binding) {
                Key elementKey = ((Binding)element).getKey();
                return elementKey.equals(this.getKeyForActualBinding()) || elementKey.equals(this.getKeyForDefaultBinding());
            }
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof BindingSelection && ((BindingSelection)o).key.equals(this.key);
        }

        public int hashCode() {
            return this.key.hashCode();
        }
    }

    private static final class RealOptionalKeyProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, Optional<T>>
    implements ProviderWithExtensionVisitor<Optional<T>>,
    OptionalBinderBinding<Optional<T>> {
        private final Key<Optional<T>> optionalKey;
        private Dependency<?> targetDependency;
        private InternalFactory<? extends T> delegate;

        RealOptionalKeyProvider(BindingSelection<T> bindingSelection, Key<Optional<T>> optionalKey) {
            super(bindingSelection);
            this.optionalKey = optionalKey;
        }

        @Override
        void doInitialize() {
            if (this.bindingSelection.getBinding() != null) {
                this.delegate = this.bindingSelection.getBinding().getInternalFactory();
                this.targetDependency = this.bindingSelection.getDependency();
            }
        }

        @Override
        protected Optional<T> doProvision(InternalContext context, Dependency<?> currentDependency) throws InternalProvisionException {
            T result;
            InternalFactory<T> local = this.delegate;
            if (local == null) {
                return Optional.absent();
            }
            Dependency<?> localDependency = this.targetDependency;
            Dependency<?> previous = context.pushDependency(localDependency, this.getSource());
            try {
                result = local.get(context, localDependency, false);
            }
            catch (InternalProvisionException ipe) {
                throw ipe.addSource(localDependency);
            }
            finally {
                context.popStateAndSetDependency(previous);
            }
            return Optional.fromNullable(result);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies();
        }

        @Override
        public <B, R> R acceptExtensionVisitor(BindingTargetVisitor<B, R> visitor, ProviderInstanceBinding<? extends B> binding) {
            if (visitor instanceof MultibindingsTargetVisitor) {
                return (R)((MultibindingsTargetVisitor)visitor).visit(this);
            }
            return visitor.visit(binding);
        }

        @Override
        public Key<Optional<T>> getKey() {
            return this.optionalKey;
        }

        @Override
        public Binding<?> getActualBinding() {
            return this.bindingSelection.getActualBinding();
        }

        @Override
        public Binding<?> getDefaultBinding() {
            return this.bindingSelection.getDefaultBinding();
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }
    }

    private static final class RealOptionalProviderProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, Optional<Provider<T>>> {
        private Optional<Provider<T>> value;

        RealOptionalProviderProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            this.value = this.bindingSelection.getBinding() == null ? Optional.absent() : Optional.of(this.bindingSelection.getBinding().getProvider());
        }

        @Override
        protected Optional<Provider<T>> doProvision(InternalContext context, Dependency<?> dependency) {
            return this.value;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.providerDependencies();
        }
    }

    private static final class RealDirectTypeProvider<T>
    extends RealOptionalBinderProviderWithDependencies<T, T> {
        private Key<? extends T> targetKey;
        private Object targetSource;
        private InternalFactory<? extends T> targetFactory;

        RealDirectTypeProvider(BindingSelection<T> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            BindingImpl targetBinding = this.bindingSelection.getBinding();
            this.targetKey = targetBinding.getKey();
            this.targetSource = targetBinding.getSource();
            this.targetFactory = targetBinding.getInternalFactory();
        }

        @Override
        protected T doProvision(InternalContext context, Dependency<?> dependency) throws InternalProvisionException {
            context.pushState(this.targetKey, this.targetSource);
            try {
                T t = this.targetFactory.get(context, dependency, true);
                return t;
            }
            catch (InternalProvisionException ipe) {
                throw ipe.addSource(this.targetKey);
            }
            finally {
                context.popState();
            }
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies;
        }
    }

    private static final class JavaOptionalProviderProvider
    extends RealOptionalBinderProviderWithDependencies {
        private Object value;

        JavaOptionalProviderProvider(BindingSelection<?> bindingSelection) {
            super(bindingSelection);
        }

        @Override
        void doInitialize() {
            this.value = this.bindingSelection.getBinding() == null ? JAVA_OPTIONAL_EMPTY : RealOptionalBinder.invokeJavaOptionalOf(this.bindingSelection.getBinding().getProvider());
        }

        @Override
        protected Object doProvision(InternalContext context, Dependency dependency) {
            return this.value;
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.providerDependencies();
        }
    }

    private static final class JavaOptionalProvider
    extends RealOptionalBinderProviderWithDependencies
    implements ProviderWithExtensionVisitor,
    OptionalBinderBinding {
        private final Key<?> optionalKey;
        private Dependency<?> targetDependency;
        private InternalFactory<?> target;

        JavaOptionalProvider(BindingSelection<?> bindingSelection, Key<?> optionalKey) {
            super(bindingSelection);
            this.optionalKey = optionalKey;
        }

        @Override
        void doInitialize() {
            if (this.bindingSelection.getBinding() != null) {
                this.target = this.bindingSelection.getBinding().getInternalFactory();
                this.targetDependency = this.bindingSelection.getDependency();
            }
        }

        @Override
        protected Object doProvision(InternalContext context, Dependency dependency) throws InternalProvisionException {
            Object result;
            InternalFactory<?> local = this.target;
            if (local == null) {
                return JAVA_OPTIONAL_EMPTY;
            }
            Dependency<?> localDependency = this.targetDependency;
            Dependency<?> previous = context.pushDependency(localDependency, this.getSource());
            try {
                result = local.get(context, localDependency, false);
            }
            catch (InternalProvisionException ipe) {
                throw ipe.addSource(localDependency);
            }
            finally {
                context.popStateAndSetDependency(previous);
            }
            return RealOptionalBinder.invokeJavaOptionalOfNullable(result);
        }

        @Override
        public Set<Dependency<?>> getDependencies() {
            return this.bindingSelection.dependencies;
        }

        public Object acceptExtensionVisitor(BindingTargetVisitor visitor, ProviderInstanceBinding binding) {
            if (visitor instanceof MultibindingsTargetVisitor) {
                return ((MultibindingsTargetVisitor)visitor).visit(this);
            }
            return visitor.visit(binding);
        }

        @Override
        public boolean containsElement(Element element) {
            return this.bindingSelection.containsElement(element);
        }

        @Override
        public Binding<?> getActualBinding() {
            return this.bindingSelection.getActualBinding();
        }

        @Override
        public Binding<?> getDefaultBinding() {
            return this.bindingSelection.getDefaultBinding();
        }

        public Key getKey() {
            return this.optionalKey;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Actual {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Qualifier
    static @interface Default {
        public String value();
    }

    static enum Source {
        DEFAULT,
        ACTUAL;

    }
}

