/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.app.PendingIntent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.location.zzam;
import java.util.Collections;
import java.util.List;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="RemoveGeofencingRequestCreator")
public final class zzal
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<zzal> CREATOR = new zzam();
    @SafeParcelable.Field(id=1, getter="getGeofenceIds")
    private final List<String> zzbu;
    @SafeParcelable.Field(id=2, getter="getPendingIntent")
    private final PendingIntent zzbv;
    @SafeParcelable.Field(id=3, getter="getTag", defaultValue="")
    private final String tag;

    public static zzal zza(List<String> list) {
        Preconditions.checkNotNull(list, (Object)"geofence can't be null.");
        Preconditions.checkArgument((!list.isEmpty() ? 1 : 0) != 0, (Object)"Geofences must contains at least one id.");
        return new zzal(list, null, "");
    }

    public static zzal zza(PendingIntent pendingIntent) {
        Preconditions.checkNotNull((Object)pendingIntent, (Object)"PendingIntent can not be null.");
        return new zzal(null, pendingIntent, "");
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzal zzal2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)1, zzal2.zzbu, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)2, (Parcelable)zzal2.zzbv, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)zzal2.tag, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    @SafeParcelable.Constructor
    zzal(@SafeParcelable.Param(id=1) @Nullable List<String> list, @SafeParcelable.Param(id=2) @Nullable PendingIntent pendingIntent, @SafeParcelable.Param(id=3) String string) {
        this.zzbu = list == null ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.zzbv = pendingIntent;
        this.tag = string;
    }
}

