/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.zzai;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="LocationSettingsStatesCreator")
public final class LocationSettingsStates
extends AbstractSafeParcelable {
    @SafeParcelable.Field(id=1, getter="isGpsUsable")
    private final boolean zzbn;
    @SafeParcelable.Field(id=2, getter="isNetworkLocationUsable")
    private final boolean zzbo;
    @SafeParcelable.Field(id=3, getter="isBleUsable")
    private final boolean zzbp;
    @SafeParcelable.Field(id=4, getter="isGpsPresent")
    private final boolean zzbq;
    @SafeParcelable.Field(id=5, getter="isNetworkLocationPresent")
    private final boolean zzbr;
    @SafeParcelable.Field(id=6, getter="isBlePresent")
    private final boolean zzbs;
    public static final Parcelable.Creator<LocationSettingsStates> CREATOR = new zzai();

    @SafeParcelable.Constructor
    public LocationSettingsStates(@SafeParcelable.Param(id=1) boolean bl, @SafeParcelable.Param(id=2) boolean bl2, @SafeParcelable.Param(id=3) boolean bl3, @SafeParcelable.Param(id=4) boolean bl4, @SafeParcelable.Param(id=5) boolean bl5, @SafeParcelable.Param(id=6) boolean bl6) {
        this.zzbn = bl;
        this.zzbo = bl2;
        this.zzbp = bl3;
        this.zzbq = bl4;
        this.zzbr = bl5;
        this.zzbs = bl6;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        LocationSettingsStates locationSettingsStates = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)1, (boolean)locationSettingsStates.isGpsUsable());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)locationSettingsStates.isNetworkLocationUsable());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)locationSettingsStates.isBleUsable());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)4, (boolean)locationSettingsStates.isGpsPresent());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)locationSettingsStates.isNetworkLocationPresent());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)6, (boolean)locationSettingsStates.isBlePresent());
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isGpsUsable() {
        return this.zzbn;
    }

    public final boolean isGpsPresent() {
        return this.zzbq;
    }

    public final boolean isNetworkLocationUsable() {
        return this.zzbo;
    }

    public final boolean isNetworkLocationPresent() {
        return this.zzbr;
    }

    public final boolean isLocationUsable() {
        return this.zzbn || this.zzbo;
    }

    public final boolean isLocationPresent() {
        return this.zzbq || this.zzbr;
    }

    public final boolean isBleUsable() {
        return this.zzbp;
    }

    public final boolean isBlePresent() {
        return this.zzbs;
    }

    public static LocationSettingsStates fromIntent(Intent intent) {
        return (LocationSettingsStates)SafeParcelableSerializer.deserializeFromIntentExtra((Intent)intent, (String)"com.google.android.gms.location.LOCATION_SETTINGS_STATES", CREATOR);
    }
}

