/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location;

import android.content.Intent;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.android.gms.common.internal.ClientIdentity;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.location.ActivityTransition;
import com.google.android.gms.location.zze;
import com.google.android.gms.location.zzf;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="ActivityTransitionRequestCreator")
public class ActivityTransitionRequest
extends AbstractSafeParcelable {
    public static final Parcelable.Creator<ActivityTransitionRequest> CREATOR = new zzf();
    public static final Comparator<ActivityTransition> IS_SAME_TRANSITION = new zze();
    @SafeParcelable.Field(id=1, getter="getActivityTransitions")
    private final List<ActivityTransition> zzl;
    @SafeParcelable.Field(id=2, getter="getTag")
    @Nullable
    private final String tag;
    @SafeParcelable.Field(id=3, getter="getClients")
    private final List<ClientIdentity> zzm;

    @SafeParcelable.Constructor
    public ActivityTransitionRequest(@SafeParcelable.Param(id=1) List<ActivityTransition> list, @SafeParcelable.Param(id=2) @Nullable String string, @SafeParcelable.Param(id=3) @Nullable List<ClientIdentity> list2) {
        Preconditions.checkNotNull(list, (Object)"transitions can't be null");
        Preconditions.checkArgument((list.size() > 0 ? 1 : 0) != 0, (Object)"transitions can't be empty.");
        List<ActivityTransition> list3 = list;
        TreeSet<ActivityTransition> treeSet = new TreeSet<ActivityTransition>(IS_SAME_TRANSITION);
        for (ActivityTransition activityTransition : list3) {
            Preconditions.checkArgument((boolean)treeSet.add(activityTransition), (Object)String.format("Found duplicated transition: %s.", new Object[]{activityTransition}));
        }
        this.zzl = Collections.unmodifiableList(list);
        this.tag = string;
        this.zzm = list2 == null ? Collections.emptyList() : Collections.unmodifiableList(list2);
    }

    public ActivityTransitionRequest(List<ActivityTransition> list) {
        this(list, null, null);
    }

    public void serializeToIntentExtra(Intent intent) {
        SafeParcelableSerializer.serializeToIntentExtra((SafeParcelable)this, (Intent)intent, (String)"com.google.android.location.internal.EXTRA_ACTIVITY_TRANSITION_REQUEST");
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        ActivityTransitionRequest activityTransitionRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)1, activityTransitionRequest.zzl, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)activityTransitionRequest.tag, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)3, activityTransitionRequest.zzm, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || ((Object)((Object)this)).getClass() != object.getClass()) {
            return false;
        }
        ActivityTransitionRequest activityTransitionRequest = (ActivityTransitionRequest)((Object)object);
        return Objects.equal(this.zzl, activityTransitionRequest.zzl) && Objects.equal((Object)this.tag, (Object)activityTransitionRequest.tag) && Objects.equal(this.zzm, activityTransitionRequest.zzm);
    }

    public String toString() {
        String string = String.valueOf(this.zzl);
        String string2 = this.tag;
        String string3 = String.valueOf(this.zzm);
        return new StringBuilder(61 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append("ActivityTransitionRequest [mTransitions=").append(string).append(", mTag='").append(string2).append('\'').append(", mClients=").append(string3).append(']').toString();
    }

    public int hashCode() {
        int n = this.zzl.hashCode();
        n = n * 31 + (this.tag != null ? this.tag.hashCode() : 0);
        return n * 31 + (this.zzm != null ? this.zzm.hashCode() : 0);
    }
}

