/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.u2f.api.common;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.fido.u2f.api.common.ChannelIdValue;
import com.google.android.gms.fido.u2f.api.common.RegisteredKey;
import com.google.android.gms.fido.u2f.api.common.RequestParams;
import com.google.android.gms.fido.u2f.api.common.zzk;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

@Deprecated
@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="SignRequestParamsCreator")
public class SignRequestParams
extends RequestParams {
    @NonNull
    public static final Parcelable.Creator<SignRequestParams> CREATOR = new zzk();
    public static final int MAX_DISPLAY_HINT_LENGTH = 80;
    @SafeParcelable.Field(id=2, getter="getRequestId")
    private final Integer zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getTimeoutSeconds")
    private final Double zzb;
    @SafeParcelable.Field(id=4, getter="getAppId")
    private final Uri zzc;
    @SafeParcelable.Field(id=5, getter="getDefaultSignChallenge")
    private final byte[] zzd;
    @SafeParcelable.Field(id=6, getter="getRegisteredKeys")
    private final List zze;
    @SafeParcelable.Field(id=7, getter="getChannelIdValue")
    private final ChannelIdValue zzf;
    @SafeParcelable.Field(id=8, getter="getDisplayHint")
    private final String zzg;
    private final Set zzh;

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzc, this.zzb, this.zze, this.zzf, this.zzg, Arrays.hashCode(this.zzd)});
    }

    @Override
    @NonNull
    public Uri getAppId() {
        return this.zzc;
    }

    @Override
    @NonNull
    public ChannelIdValue getChannelIdValue() {
        return this.zzf;
    }

    @Override
    @Nullable
    public Double getTimeoutSeconds() {
        return this.zzb;
    }

    @Override
    @NonNull
    public Integer getRequestId() {
        return this.zza;
    }

    @Override
    @NonNull
    public String getDisplayHint() {
        return this.zzg;
    }

    @Override
    @NonNull
    public List<RegisteredKey> getRegisteredKeys() {
        return this.zze;
    }

    @Override
    @NonNull
    public Set<Uri> getAllAppIds() {
        return this.zzh;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SafeParcelable.Constructor
    SignRequestParams(@SafeParcelable.Param(id=2) Integer n, @Nullable @SafeParcelable.Param(id=3) Double serializable, @SafeParcelable.Param(id=4) Uri uri, @SafeParcelable.Param(id=5) byte[] object, @SafeParcelable.Param(id=6) List list, @SafeParcelable.Param(id=7) ChannelIdValue abstractSafeParcelable2, @SafeParcelable.Param(id=8) String string) {
        this.zza = n;
        this.zzb = serializable;
        this.zzc = uri;
        this.zzd = (byte[])object;
        boolean bl = list != null ? !list.isEmpty() : false;
        Preconditions.checkArgument((boolean)bl, (Object)"registeredKeys must not be null or empty");
        this.zze = list;
        this.zzf = abstractSafeParcelable2;
        if (uri != null) {
            serializable.add(uri);
        }
        for (AbstractSafeParcelable abstractSafeParcelable2 : list) {
            bl = abstractSafeParcelable2.getAppId() == null ? uri != null : true;
            Preconditions.checkArgument((boolean)bl, (Object)"registered key has null appId and no request appId is provided");
            bl = abstractSafeParcelable2.getChallengeValue() == null ? list != null : true;
            Preconditions.checkArgument((boolean)bl, (Object)"register request has null challenge and no default challenge isprovided");
            if (abstractSafeParcelable2.getAppId() == null) continue;
            serializable.add(Uri.parse((String)abstractSafeParcelable2.getAppId()));
        }
        this.zzh = serializable;
        bl = string != null ? string.length() <= 80 : true;
        Preconditions.checkArgument((boolean)bl, (Object)"Display Hint cannot be longer than 80 characters");
        this.zzg = string;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int flags) {
        void var2_2;
        void var1_1;
        int n = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeIntegerObject((Parcel)var1_1, (int)2, (Integer)this.getRequestId(), (boolean)false);
        SafeParcelWriter.writeDoubleObject((Parcel)var1_1, (int)3, (Double)this.getTimeoutSeconds(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)4, (Parcelable)this.getAppId(), (int)var2_2, (boolean)false);
        SafeParcelWriter.writeByteArray((Parcel)var1_1, (int)5, (byte[])this.getDefaultSignChallenge(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)var1_1, (int)6, this.getRegisteredKeys(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)var1_1, (int)7, (Parcelable)this.getChannelIdValue(), (int)var2_2, (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeString((Parcel)v1, (int)8, (String)this.getDisplayHint(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n);
    }

    public boolean equals(@NonNull Object o) {
        SignRequestParams signRequestParams;
        if (this == signRequestParams) {
            return true;
        }
        if (!(signRequestParams instanceof SignRequestParams)) {
            return false;
        }
        signRequestParams = signRequestParams;
        return Objects.equal((Object)this.zza, (Object)signRequestParams.zza) && Objects.equal((Object)this.zzb, (Object)signRequestParams.zzb) && Objects.equal((Object)this.zzc, (Object)signRequestParams.zzc) && Arrays.equals(this.zzd, signRequestParams.zzd) && this.zze.containsAll(signRequestParams.zze) && signRequestParams.zze.containsAll(this.zze) && Objects.equal((Object)((Object)this.zzf), (Object)((Object)signRequestParams.zzf)) && Objects.equal((Object)this.zzg, (Object)signRequestParams.zzg);
    }

    @NonNull
    public byte[] getDefaultSignChallenge() {
        return this.zzd;
    }

    public static final class Builder {
        Integer zza;
        @Nullable
        Double zzb;
        Uri zzc;
        byte[] zzd;
        List zze;
        ChannelIdValue zzf;
        String zzg;

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setAppId(@NonNull Uri appId) {
            void var1_1;
            this.zzc = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setChannelIdValue(@NonNull ChannelIdValue channelIdValue) {
            void var1_1;
            this.zzf = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDefaultSignChallenge(@NonNull byte[] defaultSignChallenge) {
            void var1_1;
            this.zzd = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setDisplayHint(@NonNull String displayHint) {
            void var1_1;
            this.zzg = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRegisteredKeys(@NonNull List<RegisteredKey> registeredKeys) {
            void var1_1;
            this.zze = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setRequestId(@NonNull Integer requestId) {
            void var1_1;
            this.zza = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @NonNull
        public Builder setTimeoutSeconds(@Nullable Double timeoutSeconds) {
            void var1_1;
            this.zzb = var1_1;
            return this;
        }

        @NonNull
        public SignRequestParams build() {
            return new SignRequestParams(this.zza, this.zzb, this.zzc, this.zzd, this.zze, this.zzf, this.zzg);
        }
    }
}

