/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.fido.fido2.api.common.Algorithm;
import com.google.android.gms.fido.fido2.api.common.EC2Algorithm;
import com.google.android.gms.fido.fido2.api.common.RSAAlgorithm;
import com.google.android.gms.fido.fido2.api.common.zzp;

public class COSEAlgorithmIdentifier
implements Parcelable {
    @NonNull
    public static final Parcelable.Creator<COSEAlgorithmIdentifier> CREATOR = new zzp();
    @NonNull
    private final Algorithm zza;

    public int describeContents() {
        return 0;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza});
    }

    public int toCoseValue() {
        return this.zza.getAlgoValue();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NonNull
    public static COSEAlgorithmIdentifier fromCoseValue(int value) throws UnsupportedAlgorithmIdentifierException {
        void var0_2;
        int n;
        if (n == RSAAlgorithm.LEGACY_RS1.getAlgoValue()) {
            RSAAlgorithm rSAAlgorithm = RSAAlgorithm.RS1;
            return new COSEAlgorithmIdentifier((Algorithm)var0_2);
        }
        for (RSAAlgorithm rSAAlgorithm : RSAAlgorithm.values()) {
            if (rSAAlgorithm.getAlgoValue() != n) continue;
            RSAAlgorithm rSAAlgorithm2 = rSAAlgorithm;
            return new COSEAlgorithmIdentifier((Algorithm)var0_2);
        }
        Enum[] enumArray = EC2Algorithm.values();
        int n2 = enumArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Enum enum_ = enumArray[n3];
            if (((EC2Algorithm)enum_).getAlgoValue() == n) {
                Enum enum_2 = enum_;
                return new COSEAlgorithmIdentifier((Algorithm)var0_2);
            }
            ++n3;
        }
        throw new UnsupportedAlgorithmIdentifierException(n);
    }

    COSEAlgorithmIdentifier(@NonNull Algorithm algorithm) {
        this.zza = (Algorithm)Preconditions.checkNotNull((Object)algorithm);
    }

    public void writeToParcel(@NonNull Parcel parcel, int n) {
        parcel.writeInt(this.zza.getAlgoValue());
    }

    public boolean equals(@NonNull Object obj) {
        COSEAlgorithmIdentifier cOSEAlgorithmIdentifier;
        if (!(obj instanceof COSEAlgorithmIdentifier)) {
            return false;
        }
        cOSEAlgorithmIdentifier = cOSEAlgorithmIdentifier;
        return this.zza.getAlgoValue() == cOSEAlgorithmIdentifier.zza.getAlgoValue();
    }

    public static class UnsupportedAlgorithmIdentifierException
    extends Exception {
        /*
         * WARNING - void declaration
         */
        public UnsupportedAlgorithmIdentifierException(int algId) {
            void var1_1;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Algorithm with COSE value ");
            stringBuilder.append((int)var1_1);
            stringBuilder.append(" not supported");
            super(stringBuilder.toString());
        }
    }
}

