/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.fido.fido2.api.common;

import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelableSerializer;
import com.google.android.gms.fido.fido2.api.common.AuthenticatorResponse;
import com.google.android.gms.fido.fido2.api.common.ErrorCode;
import com.google.android.gms.fido.fido2.api.common.zzl;
import com.google.android.gms.internal.fido.zzam;
import com.google.android.gms.internal.fido.zzan;
import org.json.JSONException;
import org.json.JSONObject;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="AuthenticatorErrorResponseCreator")
public class AuthenticatorErrorResponse
extends AuthenticatorResponse {
    @NonNull
    public static final Parcelable.Creator<AuthenticatorErrorResponse> CREATOR = new zzl();
    @NonNull
    @SafeParcelable.Field(id=2, getter="getErrorCodeAsInt", type="int")
    private final ErrorCode zza;
    @Nullable
    @SafeParcelable.Field(id=3, getter="getErrorMessage")
    private final String zzb;
    @SafeParcelable.Field(id=4, getter="getInternalErrorCode", type="int", defaultValue="0")
    private final int zzc;

    public int getErrorCodeAsInt() {
        return this.zza.getCode();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zza, this.zzb, this.zzc});
    }

    @NonNull
    public static AuthenticatorErrorResponse deserializeFromBytes(@NonNull byte[] serializedBytes) {
        return (AuthenticatorErrorResponse)SafeParcelableSerializer.deserializeFromBytes((byte[])serializedBytes, CREATOR);
    }

    @NonNull
    public ErrorCode getErrorCode() {
        return this.zza;
    }

    @Nullable
    public String getErrorMessage() {
        return this.zzb;
    }

    @NonNull
    public String toString() {
        zzam zzam2 = zzan.zza(this_);
        int n = this_.zza.getCode();
        zzam2.zza("errorCode", n);
        Object this_ = this_.zzb;
        if (this_ != null) {
            zzam2.zzb("errorMessage", this_);
        }
        return zzam2.toString();
    }

    @SafeParcelable.Constructor
    AuthenticatorErrorResponse(@NonNull @SafeParcelable.Param(id=2) int n, @Nullable @SafeParcelable.Param(id=3) String string, @SafeParcelable.Param(id=4) int n2) {
        try {
            this.zza = ErrorCode.toErrorCode(n);
        }
        catch (ErrorCode.UnsupportedErrorCodeException unsupportedErrorCodeException) {
            throw new IllegalArgumentException(unsupportedErrorCodeException);
        }
        this.zzb = string;
        this.zzc = n2;
    }

    /*
     * WARNING - void declaration
     */
    public void writeToParcel(@NonNull Parcel dest, int n) {
        void var1_1;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)dest);
        SafeParcelWriter.writeInt((Parcel)var1_1, (int)2, (int)this.getErrorCodeAsInt());
        SafeParcelWriter.writeString((Parcel)var1_1, (int)3, (String)this.getErrorMessage(), (boolean)false);
        void v1 = var1_1;
        SafeParcelWriter.writeInt((Parcel)v1, (int)4, (int)this.zzc);
        SafeParcelWriter.finishObjectHeader((Parcel)v1, (int)n2);
    }

    public boolean equals(@NonNull Object obj) {
        AuthenticatorErrorResponse authenticatorErrorResponse;
        if (!(obj instanceof AuthenticatorErrorResponse)) {
            return false;
        }
        authenticatorErrorResponse = authenticatorErrorResponse;
        return Objects.equal((Object)((Object)this.zza), (Object)((Object)authenticatorErrorResponse.zza)) && Objects.equal((Object)this.zzb, (Object)authenticatorErrorResponse.zzb) && Objects.equal((Object)this.zzc, (Object)authenticatorErrorResponse.zzc);
    }

    @Override
    @NonNull
    public byte[] getClientDataJSON() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NonNull
    public byte[] serializeToBytes() {
        return SafeParcelableSerializer.serializeToBytes((SafeParcelable)this);
    }

    @NonNull
    public final JSONObject zza() {
        JSONObject jSONObject;
        block3: {
            try {
                jSONObject = new JSONObject();
                jSONObject.put("code", object.zza.getCode());
                Object object = object.zzb;
                if (object == null) break block3;
            }
            catch (JSONException jSONException) {
                throw new RuntimeException("Error encoding AuthenticatorErrorResponse to JSON object", jSONException);
            }
            String string = "message";
            jSONObject.put(string, object);
        }
        return jSONObject;
    }
}

