/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.Feature;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.internal.ConnectionCallbacks;
import com.google.android.gms.common.api.internal.OnConnectionFailedListener;
import com.google.android.gms.common.api.internal.zacf;
import com.google.android.gms.common.api.internal.zacg;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.GmsClientSupervisor;
import com.google.android.gms.common.internal.IAccountAccessor;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zaq;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;

@KeepForSdk
public final class NonGmsServiceBrokerClient
implements Api.Client,
ServiceConnection {
    private static final String zaa = NonGmsServiceBrokerClient.class.getSimpleName();
    @Nullable
    private final String zab;
    @Nullable
    private final String zac;
    @Nullable
    private final ComponentName zad;
    private final Context zae;
    private final ConnectionCallbacks zaf;
    private final Handler zag;
    private final OnConnectionFailedListener zah;
    @Nullable
    private IBinder zai;
    private boolean zaj;
    @Nullable
    private String zak;
    @Nullable
    private String zal;

    @Override
    public final int getMinApkVersion() {
        return 0;
    }

    @Override
    @NonNull
    public final Intent getSignInIntent() {
        NonGmsServiceBrokerClient nonGmsServiceBrokerClient = new Intent();
        return nonGmsServiceBrokerClient;
    }

    @WorkerThread
    @Nullable
    @KeepForSdk
    public IBinder getBinder() {
        this.zad();
        return this.zai;
    }

    @Override
    @Nullable
    public final IBinder getServiceBrokerBinder() {
        return null;
    }

    @Override
    @NonNull
    public final String getEndpointPackageName() {
        String string2 = this.zab;
        if (string2 != null) {
            return string2;
        }
        Preconditions.checkNotNull((Object)this.zad);
        return this.zad.getPackageName();
    }

    @Override
    @Nullable
    public final String getLastDisconnectMessage() {
        return this.zak;
    }

    @Override
    @NonNull
    public final Set<Scope> getScopesForConnectionlessNonSignIn() {
        return Collections.emptySet();
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public NonGmsServiceBrokerClient(@NonNull Context context, @NonNull Looper looper, @NonNull ComponentName componentName, @NonNull ConnectionCallbacks callbacks, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, null, null, (ComponentName)var3_3, (ConnectionCallbacks)var4_4, (OnConnectionFailedListener)var5_5);
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @KeepForSdk
    public NonGmsServiceBrokerClient(@NonNull Context context, @NonNull Looper looper, @NonNull String packageName, @NonNull String action, @NonNull ConnectionCallbacks callbacks, @NonNull OnConnectionFailedListener connectionFailedListener) {
        this((Context)var1_1, (Looper)var2_2, (String)var3_3, (String)var4_4, null, (ConnectionCallbacks)var5_5, (OnConnectionFailedListener)var6_6);
        void var6_6;
        void var5_5;
        void var4_4;
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private NonGmsServiceBrokerClient(Context object, Looper looper, @Nullable String string2, @Nullable String string3, @Nullable ComponentName componentName, ConnectionCallbacks connectionCallbacks, OnConnectionFailedListener onConnectionFailedListener) {
        void var1_4;
        void var4_8;
        void var3_7;
        block4: {
            void var5_9;
            block5: {
                block3: {
                    block2: {
                        void var7_11;
                        void var6_10;
                        void var2_6;
                        ((NonGmsServiceBrokerClient)object2).zaj = false;
                        ((NonGmsServiceBrokerClient)object2).zak = null;
                        ((NonGmsServiceBrokerClient)object2).zae = object;
                        zaq zaq2 = new zaq((Looper)var2_6);
                        ((NonGmsServiceBrokerClient)object2).zag = zaq2;
                        ((NonGmsServiceBrokerClient)object2).zaf = var6_10;
                        ((NonGmsServiceBrokerClient)object2).zah = var7_11;
                        if (var3_7 == null || var4_8 == null) break block2;
                        if (var5_9 != null) break block3;
                        Object var1_3 = null;
                        break block4;
                    }
                    if (var5_9 != null) break block5;
                }
                Object object2 = new AssertionError((Object)"Must specify either package or component, but not both");
                throw object2;
            }
            void var1_5 = var5_9;
        }
        ((NonGmsServiceBrokerClient)object2).zab = var3_7;
        ((NonGmsServiceBrokerClient)object2).zac = var4_8;
        ((NonGmsServiceBrokerClient)object2).zad = var1_4;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void connect(@NonNull BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        block8: {
            OnConnectionFailedListener onConnectionFailedListener;
            ComponentName componentName;
            this.zad();
            this.zae("Connect started.");
            if (this.isConnected()) {
                try {
                    this.disconnect("connect() called when already connected");
                }
                catch (Exception exception) {}
            }
            try {
                boolean bl;
                connectionProgressReportCallbacks = new Intent();
                componentName = this.zad;
                if (componentName != null) {
                    connectionProgressReportCallbacks.setComponent(componentName);
                } else {
                    connectionProgressReportCallbacks.setPackage(this.zab).setAction(this.zac);
                }
                this.zaj = bl = this.zae.bindService((Intent)connectionProgressReportCallbacks, (ServiceConnection)this, GmsClientSupervisor.getDefaultBindFlags());
                if (bl) break block8;
                this.zai = null;
                onConnectionFailedListener = this.zah;
            }
            catch (SecurityException securityException) {
                this.zaj = false;
                this.zai = null;
                throw securityException;
            }
            componentName = new ConnectionResult(16);
            onConnectionFailedListener.onConnectionFailed((ConnectionResult)componentName);
        }
        this.zae("Finished connect.");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @WorkerThread
    public final void disconnect() {
        this.zad();
        this.zae("Disconnect called.");
        try {
            this.zae.unbindService((ServiceConnection)this);
        }
        catch (IllegalArgumentException illegalArgumentException) {}
        this.zaj = false;
        this.zai = null;
    }

    @Override
    @WorkerThread
    public final void disconnect(@NonNull String string2) {
        this.zad();
        this.zak = string2;
        this.disconnect();
    }

    @Override
    public final void dump(@NonNull String string2, @Nullable FileDescriptor fileDescriptor, @NonNull PrintWriter printWriter, @Nullable String[] stringArray) {
    }

    @Override
    public final void getRemoteService(@Nullable IAccountAccessor iAccountAccessor, @Nullable Set<Scope> set) {
    }

    public final void onServiceConnected(@NonNull ComponentName componentName, @NonNull IBinder iBinder) {
        componentName = this.zag;
        zacg zacg2 = new zacg(this, iBinder);
        componentName.post((Runnable)zacg2);
    }

    public final void onServiceDisconnected(@NonNull ComponentName componentName) {
        componentName = this.zag;
        zacf zacf2 = new zacf(this);
        componentName.post((Runnable)zacf2);
    }

    @Override
    public final void onUserSignOut(@NonNull BaseGmsClient.SignOutCallbacks signOutCallbacks) {
    }

    @Override
    @WorkerThread
    public final boolean isConnected() {
        this.zad();
        return this.zai != null;
    }

    @Override
    @WorkerThread
    public final boolean isConnecting() {
        this.zad();
        return this.zaj;
    }

    @Override
    public final boolean providesSignIn() {
        return false;
    }

    @Override
    public final boolean requiresAccount() {
        return false;
    }

    @Override
    public final boolean requiresGooglePlayServices() {
        return false;
    }

    @Override
    public final boolean requiresSignIn() {
        return false;
    }

    @Override
    @NonNull
    public final Feature[] getAvailableFeatures() {
        return new Feature[0];
    }

    @Override
    @NonNull
    public final Feature[] getRequiredFeatures() {
        return new Feature[0];
    }

    @WorkerThread
    private final void zad() {
        if (Thread.currentThread() != ((NonGmsServiceBrokerClient)object).zag.getLooper().getThread()) {
            Object object = new IllegalStateException("This method should only run on the NonGmsServiceBrokerClient's handler thread.");
            throw object;
        }
    }

    final /* synthetic */ void zaa(IBinder iBinder) {
        ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zaj = false;
        ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zai = iBinder;
        ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zae("Connected.");
        ConnectionCallbacks connectionCallbacks = ((NonGmsServiceBrokerClient)((Object)connectionCallbacks)).zaf;
        iBinder = new Bundle();
        connectionCallbacks.onConnected((Bundle)iBinder);
    }

    final /* synthetic */ void zab() {
        this.zaj = false;
        this.zai = null;
        this.zae("Disconnected.");
        this.zaf.onConnectionSuspended(1);
    }

    private final void zae(String string2) {
        String.valueOf(String.valueOf(this.zai)).length();
    }

    public final void zac(@Nullable String string2) {
        this.zal = string2;
    }
}

