/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgci;
import com.google.android.gms.internal.ads.zzgcj;
import com.google.android.gms.internal.ads.zzgnn;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.KeySpec;
import java.util.Arrays;
import javax.crypto.KeyAgreement;

public final class zzgne {
    public static int zza(EllipticCurve ellipticCurve) throws GeneralSecurityException {
        return (zzgcj.zza(ellipticCurve).subtract(BigInteger.ONE).bitLength() + 7) / 8;
    }

    public static KeyPair zzb(ECParameterSpec eCParameterSpec) throws GeneralSecurityException {
        KeyPairGenerator keyPairGenerator = (KeyPairGenerator)zzgnn.zzf.zza("EC");
        keyPairGenerator.initialize(eCParameterSpec);
        return keyPairGenerator.generateKeyPair();
    }

    public static void zzc(ECPublicKey eCPublicKey, ECPrivateKey eCPrivateKey) throws GeneralSecurityException {
        zzgne.zzd(eCPublicKey, eCPrivateKey);
        zzgcj.zzb(eCPublicKey.getW(), eCPrivateKey.getParams().getCurve());
    }

    static void zzd(ECPublicKey object, ECPrivateKey object2) throws GeneralSecurityException {
        block3: {
            object = object.getParams();
            object2 = object2.getParams();
            boolean bl = zzgcj.zzc((ECParameterSpec)object, (ECParameterSpec)object2);
            if (bl) break block3;
            try {
                throw new GeneralSecurityException("invalid public key spec");
            }
            catch (IllegalArgumentException | NullPointerException runtimeException) {
                throw new GeneralSecurityException(runtimeException);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] zze(ECPrivateKey var0, ECPublicKey var1_3) throws GeneralSecurityException {
        block20: {
            zzgne.zzd((ECPublicKey)var1_3, (ECPrivateKey)var0);
            var1_3 = var1_3.getW();
            zzgcj.zzb((ECPoint)var1_3, var0.getParams().getCurve());
            var2_8 = var0.getParams();
            var3_11 = new ECPublicKeySpec((ECPoint)var1_3, (ECParameterSpec)var2_8);
            var1_3 = ((KeyFactory)zzgnn.zzg.zza("EC")).generatePublic(var3_11);
            var2_8 = (KeyAgreement)zzgnn.zze.zza("ECDH");
            var2_8.init((Key)var0);
            try {
                block25: {
                    block23: {
                        block24: {
                            block22: {
                                block21: {
                                    var2_8.doPhase((Key)var1_3, true);
                                    var4_16 = var2_8.generateSecret();
                                    var0 = var0.getParams().getCurve();
                                    var1_3 = new BigInteger(1, var4_16);
                                    var2_9 = var1_3.signum();
                                    if (var2_9 == -1 || (var2_9 = var1_3.compareTo(zzgcj.zza((EllipticCurve)var0))) >= 0) {
                                        throw new GeneralSecurityException("shared secret is out of range");
                                    }
                                    var5_17 = zzgcj.zza((EllipticCurve)var0);
                                    var2_10 = var0.getA();
                                    var0 = var0.getB();
                                    v0 = var1_3;
                                    var0 = v0.multiply((BigInteger)v0).add(var2_10).multiply((BigInteger)var1_3).add((BigInteger)var0).mod(var5_17);
                                    var1_4 = var5_17.signum();
                                    if (var1_4 != 1) {
                                        var0 = "p must be positive";
                                        throw new InvalidAlgorithmParameterException((String)var0);
                                    }
                                    var6_18 = var0.mod(var5_17);
                                    var0_1 = var6_18.equals(BigInteger.ZERO);
                                    if (!var0_1) break block21;
                                    var0 = BigInteger.ZERO;
                                    ** GOTO lbl49
                                }
                                var0_1 = var5_17.testBit(0);
                                if (!var0_1 || !(var0_1 = var5_17.testBit(1))) break block22;
                                var0 = var6_18.modPow(var5_17.add(BigInteger.ONE).shiftRight(2), var5_17);
                                break block23;
                            }
                            var0_1 = var5_17.testBit(0);
                            if (!var0_1) break block24;
                            var0_1 = var5_17.testBit(1);
                            if (!var0_1) break block25;
                            var0 = null;
                            break block23;
                        }
                        var0 = null;
                    }
lbl47:
                    // 2 sources

                    while (true) {
                        block26: {
                            if (var0 != null) break block26;
lbl49:
                            // 4 sources

                            while (true) {
                                var1_5 = var0.testBit(0);
                                if (!var1_5) {
                                    var5_17.subtract((BigInteger)var0).mod(var5_17);
                                }
                                return var4_16;
                            }
                        }
                        v1 = var0;
                        var1_6 = v1.multiply((BigInteger)v1).mod(var5_17).compareTo(var6_18);
                        if (var1_6 == 0) ** GOTO lbl49
                        var0 = "Could not find a modular square root";
                        throw new GeneralSecurityException((String)var0);
                    }
                }
                var2_10 = var5_17.subtract(BigInteger.ONE).shiftRight(1);
                var0 = BigInteger.ONE;
                var1_4 = 0;
                do {
                    v2 = var0;
                    var7_19 = v2.multiply((BigInteger)v2).subtract(var6_18).mod(var5_17);
                    var3_12 = var7_19.equals(BigInteger.ZERO);
                    if (!var3_12) ** break;
                    ** continue;
                    var3_13 = var7_19.modPow(var2_10, var5_17);
                    var8_20 = var3_13.add(BigInteger.ONE).equals(var5_17);
                    if (var8_20) {
                        var8_21 = var5_17.add(BigInteger.ONE).shiftRight(1);
                        var2_10 = BigInteger.ONE;
                        var3_14 = var8_21.bitLength();
                        var1_7 = var0;
                        var3_14 -= 2;
                        break block20;
                    }
                    var3_15 = var3_13.equals(BigInteger.ONE);
                    if (!var3_15) {
                        var0 = "p is not prime";
                        throw new InvalidAlgorithmParameterException((String)var0);
                    }
                    var0 = var0.add(BigInteger.ONE);
                } while (++var1_4 != 128 || (var3_15 = var5_17.isProbablePrime(80)));
                var0 = "p is not prime";
                throw new InvalidAlgorithmParameterException((String)var0);
            }
            catch (IllegalStateException var0_2) {
                throw new GeneralSecurityException(var0_2);
            }
        }
        while (var3_14 >= 0) {
            v3 = var1_7.multiply(var2_10);
            v4 = var1_7;
            v5 = var2_10;
            var1_7 = v4.multiply((BigInteger)v4).add(v5.multiply(v5).mod(var5_17).multiply(var7_19)).mod(var5_17);
            var2_10 = v3.add(v3).mod(var5_17);
            var9_22 = var8_21.testBit(var3_14);
            if (var9_22) {
                var9_23 = var1_7.multiply((BigInteger)var0).add(var2_10.multiply(var7_19)).mod(var5_17);
                v6 = var0.multiply(var2_10).add((BigInteger)var1_7).mod(var5_17);
                var1_7 = var9_23;
                var2_10 = v6;
            }
            --var3_14;
        }
        var0 = var1_7;
        ** while (true)
    }

    public static ECPrivateKey zzf(int n, byte[] object) throws GeneralSecurityException {
        ECParameterSpec eCParameterSpec = zzgne.zzh(n);
        BigInteger bigInteger = new BigInteger(1, (byte[])object);
        object = new ECPrivateKeySpec;
        object(bigInteger, eCParameterSpec);
        return (ECPrivateKey)((KeyFactory)zzgnn.zzg.zza("EC")).generatePrivate((KeySpec)object);
    }

    public static ECPublicKey zzg(ECParameterSpec eCParameterSpec, int n, byte[] object) throws GeneralSecurityException {
        Object object2 = eCParameterSpec.getCurve();
        int n2 = zzgne.zza((EllipticCurve)object2);
        int n3 = n2++;
        int n4 = ((byte[])object).length;
        int n5 = n3 + n3;
        if (n4 != n5 + 1) {
            throw new GeneralSecurityException("invalid point size");
        }
        if (object[0] != 4) {
            throw new GeneralSecurityException("invalid point format");
        }
        BigInteger bigInteger = new BigInteger(1, Arrays.copyOfRange(object, 1, n2));
        BigInteger bigInteger2 = new BigInteger(1, Arrays.copyOfRange(object, n2, n4));
        object = new ECPoint;
        object(bigInteger, bigInteger2);
        zzgcj.zzb((ECPoint)object, (EllipticCurve)object2);
        object2 = new ECPublicKeySpec((ECPoint)object, eCParameterSpec);
        return (ECPublicKey)((KeyFactory)zzgnn.zzg.zza("EC")).generatePublic((KeySpec)object2);
    }

    public static ECParameterSpec zzh(int n) throws NoSuchAlgorithmException {
        switch (n + -1) {
            default: {
                return zzgcj.zzc;
            }
            case 0: {
                return zzgcj.zza;
            }
            case 1: 
        }
        return zzgcj.zzb;
    }

    public static byte[] zzi(int n, int n2, ECPoint eCPoint) throws GeneralSecurityException {
        return zzgne.zzj(zzgne.zzh(n).getCurve(), 1, eCPoint);
    }

    /*
     * Enabled aggressive block sorting
     */
    public static byte[] zzj(EllipticCurve object, int n, ECPoint object2) throws GeneralSecurityException {
        zzgcj.zzb((ECPoint)object2, (EllipticCurve)object);
        int n2 = zzgne.zza((EllipticCurve)object);
        switch (n + -1) {
            default: {
                int n3 = n2 + 1;
                byte[] byArray = new byte[n3];
                byte[] byArray2 = zzgci.zza(((ECPoint)object2).getAffineX());
                int n4 = byArray2.length;
                System.arraycopy(byArray2, 0, byArray, n3 - n4, n4);
                n3 = true != ((ECPoint)object2).getAffineY().testBit(0) ? 2 : 3;
                byArray[0] = n3;
                return byArray;
            }
            case 2: {
                byte[] byArray;
                int n5;
                int n6 = n2;
                byte[] byArray3 = new byte[n6 + n6];
                object = zzgci.zza(((ECPoint)object2).getAffineX());
                n = ((Object)object).length;
                if (n > n2) {
                    object = Arrays.copyOfRange((byte[])object, n - n2, n);
                }
                if ((n5 = (byArray = zzgci.zza(((ECPoint)object2).getAffineY())).length) > n2) {
                    byArray = Arrays.copyOfRange(byArray, n5 - n2, n5);
                }
                int n7 = n2;
                n5 = byArray.length;
                System.arraycopy(byArray, 0, byArray3, n7 + n7 - n5, n5);
                int n8 = ((Object)object).length;
                System.arraycopy(object, 0, byArray3, n2 - n8, n8);
                return byArray3;
            }
            case 0: 
        }
        int n9 = n2;
        int n10 = n9 + n9 + 1;
        byte[] byArray = new byte[n10];
        byte[] byArray4 = zzgci.zza(((ECPoint)object2).getAffineX());
        object2 = zzgci.zza(((ECPoint)object2).getAffineY());
        int n11 = ((Object)object2).length;
        System.arraycopy(object2, 0, byArray, n10 - n11, n11);
        n10 = byArray4.length;
        System.arraycopy(byArray4, 0, byArray, n2 + 1 - n10, n10);
        byArray[0] = 4;
        return byArray;
    }
}

