/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import com.google.android.gms.internal.ads.zzgag;
import com.google.android.gms.internal.ads.zzgmv;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;

abstract class zzgak {
    int[] zza;
    private final int zzb;

    abstract int zza();

    final ByteBuffer zzc(byte[] objectArray, int n) {
        objectArray = this.zzb(zzgag.zzd(objectArray), n);
        int[] nArray = (int[])objectArray.clone();
        zzgag.zzc(nArray);
        for (int i = 0; i < 16; ++i) {
            int n2 = i;
            objectArray[n2] = objectArray[i] + nArray[n2];
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(64).order(ByteOrder.LITTLE_ENDIAN);
        byteBuffer.asIntBuffer().put((int[])objectArray, 0, 16);
        return byteBuffer;
    }

    public zzgak(byte[] byArray, int n) throws InvalidKeyException {
        if (byArray.length != 32) {
            throw new InvalidKeyException("The key length in bytes must be 32.");
        }
        this.zza = zzgag.zzd(byArray);
        this.zzb = n;
    }

    public final void zzd(ByteBuffer byteBuffer, byte[] byArray, byte[] byArray2) throws GeneralSecurityException {
        if (byteBuffer.remaining() < byArray2.length) {
            throw new IllegalArgumentException("Given ByteBuffer output is too small");
        }
        this.zzf(byArray, byteBuffer, ByteBuffer.wrap(byArray2));
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzf(byte[] byArray, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws GeneralSecurityException {
        if (byArray.length != this.zza()) {
            int n = this.zza();
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("The nonce length (in bytes) must be ");
            stringBuilder.append(n);
            throw new GeneralSecurityException(stringBuilder.toString());
        }
        int n = byteBuffer2.remaining();
        int n2 = n / 64;
        int n3 = 0;
        int n4;
        while (n3 < (n4 = n2 + 1)) {
            zzgak zzgak2 = this;
            ByteBuffer byteBuffer3 = zzgak2.zzc(byArray, n3 + zzgak2.zzb);
            if (n3 == n4 + -1) {
                zzgmv.zza(byteBuffer, byteBuffer2, byteBuffer3, n % 64);
            } else {
                zzgmv.zza(byteBuffer, byteBuffer2, byteBuffer3, 64);
            }
            ++n3;
        }
        return;
    }

    public final byte[] zze(byte[] byArray, ByteBuffer byteBuffer) throws GeneralSecurityException {
        ByteBuffer byteBuffer2 = ByteBuffer.allocate(byteBuffer.remaining());
        this.zzf(byArray, byteBuffer2, byteBuffer);
        return byteBuffer2.array();
    }

    abstract int[] zzb(int[] var1, int var2);
}

