/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.util.Base64;
import androidx.annotation.NonNull;
import com.google.android.gms.ads.identifier.AdvertisingIdClient;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.ads.zzamv;
import com.google.android.gms.internal.ads.zzans;
import com.google.android.gms.internal.ads.zzfhp;
import com.google.android.gms.internal.ads.zzfhr;
import com.google.android.gms.internal.ads.zzfhx;
import com.google.android.gms.internal.ads.zzfic;
import com.google.android.gms.internal.ads.zzfid;
import com.google.android.gms.internal.ads.zzfie;
import com.google.android.gms.internal.ads.zzfif;
import com.google.android.gms.internal.ads.zzfig;
import com.google.android.gms.internal.ads.zzfih;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.nio.ByteBuffer;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

public final class zzfii {
    private final Context zza;
    private final Executor zzb;
    private final zzfhp zzc;
    private final zzfhr zzd;
    private final zzfih zze;
    private final zzfih zzf;
    private Task zzg;
    private Task zzh;

    public final zzans zza() {
        return zzfii.zzg(this.zzg, this.zze.zza());
    }

    public final zzans zzb() {
        return zzfii.zzg(this.zzh, this.zzf.zza());
    }

    private static zzans zzg(@NonNull Task task, @NonNull zzans zzans2) {
        if (!task.isSuccessful()) {
            return zzans2;
        }
        return (zzans)task.getResult();
    }

    final /* synthetic */ zzans zzc() throws Exception {
        zzamv zzamv2 = zzans.zza();
        AdvertisingIdClient.Info info = AdvertisingIdClient.getAdvertisingIdInfo((Context)((zzfii)object).zza);
        Object object = info.getId();
        if (object != null && ((String)object).matches("^[a-fA-F0-9]{8}-([a-fA-F0-9]{4}-){3}[a-fA-F0-9]{12}$")) {
            object = UUID.fromString((String)object);
            byte[] byArray = new byte[16];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
            byteBuffer.putLong(((UUID)object).getMostSignificantBits());
            byteBuffer.putLong(((UUID)object).getLeastSignificantBits());
            object = Base64.encodeToString((byte[])byArray, (int)11);
        }
        if (object != null) {
            zzamv2.zzs((String)object);
            zzamv2.zzr(info.isLimitAdTrackingEnabled());
            zzamv2.zzab(6);
        }
        return (zzans)zzamv2.zzal();
    }

    final /* synthetic */ zzans zzd() throws Exception {
        zzfii zzfii2 = zzfii2.zza;
        PackageInfo packageInfo = zzfii2.getPackageManager().getPackageInfo(zzfii2.getPackageName(), 0);
        zzfii zzfii3 = zzfii2;
        return zzfhx.zza((Context)zzfii3, zzfii3.getPackageName(), Integer.toString(packageInfo.versionCode));
    }

    /*
     * Enabled aggressive block sorting
     */
    public static zzfii zze(@NonNull Context context, @NonNull Executor executor, @NonNull zzfhp zzfhp2, @NonNull zzfhr zzfhr2) {
        zzfii zzfii2 = new zzfii(context, executor, zzfhp2, zzfhr2, new zzfif(), new zzfig());
        if (zzfii2.zzd.zzd()) {
            zzfii zzfii3 = zzfii2;
            zzfii3.zzg = zzfii3.zzh(new zzfic(zzfii3));
        } else {
            zzfii2.zzg = Tasks.forResult((Object)zzfii2.zze.zza());
        }
        zzfii zzfii4 = zzfii2;
        zzfii4.zzh = zzfii4.zzh(new zzfid(zzfii4));
        return zzfii2;
    }

    private final Task zzh(@NonNull Callable callable) {
        return Tasks.call((Executor)this.zzb, (Callable)callable).addOnFailureListener(this.zzb, (OnFailureListener)new zzfie(this));
    }

    @VisibleForTesting
    zzfii(Context context, Executor executor, zzfhp zzfhp2, zzfhr zzfhr2, zzfif zzfif2, zzfig zzfig2) {
        this.zza = context;
        this.zzb = executor;
        this.zzc = zzfhp2;
        this.zzd = zzfhr2;
        this.zze = zzfif2;
        this.zzf = zzfig2;
    }

    final /* synthetic */ void zzf(Exception exception) {
        if (exception instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        this.zzc.zzc(2025, -1L, exception);
    }
}

