/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.ads;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.media.MediaFormat;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import androidx.annotation.Nullable;
import com.google.android.gms.ads.internal.client.zzba;
import com.google.android.gms.ads.internal.util.zze;
import com.google.android.gms.ads.internal.util.zzs;
import com.google.android.gms.ads.internal.zzt;
import com.google.android.gms.internal.ads.zzavq;
import com.google.android.gms.internal.ads.zzbaj;
import com.google.android.gms.internal.ads.zzbar;
import com.google.android.gms.internal.ads.zzbza;
import com.google.android.gms.internal.ads.zzcae;
import com.google.android.gms.internal.ads.zzcaf;
import com.google.android.gms.internal.ads.zzcag;
import com.google.android.gms.internal.ads.zzcah;
import com.google.android.gms.internal.ads.zzcai;
import com.google.android.gms.internal.ads.zzcaj;
import com.google.android.gms.internal.ads.zzcak;
import com.google.android.gms.internal.ads.zzcal;
import com.google.android.gms.internal.ads.zzcam;
import com.google.android.gms.internal.ads.zzcao;
import com.google.android.gms.internal.ads.zzcap;
import com.google.android.gms.internal.ads.zzcbh;
import com.google.android.gms.internal.ads.zzcbi;
import com.google.android.gms.internal.ads.zzcbj;
import com.google.android.gms.internal.ads.zzcbk;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public final class zzcan
extends zzcap
implements TextureView.SurfaceTextureListener,
MediaPlayer.OnBufferingUpdateListener,
MediaPlayer.OnCompletionListener,
MediaPlayer.OnErrorListener,
MediaPlayer.OnInfoListener,
MediaPlayer.OnPreparedListener,
MediaPlayer.OnVideoSizeChangedListener {
    private static final Map zzd = new HashMap();
    private final zzcbj zze;
    private final zzcbk zzf;
    private final boolean zzg;
    private int zzh = 0;
    private int zzi = 0;
    private MediaPlayer zzj;
    private Uri zzk;
    private int zzl;
    private int zzm;
    private int zzn;
    private zzcbh zzo;
    private final boolean zzp;
    private int zzq;
    private zzcao zzr;
    private boolean zzs = false;
    private Integer zzt = null;

    @Override
    public final int zza() {
        if (this.zzG()) {
            return this.zzj.getCurrentPosition();
        }
        return 0;
    }

    @Override
    public final int zzb() {
        if (Build.VERSION.SDK_INT >= 26 && this.zzG()) {
            return this.zzj.getMetrics().getInt("android.media.mediaplayer.dropped");
        }
        return -1;
    }

    @Override
    public final int zzc() {
        if (this.zzG()) {
            return this.zzj.getDuration();
        }
        return -1;
    }

    @Override
    public final int zzd() {
        zzcan zzcan2 = zzcan2.zzj;
        if (zzcan2 != null) {
            return zzcan2.getVideoHeight();
        }
        return 0;
    }

    @Override
    public final int zze() {
        zzcan zzcan2 = zzcan2.zzj;
        if (zzcan2 != null) {
            return zzcan2.getVideoWidth();
        }
        return 0;
    }

    @Override
    public final long zzf() {
        return 0L;
    }

    @Override
    public final long zzg() {
        if (this.zzt != null) {
            return this.zzh() * (long)this.zzn / 100L;
        }
        return -1L;
    }

    @Override
    public final long zzh() {
        if (this.zzt != null) {
            return (long)this.zzc() * (long)this.zzt.intValue();
        }
        return -1L;
    }

    static /* bridge */ /* synthetic */ zzcao zzi(zzcan zzcan2) {
        return zzcan2.zzr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final String zzj() {
        Object object;
        if (!((zzcan)object).zzp) {
            object = "";
            return "MediaPlayer".concat((String)object);
        }
        object = " spherical";
        return "MediaPlayer".concat((String)object);
    }

    public final String toString() {
        String string2 = this.getClass().getName();
        String string3 = Integer.toHexString(this.hashCode());
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string2);
        stringBuilder.append("@");
        stringBuilder.append(string3);
        return stringBuilder.toString();
    }

    static /* bridge */ /* synthetic */ void zzk(zzcan zzcan2, boolean bl) {
        zzcan2.zzs = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    static /* bridge */ /* synthetic */ void zzl(zzcan zzcan2, MediaPlayer mediaPlayer) {
        MediaPlayer.TrackInfo[] trackInfoArray = zzbar.zzbG;
        if ((Boolean)zzba.zzc().zzb((zzbaj)trackInfoArray) == false) return;
        if (zzcan2.zze == null) return;
        if (mediaPlayer == null) {
            return;
        }
        trackInfoArray = mediaPlayer.getTrackInfo();
        if (trackInfoArray == null) return;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n = 0;
        while (true) {
            if (n >= trackInfoArray.length) {
                if (hashMap.isEmpty()) return;
                zzcan2.zze.zzd("onMetadataEvent", hashMap);
                return;
            }
            MediaPlayer.TrackInfo trackInfo = trackInfoArray[n];
            if (trackInfo != null) {
                switch (trackInfo.getTrackType()) {
                    default: {
                        break;
                    }
                    case 2: {
                        String string2;
                        MediaFormat mediaFormat = trackInfo.getFormat();
                        if (mediaFormat == null) break;
                        if (mediaFormat.containsKey("mime")) {
                            string2 = mediaFormat.getString("mime");
                            hashMap.put("audioMime", string2);
                        }
                        if (Build.VERSION.SDK_INT < 30 || !mediaFormat.containsKey("codecs-string")) break;
                        String string3 = mediaFormat.getString("codecs-string");
                        hashMap.put("audioCodec", string3);
                        break;
                    }
                    case 1: {
                        String string2;
                        MediaFormat mediaFormat = trackInfo.getFormat();
                        if (mediaFormat == null) break;
                        if (mediaFormat.containsKey("frame-rate")) {
                            try {
                                hashMap.put("frameRate", String.valueOf(mediaFormat.getFloat("frame-rate")));
                            }
                            catch (ClassCastException classCastException) {
                                string2 = String.valueOf(mediaFormat.getInteger("frame-rate"));
                                hashMap.put("frameRate", string2);
                            }
                        }
                        if (mediaFormat.containsKey("bitrate")) {
                            zzcan2.zzt = mediaFormat.getInteger("bitrate");
                            string2 = String.valueOf(zzcan2.zzt);
                            hashMap.put("bitRate", string2);
                        }
                        if (mediaFormat.containsKey("width") && mediaFormat.containsKey("height")) {
                            int n2 = mediaFormat.getInteger("width");
                            int n3 = mediaFormat.getInteger("height");
                            StringBuilder stringBuilder = new StringBuilder();
                            stringBuilder.append(n2);
                            stringBuilder.append("x");
                            stringBuilder.append(n3);
                            string2 = stringBuilder.toString();
                            hashMap.put("resolution", string2);
                        }
                        if (mediaFormat.containsKey("mime")) {
                            string2 = mediaFormat.getString("mime");
                            hashMap.put("videoMime", string2);
                        }
                        if (Build.VERSION.SDK_INT < 30 || !mediaFormat.containsKey("codecs-string")) break;
                        String string4 = mediaFormat.getString("codecs-string");
                        hashMap.put("videoCodec", string4);
                    }
                }
            }
            ++n;
        }
    }

    static {
        zzd.put(-1004, "MEDIA_ERROR_IO");
        zzd.put(-1007, "MEDIA_ERROR_MALFORMED");
        zzd.put(-1010, "MEDIA_ERROR_UNSUPPORTED");
        zzd.put(-110, "MEDIA_ERROR_TIMED_OUT");
        zzd.put(3, "MEDIA_INFO_VIDEO_RENDERING_START");
        zzd.put(100, "MEDIA_ERROR_SERVER_DIED");
        Integer n = 1;
        zzd.put(n, "MEDIA_ERROR_UNKNOWN");
        String string2 = "MEDIA_INFO_UNKNOWN";
        zzd.put(n, string2);
        zzd.put(700, "MEDIA_INFO_VIDEO_TRACK_LAGGING");
        zzd.put(701, "MEDIA_INFO_BUFFERING_START");
        zzd.put(702, "MEDIA_INFO_BUFFERING_END");
        zzd.put(800, "MEDIA_INFO_BAD_INTERLEAVING");
        zzd.put(801, "MEDIA_INFO_NOT_SEEKABLE");
        zzd.put(802, "MEDIA_INFO_METADATA_UPDATE");
        zzd.put(901, "MEDIA_INFO_UNSUPPORTED_SUBTITLE");
        zzd.put(902, "MEDIA_INFO_SUBTITLE_TIMED_OUT");
    }

    public zzcan(Context context, zzcbj zzcbj2, boolean bl, boolean bl2, zzcbi zzcbi2, zzcbk zzcbk2, @Nullable Integer n) {
        super(context, n);
        zzcan zzcan2 = this;
        zzcan2.setSurfaceTextureListener(zzcan2);
        this.zze = zzcbj2;
        this.zzf = zzcbk2;
        this.zzp = bl;
        this.zzg = bl2;
        this.zzf.zza(this);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzC() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView init MediaPlayer");
        SurfaceTexture surfaceTexture = this.getSurfaceTexture();
        if (this.zzk == null || surfaceTexture == null) {
            return;
        }
        this.zzD(false);
        try {
            MediaPlayer mediaPlayer;
            com.google.android.gms.ads.internal.zzt.zzk();
            this.zzj = mediaPlayer = new MediaPlayer();
            this.zzj.setOnBufferingUpdateListener((MediaPlayer.OnBufferingUpdateListener)this);
            this.zzj.setOnCompletionListener((MediaPlayer.OnCompletionListener)this);
            this.zzj.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            this.zzj.setOnInfoListener((MediaPlayer.OnInfoListener)this);
            this.zzj.setOnPreparedListener((MediaPlayer.OnPreparedListener)this);
            this.zzj.setOnVideoSizeChangedListener((MediaPlayer.OnVideoSizeChangedListener)this);
            this.zzn = 0;
            boolean bl = this.zzp;
            if (bl) {
                this.zzo = new zzcbh(this.getContext());
                this.zzo.zzd(surfaceTexture, this.getWidth(), this.getHeight());
                this.zzo.start();
                SurfaceTexture surfaceTexture2 = this.zzo.zzb();
                if (surfaceTexture2 != null) {
                    surfaceTexture = surfaceTexture2;
                } else {
                    this.zzo.zze();
                    this.zzo = null;
                }
            }
            this.zzj.setDataSource(this.getContext(), this.zzk);
            com.google.android.gms.ads.internal.zzt.zzl();
            Surface surface = new Surface(surfaceTexture);
            this.zzj.setSurface(surface);
            this.zzj.setAudioStreamType(3);
            this.zzj.setScreenOnWhilePlaying(true);
            this.zzj.prepareAsync();
            this.zzE(1);
            return;
        }
        catch (IOException | IllegalArgumentException | IllegalStateException exception) {
            String string2 = String.valueOf(String.valueOf(this.zzk));
            zzbza.zzk((String)"Failed to initialize MediaPlayer at ".concat(string2), (Throwable)exception);
            zzcan zzcan2 = this;
            zzcan2.onError(zzcan2.zzj, 1, 0);
            return;
        }
    }

    final /* synthetic */ void zzm(int n) {
        zzcao zzcao2 = ((zzcan)((Object)zzcao2)).zzr;
        if (zzcao2 != null) {
            zzcao2.onWindowVisibilityChanged(n);
            return;
        }
    }

    public final void onBufferingUpdate(MediaPlayer mediaPlayer, int n) {
        this.zzn = n;
    }

    public final void onCompletion(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView completion");
        this.zzE(5);
        this.zzi = 5;
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcag(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    protected final void onMeasure(int n, int n2) {
        block17: {
            int n3;
            int n4;
            block19: {
                block20: {
                    block21: {
                        int n5;
                        block26: {
                            block25: {
                                block24: {
                                    block22: {
                                        block23: {
                                            n4 = zzcan.getDefaultSize((int)((zzcan)((Object)zzcbh2)).zzl, (int)n);
                                            n3 = zzcan.getDefaultSize((int)((zzcan)((Object)zzcbh2)).zzm, (int)n2);
                                            if (((zzcan)((Object)zzcbh2)).zzl <= 0) break block19;
                                            if (((zzcan)((Object)zzcbh2)).zzm <= 0) break block20;
                                            if (((zzcan)((Object)zzcbh2)).zzo != null) break block21;
                                            n4 = View.MeasureSpec.getMode((int)n);
                                            n3 = View.MeasureSpec.getSize((int)n);
                                            n5 = View.MeasureSpec.getMode((int)n2);
                                            n2 = View.MeasureSpec.getSize((int)n2);
                                            if (n4 != 0x40000000) break block22;
                                            if (n5 != 0x40000000) break block23;
                                            n = ((zzcan)((Object)zzcbh2)).zzl;
                                            n4 = n * n2;
                                            n5 = ((zzcan)((Object)zzcbh2)).zzm;
                                            int n6 = n3 * n5;
                                            if (n4 < n6) {
                                                n = n4 / n5;
                                                break block17;
                                            } else if (n4 > n6) {
                                                int n7 = n6 / n;
                                                n = n3;
                                                n2 = n7;
                                                break block17;
                                            } else {
                                                n = n3;
                                            }
                                            break block17;
                                        }
                                        n = 0x40000000;
                                        break block24;
                                    }
                                    n = n4;
                                }
                                if (n != 0x40000000) break block25;
                                n = n3 * ((zzcan)((Object)zzcbh2)).zzm / ((zzcan)((Object)zzcbh2)).zzl;
                                if (n5 == Integer.MIN_VALUE) {
                                    if (n > n2) {
                                        n = n3;
                                        break block17;
                                    } else {
                                        int n8 = n;
                                        n = n3;
                                        n2 = n8;
                                    }
                                    break block17;
                                } else {
                                    int n9 = n;
                                    n = n3;
                                    n2 = n9;
                                }
                                break block17;
                            }
                            if (n5 != 0x40000000) break block26;
                            n4 = n2 * ((zzcan)((Object)zzcbh2)).zzl / ((zzcan)((Object)zzcbh2)).zzm;
                            n = n == Integer.MIN_VALUE ? (n4 > n3 ? n3 : n4) : n4;
                            break block17;
                        }
                        int n10 = ((zzcan)((Object)zzcbh2)).zzl;
                        int n11 = ((zzcan)((Object)zzcbh2)).zzm;
                        if (n5 == Integer.MIN_VALUE) {
                            if (n11 > n2) {
                                int n12 = n2;
                                n2 = n12 * n10 / n11;
                                n4 = n12;
                            } else {
                                n2 = n10;
                                n4 = n11;
                            }
                        } else {
                            n2 = n10;
                            n4 = n11;
                        }
                        if (n == Integer.MIN_VALUE) {
                            if (n2 > n3) {
                                n = n3;
                                n2 = n3 * n11 / n10;
                                break block17;
                            } else {
                                n = n2;
                                n2 = n4;
                            }
                            break block17;
                        } else {
                            n = n2;
                            n2 = n4;
                        }
                        break block17;
                    }
                    n = n4;
                    n2 = n3;
                    break block17;
                }
                n = n4;
                n2 = n3;
                break block17;
            }
            n = n4;
            n2 = n3;
        }
        zzcbh2.setMeasuredDimension(n, n2);
        zzcbh zzcbh2 = ((zzcan)((Object)zzcbh2)).zzo;
        if (zzcbh2 != null) {
            zzcbh2.zzc(n, n2);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onPrepared(MediaPlayer mediaPlayer) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView prepared");
        this.zzE(2);
        this.zzf.zzb();
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcaf(this, mediaPlayer));
        this.zzl = mediaPlayer.getVideoWidth();
        this.zzm = mediaPlayer.getVideoHeight();
        int n = this.zzq;
        if (n != 0) {
            this.zzq(n);
        }
        if (this.zzg && this.zzG() && this.zzj.getCurrentPosition() > 0 && this.zzi != 3) {
            com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView nudging MediaPlayer");
            this.zzF(0.0f);
            this.zzj.start();
            n = this.zzj.getCurrentPosition();
            long l = com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis();
            while (this.zzG() && this.zzj.getCurrentPosition() == n && com.google.android.gms.ads.internal.zzt.zzB().currentTimeMillis() - l <= 250L) {
            }
            this.zzj.pause();
            this.zzn();
        }
        n = this.zzl;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView stream dimensions: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(this.zzm);
        zzbza.zzi((String)stringBuilder.toString());
        if (this.zzi == 3) {
            this.zzp();
        }
        this.zzn();
    }

    public final void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface created");
        this.zzC();
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcai(this));
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
        zzcbh zzcbh2;
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface changed");
        int n3 = this.zzi;
        int n4 = this.zzl == n ? (this.zzm == n2 ? 1 : 0) : 0;
        if (this.zzj != null && n3 == 3 && n4 != 0) {
            n4 = this.zzq;
            if (n4 != 0) {
                this.zzq(n4);
            }
            this.zzp();
        }
        if ((zzcbh2 = this.zzo) != null) {
            zzcbh2.zzc(n, n2);
        }
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcaj(this, n, n2));
    }

    public final void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        this.zzf.zzf(this);
        this.zza.zza(surfaceTexture, this.zzr);
    }

    @Override
    public final void zzn() {
        zzcan zzcan2 = this;
        zzcan2.zzF(zzcan2.zzb.zza());
    }

    public final void onVideoSizeChanged(MediaPlayer mediaPlayer, int n, int n2) {
        int n3;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView size changed: ");
        stringBuilder.append(n);
        stringBuilder.append(" x ");
        stringBuilder.append(n2);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        this.zzl = mediaPlayer.getVideoWidth();
        this.zzm = n3 = mediaPlayer.getVideoHeight();
        if (this.zzl != 0 && n3 != 0) {
            this.requestLayout();
            return;
        }
    }

    protected final void onWindowVisibilityChanged(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView window visibility changed to ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcae(this, n));
        super.onWindowVisibilityChanged(n);
    }

    @Override
    public final void zzo() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView pause");
        if (this.zzG() && this.zzj.isPlaying()) {
            this.zzj.pause();
            this.zzE(4);
            com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcam(this));
        }
        this.zzi = 4;
    }

    @Override
    public final void zzp() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView play");
        if (this.zzG()) {
            this.zzj.start();
            this.zzE(3);
            this.zza.zzb();
            com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcal(this));
        }
        this.zzi = 3;
    }

    private final void zzD(boolean bl) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView release");
        zzcbh zzcbh2 = this.zzo;
        if (zzcbh2 != null) {
            zzcbh2.zze();
            this.zzo = null;
        }
        if ((zzcbh2 = this.zzj) != null) {
            zzcbh2.reset();
            this.zzj.release();
            this.zzj = null;
            this.zzE(0);
            if (bl) {
                this.zzi = 0;
                return;
            }
        }
    }

    @Override
    public final void zzq(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView seek ");
        stringBuilder.append(n);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        if (this.zzG()) {
            this.zzj.seekTo(n);
            this.zzq = 0;
            return;
        }
        this.zzq = n;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void zzE(int n) {
        if (n == 3) {
            this.zzf.zzc();
            this.zzb.zzb();
        } else if (this.zzh == 3) {
            this.zzf.zze();
            this.zzb.zzc();
        }
        this.zzh = n;
    }

    @Override
    public final void zzr(zzcao zzcao2) {
        this.zzr = zzcao2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void zzF(float f) {
        zzcan zzcan2;
        zzcan2 = zzcan2.zzj;
        if (zzcan2 == null) {
            zzbza.zzj((String)"AdMediaPlayerView setMediaPlayerVolume() called before onPrepared().");
            return;
        }
        try {
            float f2 = f;
            zzcan2.setVolume(f2, f2);
            return;
        }
        catch (IllegalStateException illegalStateException) {
            return;
        }
    }

    @Override
    public final void zzs(String string2) {
        zzavq zzavq2 = zzavq.zza((Uri)(string2 = Uri.parse((String)string2)));
        if (zzavq2 == null || zzavq2.zza != null) {
            if (zzavq2 != null) {
                string2 = Uri.parse((String)zzavq2.zza);
            }
            this.zzk = string2;
            this.zzq = 0;
            this.zzC();
            this.requestLayout();
            this.invalidate();
            return;
        }
    }

    @Override
    public final void zzt() {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView stop");
        MediaPlayer mediaPlayer = this.zzj;
        if (mediaPlayer != null) {
            mediaPlayer.stop();
            this.zzj.release();
            this.zzj = null;
            this.zzE(0);
            this.zzi = 0;
        }
        this.zzf.zzd();
    }

    @Override
    public final void zzu(float f, float f2) {
        zzcbh zzcbh2 = ((zzcan)((Object)zzcbh2)).zzo;
        if (zzcbh2 != null) {
            zzcbh2.zzf(f, f2);
            return;
        }
    }

    static /* bridge */ /* synthetic */ boolean zzv(zzcan zzcan2) {
        return zzcan2.zzs;
    }

    private final boolean zzG() {
        int n;
        return this.zzj != null && (n = this.zzh) != -1 && n != 0 && n != 1;
    }

    public final boolean onError(MediaPlayer object, int n, int n2) {
        object = (String)zzd.get(n);
        String string2 = (String)zzd.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer error: ");
        stringBuilder.append((String)object);
        stringBuilder.append(":");
        stringBuilder.append(string2);
        zzbza.zzj((String)stringBuilder.toString());
        this.zzE(-1);
        this.zzi = -1;
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcah(this, (String)object, string2));
        return true;
    }

    public final boolean onInfo(MediaPlayer mediaPlayer, int n, int n2) {
        String string2 = (String)zzd.get(n);
        String string3 = (String)zzd.get(n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("AdMediaPlayerView MediaPlayer info: ");
        stringBuilder.append(string2);
        stringBuilder.append(":");
        stringBuilder.append(string3);
        com.google.android.gms.ads.internal.util.zze.zza(stringBuilder.toString());
        return true;
    }

    public final boolean onSurfaceTextureDestroyed(SurfaceTexture object) {
        com.google.android.gms.ads.internal.util.zze.zza("AdMediaPlayerView surface destroyed");
        object = this.zzj;
        if (object != null && this.zzq == 0) {
            this.zzq = object.getCurrentPosition();
        }
        if ((object = this.zzo) != null) {
            ((zzcbh)object).zze();
        }
        com.google.android.gms.ads.internal.util.zzs.zza.post((Runnable)new zzcak(this));
        this.zzD(true);
        return true;
    }
}

