/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.ui;

import android.content.Context;
import android.text.Layout;
import android.util.AttributeSet;
import android.util.Base64;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.text.CaptionStyleCompat;
import com.google.android.exoplayer2.text.Cue;
import com.google.android.exoplayer2.ui.CanvasSubtitleOutput;
import com.google.android.exoplayer2.ui.HtmlUtils;
import com.google.android.exoplayer2.ui.SpannedToHtmlConverter;
import com.google.android.exoplayer2.ui.SubtitleView;
import com.google.android.exoplayer2.ui.SubtitleViewUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

final class WebViewSubtitleOutput
extends FrameLayout
implements SubtitleView.Output {
    private static final float CSS_LINE_HEIGHT = 1.2f;
    private static final String DEFAULT_BACKGROUND_CSS_CLASS = "default_bg";
    private final CanvasSubtitleOutput canvasSubtitleOutput;
    private final WebView webView;
    private List<Cue> textCues = Collections.emptyList();
    private CaptionStyleCompat style = CaptionStyleCompat.DEFAULT;
    private float defaultTextSize = 0.0533f;
    private int defaultTextSizeType = 0;
    private float bottomPaddingFraction = 0.08f;

    public WebViewSubtitleOutput(Context context) {
        this(context, null);
    }

    public WebViewSubtitleOutput(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.canvasSubtitleOutput = new CanvasSubtitleOutput(context, attrs);
        this.webView = new WebView(context, attrs){

            public boolean onTouchEvent(MotionEvent event) {
                super.onTouchEvent(event);
                return false;
            }

            public boolean performClick() {
                super.performClick();
                return false;
            }
        };
        this.webView.setBackgroundColor(0);
        this.addView(this.canvasSubtitleOutput);
        this.addView((View)this.webView);
    }

    @Override
    public void update(List<Cue> cues, CaptionStyleCompat style2, float textSize, int textSizeType, float bottomPaddingFraction) {
        this.style = style2;
        this.defaultTextSize = textSize;
        this.defaultTextSizeType = textSizeType;
        this.bottomPaddingFraction = bottomPaddingFraction;
        ArrayList<Cue> bitmapCues = new ArrayList<Cue>();
        ArrayList<Cue> textCues = new ArrayList<Cue>();
        for (int i = 0; i < cues.size(); ++i) {
            Cue cue = cues.get(i);
            if (cue.bitmap != null) {
                bitmapCues.add(cue);
                continue;
            }
            textCues.add(cue);
        }
        if (!this.textCues.isEmpty() || !textCues.isEmpty()) {
            this.textCues = textCues;
            this.updateWebView();
        }
        this.canvasSubtitleOutput.update(bitmapCues, style2, textSize, textSizeType, bottomPaddingFraction);
        this.invalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed && !this.textCues.isEmpty()) {
            this.updateWebView();
        }
    }

    public void destroy() {
        this.webView.destroy();
    }

    private void updateWebView() {
        StringBuilder html = new StringBuilder();
        html.append(Util.formatInvariant((String)"<body><div style='-webkit-user-select:none;position:fixed;top:0;bottom:0;left:0;right:0;color:%s;font-size:%s;line-height:%.2fem;text-shadow:%s;'>", (Object[])new Object[]{HtmlUtils.toCssRgba(this.style.foregroundColor), this.convertTextSizeToCss(this.defaultTextSizeType, this.defaultTextSize), Float.valueOf(1.2f), WebViewSubtitleOutput.convertCaptionStyleToCssTextShadow(this.style)}));
        HashMap<String, String> cssRuleSets = new HashMap<String, String>();
        cssRuleSets.put(HtmlUtils.cssAllClassDescendantsSelector(DEFAULT_BACKGROUND_CSS_CLASS), Util.formatInvariant((String)"background-color:%s;", (Object[])new Object[]{HtmlUtils.toCssRgba(this.style.backgroundColor)}));
        for (int i = 0; i < this.textCues.size(); ++i) {
            int verticalTranslatePercent;
            int horizontalTranslatePercent;
            String sizeProperty;
            String positionProperty;
            String lineProperty;
            String lineValue;
            Cue cue = this.textCues.get(i);
            float positionPercent = cue.position != -3.4028235E38f ? cue.position * 100.0f : 50.0f;
            int positionAnchorTranslatePercent = WebViewSubtitleOutput.anchorTypeToTranslatePercent(cue.positionAnchor);
            boolean lineMeasuredFromEnd = false;
            int lineAnchorTranslatePercent = 0;
            if (cue.line != -3.4028235E38f) {
                switch (cue.lineType) {
                    case 1: {
                        if (cue.line >= 0.0f) {
                            lineValue = Util.formatInvariant((String)"%.2fem", (Object[])new Object[]{Float.valueOf(cue.line * 1.2f)});
                            break;
                        }
                        lineValue = Util.formatInvariant((String)"%.2fem", (Object[])new Object[]{Float.valueOf((-cue.line - 1.0f) * 1.2f)});
                        lineMeasuredFromEnd = true;
                        break;
                    }
                    default: {
                        lineValue = Util.formatInvariant((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(cue.line * 100.0f)});
                        lineAnchorTranslatePercent = cue.verticalType == 1 ? -WebViewSubtitleOutput.anchorTypeToTranslatePercent(cue.lineAnchor) : WebViewSubtitleOutput.anchorTypeToTranslatePercent(cue.lineAnchor);
                        break;
                    }
                }
            } else {
                lineValue = Util.formatInvariant((String)"%.2f%%", (Object[])new Object[]{Float.valueOf((1.0f - this.bottomPaddingFraction) * 100.0f)});
                lineAnchorTranslatePercent = -100;
            }
            String size = cue.size != -3.4028235E38f ? Util.formatInvariant((String)"%.2f%%", (Object[])new Object[]{Float.valueOf(cue.size * 100.0f)}) : "fit-content";
            String textAlign = WebViewSubtitleOutput.convertAlignmentToCss(cue.textAlignment);
            String writingMode = WebViewSubtitleOutput.convertVerticalTypeToCss(cue.verticalType);
            String cueTextSizeCssPx = this.convertTextSizeToCss(cue.textSizeType, cue.textSize);
            String windowCssColor = HtmlUtils.toCssRgba(cue.windowColorSet ? cue.windowColor : this.style.windowColor);
            switch (cue.verticalType) {
                case 2: {
                    lineProperty = lineMeasuredFromEnd ? "right" : "left";
                    positionProperty = "top";
                    break;
                }
                case 1: {
                    lineProperty = lineMeasuredFromEnd ? "left" : "right";
                    positionProperty = "top";
                    break;
                }
                default: {
                    lineProperty = lineMeasuredFromEnd ? "bottom" : "top";
                    positionProperty = "left";
                }
            }
            if (cue.verticalType == 2 || cue.verticalType == 1) {
                sizeProperty = "height";
                horizontalTranslatePercent = lineAnchorTranslatePercent;
                verticalTranslatePercent = positionAnchorTranslatePercent;
            } else {
                sizeProperty = "width";
                horizontalTranslatePercent = positionAnchorTranslatePercent;
                verticalTranslatePercent = lineAnchorTranslatePercent;
            }
            SpannedToHtmlConverter.HtmlAndCss htmlAndCss = SpannedToHtmlConverter.convert(cue.text, this.getContext().getResources().getDisplayMetrics().density);
            for (String cssSelector : cssRuleSets.keySet()) {
                String previousCssDeclarationBlock = cssRuleSets.put(cssSelector, (String)cssRuleSets.get(cssSelector));
                Assertions.checkState((previousCssDeclarationBlock == null || previousCssDeclarationBlock.equals(cssRuleSets.get(cssSelector)) ? 1 : 0) != 0);
            }
            html.append(Util.formatInvariant((String)"<div style='position:absolute;%s:%.2f%%;%s:%s;%s:%s;text-align:%s;writing-mode:%s;font-size:%s;background-color:%s;transform:translate(%s%%,%s%%)%s;'>", (Object[])new Object[]{positionProperty, Float.valueOf(positionPercent), lineProperty, lineValue, sizeProperty, size, textAlign, writingMode, cueTextSizeCssPx, windowCssColor, horizontalTranslatePercent, verticalTranslatePercent, WebViewSubtitleOutput.getBlockShearTransformFunction(cue)})).append(Util.formatInvariant((String)"<span class='%s'>", (Object[])new Object[]{DEFAULT_BACKGROUND_CSS_CLASS})).append(htmlAndCss.html).append("</span>").append("</div>");
        }
        html.append("</div></body></html>");
        StringBuilder htmlHead = new StringBuilder();
        htmlHead.append("<html><head><style>");
        for (String cssSelector : cssRuleSets.keySet()) {
            htmlHead.append(cssSelector).append("{").append((String)cssRuleSets.get(cssSelector)).append("}");
        }
        htmlHead.append("</style></head>");
        html.insert(0, htmlHead.toString());
        this.webView.loadData(Base64.encodeToString((byte[])html.toString().getBytes(Charsets.UTF_8), (int)1), "text/html", "base64");
    }

    private static String getBlockShearTransformFunction(Cue cue) {
        if (cue.shearDegrees != 0.0f) {
            String direction = cue.verticalType == 2 || cue.verticalType == 1 ? "skewY" : "skewX";
            return Util.formatInvariant((String)"%s(%.2fdeg)", (Object[])new Object[]{direction, Float.valueOf(cue.shearDegrees)});
        }
        return "";
    }

    private String convertTextSizeToCss(int type, float size) {
        float sizePx = SubtitleViewUtils.resolveTextSize(type, size, this.getHeight(), this.getHeight() - this.getPaddingTop() - this.getPaddingBottom());
        if (sizePx == -3.4028235E38f) {
            return "unset";
        }
        float sizeDp = sizePx / this.getContext().getResources().getDisplayMetrics().density;
        return Util.formatInvariant((String)"%.2fpx", (Object[])new Object[]{Float.valueOf(sizeDp)});
    }

    private static String convertCaptionStyleToCssTextShadow(CaptionStyleCompat style2) {
        switch (style2.edgeType) {
            case 4: {
                return Util.formatInvariant((String)"-0.05em -0.05em 0.15em %s", (Object[])new Object[]{HtmlUtils.toCssRgba(style2.edgeColor)});
            }
            case 2: {
                return Util.formatInvariant((String)"0.1em 0.12em 0.15em %s", (Object[])new Object[]{HtmlUtils.toCssRgba(style2.edgeColor)});
            }
            case 1: {
                return Util.formatInvariant((String)"1px 1px 0 %1$s, 1px -1px 0 %1$s, -1px 1px 0 %1$s, -1px -1px 0 %1$s", (Object[])new Object[]{HtmlUtils.toCssRgba(style2.edgeColor)});
            }
            case 3: {
                return Util.formatInvariant((String)"0.06em 0.08em 0.15em %s", (Object[])new Object[]{HtmlUtils.toCssRgba(style2.edgeColor)});
            }
        }
        return "unset";
    }

    private static String convertVerticalTypeToCss(int verticalType) {
        switch (verticalType) {
            case 2: {
                return "vertical-lr";
            }
            case 1: {
                return "vertical-rl";
            }
        }
        return "horizontal-tb";
    }

    private static String convertAlignmentToCss(@Nullable Layout.Alignment alignment) {
        if (alignment == null) {
            return "center";
        }
        switch (alignment) {
            case ALIGN_NORMAL: {
                return "start";
            }
            case ALIGN_OPPOSITE: {
                return "end";
            }
        }
        return "center";
    }

    private static int anchorTypeToTranslatePercent(int anchorType) {
        switch (anchorType) {
            case 2: {
                return -100;
            }
            case 1: {
                return -50;
            }
        }
        return 0;
    }
}

