/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.DefaultLoadControl;
import com.google.android.exoplayer2.ExoPlaybackException;
import com.google.android.exoplayer2.LoadControl;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Player;
import com.google.android.exoplayer2.Renderer;
import com.google.android.exoplayer2.RenderersFactory;
import com.google.android.exoplayer2.SimpleExoPlayer;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.analytics.AnalyticsListener;
import com.google.android.exoplayer2.audio.AudioRendererEventListener;
import com.google.android.exoplayer2.extractor.DefaultExtractorsFactory;
import com.google.android.exoplayer2.extractor.ExtractorsFactory;
import com.google.android.exoplayer2.metadata.MetadataOutput;
import com.google.android.exoplayer2.source.DefaultMediaSourceFactory;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.TrackGroupArray;
import com.google.android.exoplayer2.text.TextOutput;
import com.google.android.exoplayer2.trackselection.DefaultTrackSelector;
import com.google.android.exoplayer2.trackselection.TrackSelectionArray;
import com.google.android.exoplayer2.trackselection.TrackSelector;
import com.google.android.exoplayer2.transformer.FrameworkMuxer;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.transformer.MuxerWrapper;
import com.google.android.exoplayer2.transformer.ProgressHolder;
import com.google.android.exoplayer2.transformer.Transformation;
import com.google.android.exoplayer2.transformer.TransformerAudioRenderer;
import com.google.android.exoplayer2.transformer.TransformerMediaClock;
import com.google.android.exoplayer2.transformer.TransformerVideoRenderer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Clock;
import com.google.android.exoplayer2.util.Util;
import com.google.android.exoplayer2.video.VideoRendererEventListener;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@RequiresApi(value=18)
public final class Transformer {
    public static final int PROGRESS_STATE_WAITING_FOR_AVAILABILITY = 0;
    public static final int PROGRESS_STATE_AVAILABLE = 1;
    public static final int PROGRESS_STATE_UNAVAILABLE = 2;
    public static final int PROGRESS_STATE_NO_TRANSFORMATION = 4;
    private final Context context;
    private final MediaSourceFactory mediaSourceFactory;
    private final Muxer.Factory muxerFactory;
    private final Transformation transformation;
    private final Looper looper;
    private final Clock clock;
    private Listener listener;
    @Nullable
    private MuxerWrapper muxerWrapper;
    @Nullable
    private SimpleExoPlayer player;
    private int progressState;

    private Transformer(Context context, MediaSourceFactory mediaSourceFactory, Muxer.Factory muxerFactory, Transformation transformation, Listener listener, Looper looper, Clock clock) {
        Assertions.checkState((!transformation.removeAudio || !transformation.removeVideo ? 1 : 0) != 0, (Object)"Audio and video cannot both be removed.");
        this.context = context;
        this.mediaSourceFactory = mediaSourceFactory;
        this.muxerFactory = muxerFactory;
        this.transformation = transformation;
        this.listener = listener;
        this.looper = looper;
        this.clock = clock;
        this.progressState = 4;
    }

    public Builder buildUpon() {
        return new Builder(this);
    }

    public void setListener(Listener listener) {
        this.verifyApplicationThread();
        this.listener = listener;
    }

    public void startTransformation(MediaItem mediaItem, String path) throws IOException {
        this.startTransformation(mediaItem, this.muxerFactory.create(path, this.transformation.outputMimeType));
    }

    @RequiresApi(value=26)
    public void startTransformation(MediaItem mediaItem, ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        this.startTransformation(mediaItem, this.muxerFactory.create(parcelFileDescriptor, this.transformation.outputMimeType));
    }

    private void startTransformation(MediaItem mediaItem, Muxer muxer) {
        MuxerWrapper muxerWrapper;
        this.verifyApplicationThread();
        if (this.player != null) {
            throw new IllegalStateException("There is already a transformation in progress.");
        }
        this.muxerWrapper = muxerWrapper = new MuxerWrapper(muxer);
        DefaultTrackSelector trackSelector = new DefaultTrackSelector(this.context);
        trackSelector.setParameters(new DefaultTrackSelector.ParametersBuilder(this.context).setForceHighestSupportedBitrate(true).build());
        DefaultLoadControl loadControl = new DefaultLoadControl.Builder().setBufferDurationsMs(50000, 50000, 250, 500).build();
        this.player = new SimpleExoPlayer.Builder(this.context, (RenderersFactory)new TransformerRenderersFactory(muxerWrapper, this.transformation)).setMediaSourceFactory(this.mediaSourceFactory).setTrackSelector((TrackSelector)trackSelector).setLoadControl((LoadControl)loadControl).setLooper(this.looper).setClock(this.clock).build();
        this.player.setMediaItem(mediaItem);
        this.player.addAnalyticsListener((AnalyticsListener)new TransformerAnalyticsListener(mediaItem, muxerWrapper));
        this.player.prepare();
        this.progressState = 0;
    }

    public Looper getApplicationLooper() {
        return this.looper;
    }

    public int getProgress(ProgressHolder progressHolder) {
        this.verifyApplicationThread();
        if (this.progressState == 1) {
            Player player = (Player)Assertions.checkNotNull((Object)this.player);
            long durationMs = player.getDuration();
            long positionMs = player.getCurrentPosition();
            progressHolder.progress = Math.min((int)(positionMs * 100L / durationMs), 99);
        }
        return this.progressState;
    }

    public void cancel() {
        this.releaseResources(true);
    }

    private void releaseResources(boolean forCancellation) {
        this.verifyApplicationThread();
        if (this.player != null) {
            this.player.release();
            this.player = null;
        }
        if (this.muxerWrapper != null) {
            this.muxerWrapper.release(forCancellation);
            this.muxerWrapper = null;
        }
        this.progressState = 4;
    }

    private void verifyApplicationThread() {
        if (Looper.myLooper() != this.looper) {
            throw new IllegalStateException("Transformer is accessed on the wrong thread.");
        }
    }

    private final class TransformerAnalyticsListener
    implements AnalyticsListener {
        private final MediaItem mediaItem;
        private final MuxerWrapper muxerWrapper;

        public TransformerAnalyticsListener(MediaItem mediaItem, MuxerWrapper muxerWrapper) {
            this.mediaItem = mediaItem;
            this.muxerWrapper = muxerWrapper;
        }

        public void onPlaybackStateChanged(AnalyticsListener.EventTime eventTime, int state) {
            if (state == 4) {
                this.handleTransformationEnded(null);
            }
        }

        public void onTimelineChanged(AnalyticsListener.EventTime eventTime, int reason) {
            if (Transformer.this.progressState != 0) {
                return;
            }
            Timeline.Window window = new Timeline.Window();
            eventTime.timeline.getWindow(0, window);
            if (!window.isPlaceholder) {
                long durationUs = window.durationUs;
                Transformer.this.progressState = durationUs <= 0L || durationUs == -9223372036854775807L ? 2 : 1;
                ((SimpleExoPlayer)Assertions.checkNotNull((Object)Transformer.this.player)).play();
            }
        }

        public void onTracksChanged(AnalyticsListener.EventTime eventTime, TrackGroupArray trackGroups, TrackSelectionArray trackSelections) {
            if (this.muxerWrapper.getTrackCount() == 0) {
                this.handleTransformationEnded(new IllegalStateException("The output does not contain any tracks. Check that at least one of the input sample formats is supported."));
            }
        }

        public void onPlayerError(AnalyticsListener.EventTime eventTime, ExoPlaybackException error) {
            this.handleTransformationEnded((Exception)error);
        }

        private void handleTransformationEnded(@Nullable Exception exception) {
            block4: {
                try {
                    Transformer.this.releaseResources(false);
                }
                catch (IllegalStateException e) {
                    if (exception != null) break block4;
                    exception = e;
                }
            }
            if (exception == null) {
                Transformer.this.listener.onTransformationCompleted(this.mediaItem);
            } else {
                Transformer.this.listener.onTransformationError(this.mediaItem, exception);
            }
        }
    }

    private static final class TransformerRenderersFactory
    implements RenderersFactory {
        private final MuxerWrapper muxerWrapper;
        private final TransformerMediaClock mediaClock;
        private final Transformation transformation;

        public TransformerRenderersFactory(MuxerWrapper muxerWrapper, Transformation transformation) {
            this.muxerWrapper = muxerWrapper;
            this.transformation = transformation;
            this.mediaClock = new TransformerMediaClock();
        }

        public Renderer[] createRenderers(Handler eventHandler, VideoRendererEventListener videoRendererEventListener, AudioRendererEventListener audioRendererEventListener, TextOutput textRendererOutput, MetadataOutput metadataRendererOutput) {
            int rendererCount = this.transformation.removeAudio || this.transformation.removeVideo ? 1 : 2;
            Renderer[] renderers = new Renderer[rendererCount];
            int index = 0;
            if (!this.transformation.removeAudio) {
                renderers[index] = new TransformerAudioRenderer(this.muxerWrapper, this.mediaClock, this.transformation);
                ++index;
            }
            if (!this.transformation.removeVideo) {
                renderers[index] = new TransformerVideoRenderer(this.muxerWrapper, this.mediaClock, this.transformation);
                ++index;
            }
            return renderers;
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ProgressState {
    }

    public static interface Listener {
        default public void onTransformationCompleted(MediaItem inputMediaItem) {
        }

        default public void onTransformationError(MediaItem inputMediaItem, Exception exception) {
        }
    }

    public static final class Builder {
        private @MonotonicNonNull Context context;
        private @MonotonicNonNull MediaSourceFactory mediaSourceFactory;
        private Muxer.Factory muxerFactory;
        private boolean removeAudio;
        private boolean removeVideo;
        private boolean flattenForSlowMotion;
        private String outputMimeType;
        private Listener listener;
        private Looper looper;
        private Clock clock;

        public Builder() {
            this.muxerFactory = new FrameworkMuxer.Factory();
            this.outputMimeType = "video/mp4";
            this.listener = new Listener(){};
            this.looper = Util.getCurrentOrMainLooper();
            this.clock = Clock.DEFAULT;
        }

        private Builder(Transformer transformer) {
            this.context = transformer.context;
            this.mediaSourceFactory = transformer.mediaSourceFactory;
            this.muxerFactory = transformer.muxerFactory;
            this.removeAudio = ((Transformer)transformer).transformation.removeAudio;
            this.removeVideo = ((Transformer)transformer).transformation.removeVideo;
            this.flattenForSlowMotion = ((Transformer)transformer).transformation.flattenForSlowMotion;
            this.outputMimeType = ((Transformer)transformer).transformation.outputMimeType;
            this.listener = transformer.listener;
            this.looper = transformer.looper;
            this.clock = transformer.clock;
        }

        public Builder setContext(Context context) {
            this.context = context.getApplicationContext();
            return this;
        }

        public Builder setMediaSourceFactory(MediaSourceFactory mediaSourceFactory) {
            this.mediaSourceFactory = mediaSourceFactory;
            return this;
        }

        public Builder setRemoveAudio(boolean removeAudio) {
            this.removeAudio = removeAudio;
            return this;
        }

        public Builder setRemoveVideo(boolean removeVideo) {
            this.removeVideo = removeVideo;
            return this;
        }

        public Builder setFlattenForSlowMotion(boolean flattenForSlowMotion) {
            this.flattenForSlowMotion = flattenForSlowMotion;
            return this;
        }

        public Builder setOutputMimeType(String outputMimeType) {
            this.outputMimeType = outputMimeType;
            return this;
        }

        public Builder setListener(Listener listener) {
            this.listener = listener;
            return this;
        }

        public Builder setLooper(Looper looper) {
            this.looper = looper;
            return this;
        }

        @VisibleForTesting
        Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        @VisibleForTesting
        Builder setMuxerFactory(Muxer.Factory muxerFactory) {
            this.muxerFactory = muxerFactory;
            return this;
        }

        public Transformer build() {
            Assertions.checkStateNotNull((Object)this.context);
            if (this.mediaSourceFactory == null) {
                DefaultExtractorsFactory defaultExtractorsFactory = new DefaultExtractorsFactory();
                if (this.flattenForSlowMotion) {
                    defaultExtractorsFactory.setMp4ExtractorFlags(4);
                }
                this.mediaSourceFactory = new DefaultMediaSourceFactory(this.context, (ExtractorsFactory)defaultExtractorsFactory);
            }
            Assertions.checkState((boolean)this.muxerFactory.supportsOutputMimeType(this.outputMimeType), (Object)("Unsupported output MIME type: " + this.outputMimeType));
            Transformation transformation = new Transformation(this.removeAudio, this.removeVideo, this.flattenForSlowMotion, this.outputMimeType);
            return new Transformer(this.context, this.mediaSourceFactory, this.muxerFactory, transformation, this.listener, this.looper, this.clock);
        }
    }
}

