/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.transformer;

import android.util.SparseIntArray;
import android.util.SparseLongArray;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.google.android.exoplayer2.C;
import com.google.android.exoplayer2.Format;
import com.google.android.exoplayer2.transformer.Muxer;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.MimeTypes;
import com.google.android.exoplayer2.util.Util;
import java.nio.ByteBuffer;

@RequiresApi(value=18)
final class MuxerWrapper {
    private static final long MAX_TRACK_WRITE_AHEAD_US = C.msToUs((long)500L);
    private final Muxer muxer;
    private final SparseIntArray trackTypeToIndex;
    private final SparseLongArray trackTypeToTimeUs;
    private int trackCount;
    private int trackFormatCount;
    private boolean isReady;
    private int previousTrackType;
    private long minTrackTimeUs;

    public MuxerWrapper(Muxer muxer) {
        this.muxer = muxer;
        this.trackTypeToIndex = new SparseIntArray();
        this.trackTypeToTimeUs = new SparseLongArray();
        this.previousTrackType = 7;
    }

    public void registerTrack() {
        Assertions.checkState((this.trackFormatCount == 0 ? 1 : 0) != 0, (Object)"Tracks cannot be registered after track formats have been added.");
        ++this.trackCount;
    }

    public boolean supportsSampleMimeType(@Nullable String mimeType) {
        return this.muxer.supportsSampleMimeType(mimeType);
    }

    public void addTrackFormat(Format format) {
        Assertions.checkState((this.trackCount > 0 ? 1 : 0) != 0, (Object)"All tracks should be registered before the formats are added.");
        Assertions.checkState((this.trackFormatCount < this.trackCount ? 1 : 0) != 0, (Object)"All track formats have already been added.");
        String sampleMimeType = format.sampleMimeType;
        boolean isAudio = MimeTypes.isAudio((String)sampleMimeType);
        boolean isVideo = MimeTypes.isVideo((String)sampleMimeType);
        Assertions.checkState((isAudio || isVideo ? 1 : 0) != 0, (Object)("Unsupported track format: " + sampleMimeType));
        int trackType = MimeTypes.getTrackType((String)sampleMimeType);
        Assertions.checkState((this.trackTypeToIndex.get(trackType, -1) == -1 ? 1 : 0) != 0, (Object)("There is already a track of type " + trackType));
        int trackIndex = this.muxer.addTrack(format);
        this.trackTypeToIndex.put(trackType, trackIndex);
        this.trackTypeToTimeUs.put(trackType, 0L);
        ++this.trackFormatCount;
        if (this.trackFormatCount == this.trackCount) {
            this.isReady = true;
        }
    }

    public boolean writeSample(int trackType, @Nullable ByteBuffer data, boolean isKeyFrame, long presentationTimeUs) {
        int trackIndex = this.trackTypeToIndex.get(trackType, -1);
        Assertions.checkState((trackIndex != -1 ? 1 : 0) != 0, (Object)("Could not write sample because there is no track of type " + trackType));
        if (!this.canWriteSampleOfType(trackType)) {
            return false;
        }
        if (data == null) {
            return true;
        }
        this.muxer.writeSampleData(trackIndex, data, isKeyFrame, presentationTimeUs);
        this.trackTypeToTimeUs.put(trackType, presentationTimeUs);
        this.previousTrackType = trackType;
        return true;
    }

    public void endTrack(int trackType) {
        this.trackTypeToIndex.delete(trackType);
        this.trackTypeToTimeUs.delete(trackType);
    }

    public void release(boolean forCancellation) {
        this.isReady = false;
        this.muxer.release(forCancellation);
    }

    public int getTrackCount() {
        return this.trackCount;
    }

    private boolean canWriteSampleOfType(int trackType) {
        long trackTimeUs = this.trackTypeToTimeUs.get(trackType, -9223372036854775807L);
        Assertions.checkState((trackTimeUs != -9223372036854775807L ? 1 : 0) != 0);
        if (!this.isReady) {
            return false;
        }
        if (this.trackTypeToTimeUs.size() == 1) {
            return true;
        }
        if (trackType != this.previousTrackType) {
            this.minTrackTimeUs = Util.minValue((SparseLongArray)this.trackTypeToTimeUs);
        }
        return trackTimeUs - this.minTrackTimeUs <= MAX_TRACK_WRITE_AHEAD_US;
    }
}

