/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import android.util.Log;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpReaderUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public final class RtpPcmReader
implements RtpPayloadReader {
    private static final String TAG = "RtpPcmReader";
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private long startTimeOffsetUs;
    private int previousSequenceNumber;

    public RtpPcmReader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.startTimeOffsetUs = 0L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 1);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        int expectedSequenceNumber;
        Assertions.checkNotNull((Object)this.trackOutput);
        if (this.previousSequenceNumber != -1 && sequenceNumber != (expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber))) {
            Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
        }
        long sampleTimeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, this.payloadFormat.clockRate);
        int size = data.bytesLeft();
        this.trackOutput.sampleData(data, size);
        this.trackOutput.sampleMetadata(sampleTimeUs, 1, size, 0, null);
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
    }
}

