/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpReaderUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.primitives.Bytes;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpMpeg4Reader
implements RtpPayloadReader {
    private static final String TAG = "RtpMpeg4Reader";
    private static final int MEDIA_CLOCK_FREQUENCY = 90000;
    private static final int I_VOP = 0;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private int bufferFlags;
    private long firstReceivedTimestamp;
    private int previousSequenceNumber;
    private long startTimeOffsetUs;
    private int sampleLength;

    public RtpMpeg4Reader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        int expectedSequenceNumber;
        Assertions.checkStateNotNull((Object)this.trackOutput);
        if (this.previousSequenceNumber != -1 && sequenceNumber != (expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber))) {
            Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d. Dropping packet.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
        }
        int limit = data.bytesLeft();
        this.trackOutput.sampleData(data, limit);
        if (this.sampleLength == 0) {
            this.bufferFlags = RtpMpeg4Reader.getBufferFlagsFromVop(data);
        }
        this.sampleLength += limit;
        if (rtpMarker) {
            if (this.firstReceivedTimestamp == -9223372036854775807L) {
                this.firstReceivedTimestamp = timestamp;
            }
            long timeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, 90000);
            this.trackOutput.sampleMetadata(timeUs, this.bufferFlags, this.sampleLength, 0, null);
            this.sampleLength = 0;
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
        this.sampleLength = 0;
    }

    private static int getBufferFlagsFromVop(ParsableByteArray data) {
        byte[] startCode;
        byte[] inputData = data.getData();
        int vopStartCodePos = Bytes.indexOf((byte[])inputData, (byte[])(startCode = new byte[]{0, 0, 1, -74}));
        if (vopStartCodePos != -1) {
            data.setPosition(vopStartCodePos + 4);
            int vopType = data.peekUnsignedByte() >> 6;
            return vopType == 0 ? 1 : 0;
        }
        return 0;
    }
}

