/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpReaderUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpMp4aReader
implements RtpPayloadReader {
    private static final String TAG = "RtpMp4aReader";
    private static final String PARAMETER_MP4A_CONFIG = "config";
    private final RtpPayloadFormat payloadFormat;
    private final int numberOfSubframes;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private int previousSequenceNumber;
    private int fragmentedSampleSizeBytes;
    private long startTimeOffsetUs;
    private long fragmentedSampleTimeUs;

    public RtpMp4aReader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        try {
            this.numberOfSubframes = RtpMp4aReader.getNumOfSubframesFromMpeg4AudioConfig(payloadFormat.fmtpParameters);
        }
        catch (ParserException e) {
            throw new IllegalArgumentException(e);
        }
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
        this.fragmentedSampleSizeBytes = 0;
        this.startTimeOffsetUs = 0L;
        this.fragmentedSampleTimeUs = -9223372036854775807L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 2);
        ((TrackOutput)Util.castNonNull((Object)this.trackOutput)).format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        Assertions.checkState((this.firstReceivedTimestamp == -9223372036854775807L ? 1 : 0) != 0);
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
        if (this.fragmentedSampleSizeBytes > 0 && expectedSequenceNumber < sequenceNumber) {
            this.outputSampleMetadataForFragmentedPackets();
        }
        for (int subFrameIndex = 0; subFrameIndex < this.numberOfSubframes; ++subFrameIndex) {
            int sampleLength = 0;
            while (data.getPosition() < data.limit()) {
                int payloadMuxLength = data.readUnsignedByte();
                sampleLength += payloadMuxLength;
                if (payloadMuxLength == 255) continue;
                break;
            }
            this.trackOutput.sampleData(data, sampleLength);
            this.fragmentedSampleSizeBytes += sampleLength;
        }
        this.fragmentedSampleTimeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, this.payloadFormat.clockRate);
        if (rtpMarker) {
            this.outputSampleMetadataForFragmentedPackets();
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.fragmentedSampleSizeBytes = 0;
        this.startTimeOffsetUs = timeUs;
    }

    private static int getNumOfSubframesFromMpeg4AudioConfig(ImmutableMap<String, String> fmtpAttributes) throws ParserException {
        String configInput = (String)fmtpAttributes.get((Object)PARAMETER_MP4A_CONFIG);
        int numberOfSubframes = 0;
        if (configInput != null && configInput.length() % 2 == 0) {
            byte[] configBuffer = Util.getBytesFromHexString((String)configInput);
            ParsableBitArray scratchBits = new ParsableBitArray(configBuffer);
            int audioMuxVersion = scratchBits.readBits(1);
            if (audioMuxVersion == 0) {
                Assertions.checkArgument((scratchBits.readBits(1) == 1 ? 1 : 0) != 0, (Object)"Only supports allStreamsSameTimeFraming.");
                numberOfSubframes = scratchBits.readBits(6);
                Assertions.checkArgument((scratchBits.readBits(4) == 0 ? 1 : 0) != 0, (Object)"Only suppors one program.");
                Assertions.checkArgument((scratchBits.readBits(3) == 0 ? 1 : 0) != 0, (Object)"Only suppors one layer.");
            } else {
                throw ParserException.createForMalformedDataOfUnknownType((String)("unsupported audio mux version: " + audioMuxVersion), null);
            }
        }
        return numberOfSubframes + 1;
    }

    private void outputSampleMetadataForFragmentedPackets() {
        ((TrackOutput)Assertions.checkNotNull((Object)this.trackOutput)).sampleMetadata(this.fragmentedSampleTimeUs, 1, this.fragmentedSampleSizeBytes, 0, null);
        this.fragmentedSampleSizeBytes = 0;
        this.fragmentedSampleTimeUs = -9223372036854775807L;
    }
}

