/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp.reader;

import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.TrackOutput;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.source.rtsp.reader.RtpReaderUtils;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableBitArray;
import com.google.android.exoplayer2.util.ParsableByteArray;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpAacReader
implements RtpPayloadReader {
    private static final String AAC_LOW_BITRATE_MODE = "AAC-lbr";
    private static final String AAC_HIGH_BITRATE_MODE = "AAC-hbr";
    private static final String TAG = "RtpAacReader";
    private final RtpPayloadFormat payloadFormat;
    private final ParsableBitArray auHeaderScratchBit;
    private final int sampleRate;
    private final int auSizeFieldBitSize;
    private final int auIndexFieldBitSize;
    private final int numBitsInAuHeader;
    private long firstReceivedTimestamp;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long startTimeOffsetUs;

    public RtpAacReader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.auHeaderScratchBit = new ParsableBitArray();
        this.sampleRate = this.payloadFormat.clockRate;
        String mode = (String)Assertions.checkNotNull((Object)((String)payloadFormat.fmtpParameters.get((Object)"mode")));
        if (Ascii.equalsIgnoreCase((CharSequence)mode, (CharSequence)AAC_HIGH_BITRATE_MODE)) {
            this.auSizeFieldBitSize = 13;
            this.auIndexFieldBitSize = 3;
        } else if (Ascii.equalsIgnoreCase((CharSequence)mode, (CharSequence)AAC_LOW_BITRATE_MODE)) {
            this.auSizeFieldBitSize = 6;
            this.auIndexFieldBitSize = 2;
        } else {
            throw new UnsupportedOperationException("AAC mode not supported");
        }
        this.numBitsInAuHeader = this.auIndexFieldBitSize + this.auSizeFieldBitSize;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 1);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkNotNull((Object)this.trackOutput);
        short auHeadersBitLength = data.readShort();
        int auHeaderCount = auHeadersBitLength / this.numBitsInAuHeader;
        long sampleTimeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, this.sampleRate);
        this.auHeaderScratchBit.reset(data);
        if (auHeaderCount == 1) {
            int auSize = this.auHeaderScratchBit.readBits(this.auSizeFieldBitSize);
            this.auHeaderScratchBit.skipBits(this.auIndexFieldBitSize);
            this.trackOutput.sampleData(data, data.bytesLeft());
            if (rtpMarker) {
                RtpAacReader.outputSampleMetadata(this.trackOutput, sampleTimeUs, auSize);
            }
        } else {
            data.skipBytes((auHeadersBitLength + 7) / 8);
            for (int i = 0; i < auHeaderCount; ++i) {
                int auSize = this.auHeaderScratchBit.readBits(this.auSizeFieldBitSize);
                this.auHeaderScratchBit.skipBits(this.auIndexFieldBitSize);
                this.trackOutput.sampleData(data, auSize);
                RtpAacReader.outputSampleMetadata(this.trackOutput, sampleTimeUs, auSize);
                sampleTimeUs += Util.scaleLargeTimestamp((long)auHeaderCount, (long)1000000L, (long)this.sampleRate);
            }
        }
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
    }

    private static void outputSampleMetadata(TrackOutput trackOutput, long sampleTimeUs, int size) {
        trackOutput.sampleMetadata(sampleTimeUs, 1, size, 0, null);
    }
}

