/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import com.google.android.exoplayer2.source.rtsp.RtpDataChannel;
import com.google.android.exoplayer2.source.rtsp.RtpUtils;
import com.google.android.exoplayer2.source.rtsp.TransferRtpDataChannelFactory;
import com.google.android.exoplayer2.source.rtsp.UdpDataSourceRtpDataChannel;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceUtil;
import java.io.IOException;

final class UdpDataSourceRtpDataChannelFactory
implements RtpDataChannel.Factory {
    private final long socketTimeoutMs;

    public UdpDataSourceRtpDataChannelFactory(long socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    @Override
    public RtpDataChannel createAndOpenDataChannel(int trackId) throws IOException {
        UdpDataSourceRtpDataChannel firstChannel = new UdpDataSourceRtpDataChannel(this.socketTimeoutMs);
        UdpDataSourceRtpDataChannel secondChannel = new UdpDataSourceRtpDataChannel(this.socketTimeoutMs);
        try {
            firstChannel.open(RtpUtils.getIncomingRtpDataSpec(0));
            int firstPort = firstChannel.getLocalPort();
            boolean isFirstPortEven = firstPort % 2 == 0;
            int portToOpen = isFirstPortEven ? firstPort + 1 : firstPort - 1;
            secondChannel.open(RtpUtils.getIncomingRtpDataSpec(portToOpen));
            if (isFirstPortEven) {
                firstChannel.setRtcpChannel(secondChannel);
                return firstChannel;
            }
            secondChannel.setRtcpChannel(firstChannel);
            return secondChannel;
        }
        catch (IOException e) {
            DataSourceUtil.closeQuietly((DataSource)firstChannel);
            DataSourceUtil.closeQuietly((DataSource)secondChannel);
            throw e;
        }
    }

    @Override
    public RtpDataChannel.Factory createFallbackDataChannelFactory() {
        return new TransferRtpDataChannelFactory(this.socketTimeoutMs);
    }
}

