/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.source.rtsp.MediaDescription;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.HashMap;
import java.util.Map;

final class SessionDescription {
    public static final String SUPPORTED_SDP_VERSION = "0";
    public static final String ATTR_CONTROL = "control";
    public static final String ATTR_FMTP = "fmtp";
    public static final String ATTR_LENGTH = "length";
    public static final String ATTR_RANGE = "range";
    public static final String ATTR_RTPMAP = "rtpmap";
    public static final String ATTR_TOOL = "tool";
    public static final String ATTR_TYPE = "type";
    public final ImmutableMap<String, String> attributes;
    public final ImmutableList<MediaDescription> mediaDescriptionList;
    @Nullable
    public final String sessionName;
    @Nullable
    public final String origin;
    @Nullable
    public final String timing;
    public final int bitrate;
    @Nullable
    public final Uri uri;
    @Nullable
    public final String connection;
    @Nullable
    public final String key;
    @Nullable
    public final String emailAddress;
    @Nullable
    public final String phoneNumber;
    @Nullable
    public final String sessionInfo;

    private SessionDescription(Builder builder) {
        this.attributes = ImmutableMap.copyOf((Map)builder.attributes);
        this.mediaDescriptionList = builder.mediaDescriptionListBuilder.build();
        this.sessionName = (String)Util.castNonNull((Object)builder.sessionName);
        this.origin = (String)Util.castNonNull((Object)builder.origin);
        this.timing = (String)Util.castNonNull((Object)builder.timing);
        this.uri = builder.uri;
        this.connection = builder.connection;
        this.bitrate = builder.bitrate;
        this.key = builder.key;
        this.emailAddress = builder.emailAddress;
        this.phoneNumber = builder.phoneNumber;
        this.sessionInfo = builder.sessionInfo;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionDescription that = (SessionDescription)o;
        return this.bitrate == that.bitrate && this.attributes.equals(that.attributes) && this.mediaDescriptionList.equals(that.mediaDescriptionList) && Util.areEqual((Object)this.origin, (Object)that.origin) && Util.areEqual((Object)this.sessionName, (Object)that.sessionName) && Util.areEqual((Object)this.timing, (Object)that.timing) && Util.areEqual((Object)this.sessionInfo, (Object)that.sessionInfo) && Util.areEqual((Object)this.uri, (Object)that.uri) && Util.areEqual((Object)this.emailAddress, (Object)that.emailAddress) && Util.areEqual((Object)this.phoneNumber, (Object)that.phoneNumber) && Util.areEqual((Object)this.connection, (Object)that.connection) && Util.areEqual((Object)this.key, (Object)that.key);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.mediaDescriptionList.hashCode();
        result = 31 * result + (this.origin == null ? 0 : this.origin.hashCode());
        result = 31 * result + (this.sessionName == null ? 0 : this.sessionName.hashCode());
        result = 31 * result + (this.timing == null ? 0 : this.timing.hashCode());
        result = 31 * result + this.bitrate;
        result = 31 * result + (this.sessionInfo == null ? 0 : this.sessionInfo.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.emailAddress == null ? 0 : this.emailAddress.hashCode());
        result = 31 * result + (this.phoneNumber == null ? 0 : this.phoneNumber.hashCode());
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public static final class Builder {
        private final HashMap<String, String> attributes = new HashMap();
        private final ImmutableList.Builder<MediaDescription> mediaDescriptionListBuilder = new ImmutableList.Builder();
        private int bitrate = -1;
        @Nullable
        private String sessionName;
        @Nullable
        private String origin;
        @Nullable
        private String timing;
        @Nullable
        private Uri uri;
        @Nullable
        private String connection;
        @Nullable
        private String key;
        @Nullable
        private String sessionInfo;
        @Nullable
        private String emailAddress;
        @Nullable
        private String phoneNumber;

        @CanIgnoreReturnValue
        public Builder setSessionName(String sessionName) {
            this.sessionName = sessionName;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSessionInfo(String sessionInfo) {
            this.sessionInfo = sessionInfo;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setUri(Uri uri) {
            this.uri = uri;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setOrigin(String origin) {
            this.origin = origin;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConnection(String connection) {
            this.connection = connection;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setTiming(String timing) {
            this.timing = timing;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setPhoneNumber(String phoneNumber) {
            this.phoneNumber = phoneNumber;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAttribute(String attributeName, String attributeValue) {
            this.attributes.put(attributeName, attributeValue);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addMediaDescription(MediaDescription mediaDescription) {
            this.mediaDescriptionListBuilder.add((Object)mediaDescription);
            return this;
        }

        public SessionDescription build() {
            return new SessionDescription(this);
        }
    }
}

