/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.ExoPlayerLibraryInfo;
import com.google.android.exoplayer2.MediaItem;
import com.google.android.exoplayer2.Timeline;
import com.google.android.exoplayer2.drm.DrmSessionManagerProvider;
import com.google.android.exoplayer2.source.BaseMediaSource;
import com.google.android.exoplayer2.source.ForwardingTimeline;
import com.google.android.exoplayer2.source.MediaPeriod;
import com.google.android.exoplayer2.source.MediaSource;
import com.google.android.exoplayer2.source.MediaSourceFactory;
import com.google.android.exoplayer2.source.SinglePeriodTimeline;
import com.google.android.exoplayer2.source.rtsp.RtpDataChannel;
import com.google.android.exoplayer2.source.rtsp.RtspMediaPeriod;
import com.google.android.exoplayer2.source.rtsp.RtspSessionTiming;
import com.google.android.exoplayer2.source.rtsp.TransferRtpDataChannelFactory;
import com.google.android.exoplayer2.source.rtsp.UdpDataSourceRtpDataChannelFactory;
import com.google.android.exoplayer2.upstream.Allocator;
import com.google.android.exoplayer2.upstream.LoadErrorHandlingPolicy;
import com.google.android.exoplayer2.upstream.TransferListener;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;
import javax.net.SocketFactory;

public final class RtspMediaSource
extends BaseMediaSource {
    public static final long DEFAULT_TIMEOUT_MS = 8000L;
    private final MediaItem mediaItem;
    private final RtpDataChannel.Factory rtpDataChannelFactory;
    private final String userAgent;
    private final Uri uri;
    private final SocketFactory socketFactory;
    private final boolean debugLoggingEnabled;
    private long timelineDurationUs;
    private boolean timelineIsSeekable;
    private boolean timelineIsLive;
    private boolean timelineIsPlaceholder;

    @VisibleForTesting
    RtspMediaSource(MediaItem mediaItem, RtpDataChannel.Factory rtpDataChannelFactory, String userAgent, SocketFactory socketFactory, boolean debugLoggingEnabled) {
        this.mediaItem = mediaItem;
        this.rtpDataChannelFactory = rtpDataChannelFactory;
        this.userAgent = userAgent;
        this.uri = ((MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)this.mediaItem.localConfiguration)).uri;
        this.socketFactory = socketFactory;
        this.debugLoggingEnabled = debugLoggingEnabled;
        this.timelineDurationUs = -9223372036854775807L;
        this.timelineIsPlaceholder = true;
    }

    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.notifySourceInfoRefreshed();
    }

    protected void releaseSourceInternal() {
    }

    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    public void maybeThrowSourceInfoRefreshError() {
    }

    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        return new RtspMediaPeriod(allocator, this.rtpDataChannelFactory, this.uri, new RtspMediaPeriod.Listener(){

            @Override
            public void onSourceInfoRefreshed(RtspSessionTiming timing) {
                RtspMediaSource.this.timelineDurationUs = Util.msToUs((long)timing.getDurationMs());
                RtspMediaSource.this.timelineIsSeekable = !timing.isLive();
                RtspMediaSource.this.timelineIsLive = timing.isLive();
                RtspMediaSource.this.timelineIsPlaceholder = false;
                RtspMediaSource.this.notifySourceInfoRefreshed();
            }

            @Override
            public void onSeekingUnsupported() {
                RtspMediaSource.this.timelineIsSeekable = false;
                RtspMediaSource.this.notifySourceInfoRefreshed();
            }
        }, this.userAgent, this.socketFactory, this.debugLoggingEnabled);
    }

    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((RtspMediaPeriod)mediaPeriod).release();
    }

    private void notifySourceInfoRefreshed() {
        Object timeline = new SinglePeriodTimeline(this.timelineDurationUs, this.timelineIsSeekable, false, this.timelineIsLive, null, this.mediaItem);
        if (this.timelineIsPlaceholder) {
            timeline = new ForwardingTimeline(this, (Timeline)timeline){

                public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
                    super.getWindow(windowIndex, window, defaultPositionProjectionUs);
                    window.isPlaceholder = true;
                    return window;
                }

                public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
                    super.getPeriod(periodIndex, period, setIds);
                    period.isPlaceholder = true;
                    return period;
                }
            };
        }
        this.refreshSourceInfo((Timeline)timeline);
    }

    static {
        ExoPlayerLibraryInfo.registerModule((String)"goog.exo.rtsp");
    }

    public static final class RtspUdpUnsupportedTransportException
    extends RtspPlaybackException {
        public RtspUdpUnsupportedTransportException(String message) {
            super(message);
        }
    }

    public static class RtspPlaybackException
    extends IOException {
        public RtspPlaybackException(String message) {
            super(message);
        }

        public RtspPlaybackException(Throwable e) {
            super(e);
        }

        public RtspPlaybackException(String message, Throwable e) {
            super(message, e);
        }
    }

    public static final class Factory
    implements MediaSourceFactory {
        private long timeoutMs = 8000L;
        private String userAgent = "ExoPlayerLib/2.18.7";
        private SocketFactory socketFactory = SocketFactory.getDefault();
        private boolean forceUseRtpTcp;
        private boolean debugLoggingEnabled;

        @CanIgnoreReturnValue
        public Factory setForceUseRtpTcp(boolean forceUseRtpTcp) {
            this.forceUseRtpTcp = forceUseRtpTcp;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setUserAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setSocketFactory(SocketFactory socketFactory) {
            this.socketFactory = socketFactory;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setDebugLoggingEnabled(boolean debugLoggingEnabled) {
            this.debugLoggingEnabled = debugLoggingEnabled;
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setTimeoutMs(@IntRange(from=1L) long timeoutMs) {
            Assertions.checkArgument((timeoutMs > 0L ? 1 : 0) != 0);
            this.timeoutMs = timeoutMs;
            return this;
        }

        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManager) {
            return this;
        }

        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            return this;
        }

        public int[] getSupportedTypes() {
            return new int[]{3};
        }

        public RtspMediaSource createMediaSource(MediaItem mediaItem) {
            Assertions.checkNotNull((Object)mediaItem.localConfiguration);
            return new RtspMediaSource(mediaItem, this.forceUseRtpTcp ? new TransferRtpDataChannelFactory(this.timeoutMs) : new UdpDataSourceRtpDataChannelFactory(this.timeoutMs), this.userAgent, this.socketFactory, this.debugLoggingEnabled);
        }
    }
}

