/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import androidx.annotation.Nullable;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import java.util.Map;

final class RtspHeaders {
    public static final String ACCEPT = "Accept";
    public static final String ALLOW = "Allow";
    public static final String AUTHORIZATION = "Authorization";
    public static final String BANDWIDTH = "Bandwidth";
    public static final String BLOCKSIZE = "Blocksize";
    public static final String CACHE_CONTROL = "Cache-Control";
    public static final String CONNECTION = "Connection";
    public static final String CONTENT_BASE = "Content-Base";
    public static final String CONTENT_ENCODING = "Content-Encoding";
    public static final String CONTENT_LANGUAGE = "Content-Language";
    public static final String CONTENT_LENGTH = "Content-Length";
    public static final String CONTENT_LOCATION = "Content-Location";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String CSEQ = "CSeq";
    public static final String DATE = "Date";
    public static final String EXPIRES = "Expires";
    public static final String LOCATION = "Location";
    public static final String PROXY_AUTHENTICATE = "Proxy-Authenticate";
    public static final String PROXY_REQUIRE = "Proxy-Require";
    public static final String PUBLIC = "Public";
    public static final String RANGE = "Range";
    public static final String RTP_INFO = "RTP-Info";
    public static final String RTCP_INTERVAL = "RTCP-Interval";
    public static final String SCALE = "Scale";
    public static final String SESSION = "Session";
    public static final String SPEED = "Speed";
    public static final String SUPPORTED = "Supported";
    public static final String TIMESTAMP = "Timestamp";
    public static final String TRANSPORT = "Transport";
    public static final String USER_AGENT = "User-Agent";
    public static final String VIA = "Via";
    public static final String WWW_AUTHENTICATE = "WWW-Authenticate";
    public static final RtspHeaders EMPTY = new Builder().build();
    private final ImmutableListMultimap<String, String> namesAndValues;

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RtspHeaders)) {
            return false;
        }
        RtspHeaders headers = (RtspHeaders)obj;
        return this.namesAndValues.equals(headers.namesAndValues);
    }

    public int hashCode() {
        return this.namesAndValues.hashCode();
    }

    public Builder buildUpon() {
        ImmutableListMultimap.Builder namesAndValuesBuilder = new ImmutableListMultimap.Builder();
        namesAndValuesBuilder.putAll(this.namesAndValues);
        return new Builder(namesAndValuesBuilder);
    }

    public ImmutableListMultimap<String, String> asMultiMap() {
        return this.namesAndValues;
    }

    @Nullable
    public String get(String headerName) {
        ImmutableList<String> headerValues = this.values(headerName);
        if (headerValues.isEmpty()) {
            return null;
        }
        return (String)Iterables.getLast(headerValues);
    }

    public ImmutableList<String> values(String headerName) {
        return this.namesAndValues.get((Object)RtspHeaders.convertToStandardHeaderName(headerName));
    }

    private RtspHeaders(Builder builder) {
        this.namesAndValues = builder.namesAndValuesBuilder.build();
    }

    private static String convertToStandardHeaderName(String messageHeaderName) {
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)ACCEPT)) {
            return ACCEPT;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)ALLOW)) {
            return ALLOW;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)AUTHORIZATION)) {
            return AUTHORIZATION;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)BANDWIDTH)) {
            return BANDWIDTH;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)BLOCKSIZE)) {
            return BLOCKSIZE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CACHE_CONTROL)) {
            return CACHE_CONTROL;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONNECTION)) {
            return CONNECTION;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONTENT_BASE)) {
            return CONTENT_BASE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONTENT_ENCODING)) {
            return CONTENT_ENCODING;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONTENT_LANGUAGE)) {
            return CONTENT_LANGUAGE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONTENT_LENGTH)) {
            return CONTENT_LENGTH;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONTENT_LOCATION)) {
            return CONTENT_LOCATION;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CONTENT_TYPE)) {
            return CONTENT_TYPE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)CSEQ)) {
            return CSEQ;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)DATE)) {
            return DATE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)EXPIRES)) {
            return EXPIRES;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)LOCATION)) {
            return LOCATION;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)PROXY_AUTHENTICATE)) {
            return PROXY_AUTHENTICATE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)PROXY_REQUIRE)) {
            return PROXY_REQUIRE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)PUBLIC)) {
            return PUBLIC;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)RANGE)) {
            return RANGE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)RTP_INFO)) {
            return RTP_INFO;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)RTCP_INTERVAL)) {
            return RTCP_INTERVAL;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)SCALE)) {
            return SCALE;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)SESSION)) {
            return SESSION;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)SPEED)) {
            return SPEED;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)SUPPORTED)) {
            return SUPPORTED;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)TIMESTAMP)) {
            return TIMESTAMP;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)TRANSPORT)) {
            return TRANSPORT;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)USER_AGENT)) {
            return USER_AGENT;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)VIA)) {
            return VIA;
        }
        if (Ascii.equalsIgnoreCase((CharSequence)messageHeaderName, (CharSequence)WWW_AUTHENTICATE)) {
            return WWW_AUTHENTICATE;
        }
        return messageHeaderName;
    }

    public static final class Builder {
        private final ImmutableListMultimap.Builder<String, String> namesAndValuesBuilder;

        public Builder() {
            this.namesAndValuesBuilder = new ImmutableListMultimap.Builder();
        }

        public Builder(String userAgent, @Nullable String sessionId, int cSeq) {
            this();
            this.add(RtspHeaders.USER_AGENT, userAgent);
            this.add(RtspHeaders.CSEQ, String.valueOf(cSeq));
            if (sessionId != null) {
                this.add(RtspHeaders.SESSION, sessionId);
            }
        }

        private Builder(ImmutableListMultimap.Builder<String, String> namesAndValuesBuilder) {
            this.namesAndValuesBuilder = namesAndValuesBuilder;
        }

        @CanIgnoreReturnValue
        public Builder add(String headerName, String headerValue) {
            this.namesAndValuesBuilder.put((Object)RtspHeaders.convertToStandardHeaderName(headerName.trim()), (Object)headerValue.trim());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(List<String> headers) {
            for (int i = 0; i < headers.size(); ++i) {
                String[] header = Util.splitAtFirst((String)headers.get(i), (String)":\\s?");
                if (header.length != 2) continue;
                this.add(header[0], header[1]);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAll(Map<String, String> headers) {
            for (Map.Entry<String, String> header : headers.entrySet()) {
                this.add(header.getKey(), header.getValue());
            }
            return this;
        }

        public RtspHeaders build() {
            return new RtspHeaders(this);
        }
    }
}

