/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.net.Uri;
import android.os.Handler;
import android.util.SparseArray;
import androidx.annotation.Nullable;
import com.google.android.exoplayer2.ParserException;
import com.google.android.exoplayer2.source.rtsp.MediaDescription;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.RtspAuthenticationInfo;
import com.google.android.exoplayer2.source.rtsp.RtspDescribeResponse;
import com.google.android.exoplayer2.source.rtsp.RtspHeaders;
import com.google.android.exoplayer2.source.rtsp.RtspMediaPeriod;
import com.google.android.exoplayer2.source.rtsp.RtspMediaSource;
import com.google.android.exoplayer2.source.rtsp.RtspMediaTrack;
import com.google.android.exoplayer2.source.rtsp.RtspMessageChannel;
import com.google.android.exoplayer2.source.rtsp.RtspMessageUtil;
import com.google.android.exoplayer2.source.rtsp.RtspOptionsResponse;
import com.google.android.exoplayer2.source.rtsp.RtspPlayResponse;
import com.google.android.exoplayer2.source.rtsp.RtspRequest;
import com.google.android.exoplayer2.source.rtsp.RtspResponse;
import com.google.android.exoplayer2.source.rtsp.RtspSessionTiming;
import com.google.android.exoplayer2.source.rtsp.RtspSetupResponse;
import com.google.android.exoplayer2.source.rtsp.RtspTrackTiming;
import com.google.android.exoplayer2.source.rtsp.SessionDescription;
import com.google.android.exoplayer2.source.rtsp.SessionDescriptionParser;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Log;
import com.google.android.exoplayer2.util.Util;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.Socket;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.SocketFactory;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtspClient
implements Closeable {
    public static final int RTSP_STATE_UNINITIALIZED = -1;
    public static final int RTSP_STATE_INIT = 0;
    public static final int RTSP_STATE_READY = 1;
    public static final int RTSP_STATE_PLAYING = 2;
    private static final String TAG = "RtspClient";
    private static final long DEFAULT_RTSP_KEEP_ALIVE_INTERVAL_MS = 30000L;
    private final SessionInfoListener sessionInfoListener;
    private final PlaybackEventListener playbackEventListener;
    private final String userAgent;
    private final SocketFactory socketFactory;
    private final boolean debugLoggingEnabled;
    private final ArrayDeque<RtspMediaPeriod.RtpLoadInfo> pendingSetupRtpLoadInfos;
    private final SparseArray<RtspRequest> pendingRequests;
    private final MessageSender messageSender;
    private Uri uri;
    private RtspMessageChannel messageChannel;
    @Nullable
    private RtspMessageUtil.RtspAuthUserInfo rtspAuthUserInfo;
    @Nullable
    private String sessionId;
    @Nullable
    private KeepAliveMonitor keepAliveMonitor;
    @Nullable
    private RtspAuthenticationInfo rtspAuthenticationInfo;
    private int rtspState;
    private boolean hasUpdatedTimelineAndTracks;
    private boolean receivedAuthorizationRequest;
    private boolean hasPendingPauseRequest;
    private long pendingSeekPositionUs;

    public RtspClient(SessionInfoListener sessionInfoListener, PlaybackEventListener playbackEventListener, String userAgent, Uri uri, SocketFactory socketFactory, boolean debugLoggingEnabled) {
        this.sessionInfoListener = sessionInfoListener;
        this.playbackEventListener = playbackEventListener;
        this.userAgent = userAgent;
        this.socketFactory = socketFactory;
        this.debugLoggingEnabled = debugLoggingEnabled;
        this.pendingSetupRtpLoadInfos = new ArrayDeque();
        this.pendingRequests = new SparseArray();
        this.messageSender = new MessageSender();
        this.uri = RtspMessageUtil.removeUserInfo(uri);
        this.messageChannel = new RtspMessageChannel(new MessageListener());
        this.rtspAuthUserInfo = RtspMessageUtil.parseUserInfo(uri);
        this.pendingSeekPositionUs = -9223372036854775807L;
        this.rtspState = -1;
    }

    public void start() throws IOException {
        try {
            this.messageChannel.open(this.getSocket(this.uri));
        }
        catch (IOException e) {
            Util.closeQuietly((Closeable)this.messageChannel);
            throw e;
        }
        this.messageSender.sendOptionsRequest(this.uri, this.sessionId);
    }

    public int getState() {
        return this.rtspState;
    }

    public void setupSelectedTracks(List<RtspMediaPeriod.RtpLoadInfo> loadInfos) {
        this.pendingSetupRtpLoadInfos.addAll(loadInfos);
        this.continueSetupRtspTrack();
    }

    public void startPlayback(long offsetMs) {
        this.messageSender.sendPlayRequest(this.uri, offsetMs, (String)Assertions.checkNotNull((Object)this.sessionId));
    }

    public void seekToUs(long positionUs) {
        if (this.rtspState == 2 && !this.hasPendingPauseRequest) {
            this.messageSender.sendPauseRequest(this.uri, (String)Assertions.checkNotNull((Object)this.sessionId));
        }
        this.pendingSeekPositionUs = positionUs;
    }

    @Override
    public void close() throws IOException {
        if (this.keepAliveMonitor != null) {
            this.keepAliveMonitor.close();
            this.keepAliveMonitor = null;
            this.messageSender.sendTeardownRequest(this.uri, (String)Assertions.checkNotNull((Object)this.sessionId));
        }
        this.messageChannel.close();
    }

    public void retryWithRtpTcp() {
        try {
            this.close();
            this.messageChannel = new RtspMessageChannel(new MessageListener());
            this.messageChannel.open(this.getSocket(this.uri));
            this.sessionId = null;
            this.receivedAuthorizationRequest = false;
            this.rtspAuthenticationInfo = null;
        }
        catch (IOException e) {
            this.playbackEventListener.onPlaybackError(new RtspMediaSource.RtspPlaybackException(e));
        }
    }

    public void registerInterleavedDataChannel(int channel, RtspMessageChannel.InterleavedBinaryDataListener interleavedBinaryDataListener) {
        this.messageChannel.registerInterleavedBinaryDataListener(channel, interleavedBinaryDataListener);
    }

    private void continueSetupRtspTrack() {
        RtspMediaPeriod.RtpLoadInfo loadInfo = this.pendingSetupRtpLoadInfos.pollFirst();
        if (loadInfo == null) {
            this.playbackEventListener.onRtspSetupCompleted();
            return;
        }
        this.messageSender.sendSetupRequest(loadInfo.getTrackUri(), loadInfo.getTransport(), this.sessionId);
    }

    private void maybeLogMessage(List<String> message) {
        if (this.debugLoggingEnabled) {
            Log.d((String)TAG, (String)Joiner.on((String)"\n").join(message));
        }
    }

    private Socket getSocket(Uri uri) throws IOException {
        Assertions.checkArgument((uri.getHost() != null ? 1 : 0) != 0);
        int rtspPort = uri.getPort() > 0 ? uri.getPort() : 554;
        return this.socketFactory.createSocket((String)Assertions.checkNotNull((Object)uri.getHost()), rtspPort);
    }

    private void dispatchRtspError(Throwable error) {
        RtspMediaSource.RtspPlaybackException playbackException;
        RtspMediaSource.RtspPlaybackException rtspPlaybackException = playbackException = error instanceof RtspMediaSource.RtspPlaybackException ? (RtspMediaSource.RtspPlaybackException)error : new RtspMediaSource.RtspPlaybackException(error);
        if (this.hasUpdatedTimelineAndTracks) {
            this.playbackEventListener.onPlaybackError(playbackException);
        } else {
            this.sessionInfoListener.onSessionTimelineRequestFailed(Strings.nullToEmpty((String)error.getMessage()), error);
        }
    }

    private static boolean serverSupportsDescribe(List<Integer> serverSupportedMethods) {
        return serverSupportedMethods.isEmpty() || serverSupportedMethods.contains(2);
    }

    private static ImmutableList<RtspMediaTrack> buildTrackList(SessionDescription sessionDescription, Uri uri) {
        ImmutableList.Builder trackListBuilder = new ImmutableList.Builder();
        for (int i = 0; i < sessionDescription.mediaDescriptionList.size(); ++i) {
            MediaDescription mediaDescription = (MediaDescription)sessionDescription.mediaDescriptionList.get(i);
            if (!RtpPayloadFormat.isFormatSupported(mediaDescription)) continue;
            trackListBuilder.add((Object)new RtspMediaTrack(mediaDescription, uri));
        }
        return trackListBuilder.build();
    }

    private final class KeepAliveMonitor
    implements Runnable,
    Closeable {
        private final Handler keepAliveHandler;
        private final long intervalMs;
        private boolean isStarted;

        public KeepAliveMonitor(long intervalMs) {
            this.intervalMs = intervalMs;
            this.keepAliveHandler = Util.createHandlerForCurrentLooper();
        }

        public void start() {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            this.keepAliveHandler.postDelayed((Runnable)this, this.intervalMs);
        }

        @Override
        public void run() {
            RtspClient.this.messageSender.sendOptionsRequest(RtspClient.this.uri, RtspClient.this.sessionId);
            this.keepAliveHandler.postDelayed((Runnable)this, this.intervalMs);
        }

        @Override
        public void close() {
            this.isStarted = false;
            this.keepAliveHandler.removeCallbacks((Runnable)this);
        }
    }

    private final class MessageListener
    implements RtspMessageChannel.MessageListener {
        private final Handler messageHandler = Util.createHandlerForCurrentLooper();

        @Override
        public void onRtspMessageReceived(List<String> message) {
            this.messageHandler.post(() -> this.handleRtspMessage(message));
        }

        private void handleRtspMessage(List<String> message) {
            RtspClient.this.maybeLogMessage(message);
            if (RtspMessageUtil.isRtspResponse(message)) {
                this.handleRtspResponse(message);
            } else {
                this.handleRtspRequest(message);
            }
        }

        private void handleRtspRequest(List<String> message) {
            RtspClient.this.messageSender.sendMethodNotAllowedResponse(Integer.parseInt((String)Assertions.checkNotNull((Object)RtspMessageUtil.parseRequest(message).headers.get("CSeq"))));
        }

        private void handleRtspResponse(List<String> message) {
            RtspResponse response = RtspMessageUtil.parseResponse(message);
            int cSeq = Integer.parseInt((String)Assertions.checkNotNull((Object)response.headers.get("CSeq")));
            RtspRequest matchingRequest = (RtspRequest)RtspClient.this.pendingRequests.get(cSeq);
            if (matchingRequest == null) {
                return;
            }
            RtspClient.this.pendingRequests.remove(cSeq);
            int requestMethod = matchingRequest.method;
            try {
                switch (response.status) {
                    case 200: {
                        break;
                    }
                    case 301: 
                    case 302: {
                        String redirectionUriString;
                        if (RtspClient.this.rtspState != -1) {
                            RtspClient.this.rtspState = 0;
                        }
                        if ((redirectionUriString = response.headers.get("Location")) == null) {
                            RtspClient.this.sessionInfoListener.onSessionTimelineRequestFailed("Redirection without new location.", null);
                        } else {
                            Uri redirectionUri = Uri.parse((String)redirectionUriString);
                            RtspClient.this.uri = RtspMessageUtil.removeUserInfo(redirectionUri);
                            RtspClient.this.rtspAuthUserInfo = RtspMessageUtil.parseUserInfo(redirectionUri);
                            RtspClient.this.messageSender.sendDescribeRequest(RtspClient.this.uri, RtspClient.this.sessionId);
                        }
                        return;
                    }
                    case 401: {
                        if (RtspClient.this.rtspAuthUserInfo != null && !RtspClient.this.receivedAuthorizationRequest) {
                            ImmutableList<String> wwwAuthenticateHeaders = response.headers.values("WWW-Authenticate");
                            if (wwwAuthenticateHeaders.isEmpty()) {
                                throw ParserException.createForMalformedManifest((String)"Missing WWW-Authenticate header in a 401 response.", null);
                            }
                            for (int i = 0; i < wwwAuthenticateHeaders.size(); ++i) {
                                RtspClient.this.rtspAuthenticationInfo = RtspMessageUtil.parseWwwAuthenticateHeader((String)wwwAuthenticateHeaders.get(i));
                                if (((RtspClient)RtspClient.this).rtspAuthenticationInfo.authenticationMechanism == 2) break;
                            }
                            RtspClient.this.messageSender.retryLastRequest();
                            RtspClient.this.receivedAuthorizationRequest = true;
                            return;
                        }
                        RtspClient.this.dispatchRtspError(new RtspMediaSource.RtspPlaybackException(RtspMessageUtil.toMethodString(requestMethod) + " " + response.status));
                        return;
                    }
                    case 461: {
                        String exceptionMessage = RtspMessageUtil.toMethodString(requestMethod) + " " + response.status;
                        String transportHeaderValue = (String)Assertions.checkNotNull((Object)matchingRequest.headers.get("Transport"));
                        RtspClient.this.dispatchRtspError(requestMethod == 10 && !transportHeaderValue.contains("TCP") ? new RtspMediaSource.RtspUdpUnsupportedTransportException(exceptionMessage) : new RtspMediaSource.RtspPlaybackException(exceptionMessage));
                        return;
                    }
                    default: {
                        RtspClient.this.dispatchRtspError(new RtspMediaSource.RtspPlaybackException(RtspMessageUtil.toMethodString(requestMethod) + " " + response.status));
                        return;
                    }
                }
                switch (requestMethod) {
                    case 4: {
                        this.onOptionsResponseReceived(new RtspOptionsResponse(response.status, (List<Integer>)RtspMessageUtil.parsePublicHeader(response.headers.get("Public"))));
                        break;
                    }
                    case 2: {
                        this.onDescribeResponseReceived(new RtspDescribeResponse(response.status, SessionDescriptionParser.parse(response.messageBody)));
                        break;
                    }
                    case 10: {
                        String sessionHeaderString = response.headers.get("Session");
                        String transportHeaderString = response.headers.get("Transport");
                        if (sessionHeaderString == null || transportHeaderString == null) {
                            throw ParserException.createForMalformedManifest((String)"Missing mandatory session or transport header", null);
                        }
                        RtspMessageUtil.RtspSessionHeader sessionHeader = RtspMessageUtil.parseSessionHeader(sessionHeaderString);
                        this.onSetupResponseReceived(new RtspSetupResponse(response.status, sessionHeader, transportHeaderString));
                        break;
                    }
                    case 6: {
                        ImmutableList trackTimingList;
                        String startTimingString = response.headers.get("Range");
                        RtspSessionTiming timing = startTimingString == null ? RtspSessionTiming.DEFAULT : RtspSessionTiming.parseTiming(startTimingString);
                        try {
                            String rtpInfoString = response.headers.get("RTP-Info");
                            trackTimingList = rtpInfoString == null ? ImmutableList.of() : RtspTrackTiming.parseTrackTiming(rtpInfoString, RtspClient.this.uri);
                        }
                        catch (ParserException e) {
                            trackTimingList = ImmutableList.of();
                        }
                        this.onPlayResponseReceived(new RtspPlayResponse(response.status, timing, (List<RtspTrackTiming>)trackTimingList));
                        break;
                    }
                    case 5: {
                        this.onPauseResponseReceived();
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 11: 
                    case 12: {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            catch (ParserException | IllegalArgumentException e) {
                RtspClient.this.dispatchRtspError(new RtspMediaSource.RtspPlaybackException(e));
            }
        }

        private void onOptionsResponseReceived(RtspOptionsResponse response) {
            if (RtspClient.this.keepAliveMonitor != null) {
                return;
            }
            if (RtspClient.serverSupportsDescribe(response.supportedMethods)) {
                RtspClient.this.messageSender.sendDescribeRequest(RtspClient.this.uri, RtspClient.this.sessionId);
            } else {
                RtspClient.this.sessionInfoListener.onSessionTimelineRequestFailed("DESCRIBE not supported.", null);
            }
        }

        private void onDescribeResponseReceived(RtspDescribeResponse response) {
            ImmutableList tracks;
            RtspSessionTiming sessionTiming = RtspSessionTiming.DEFAULT;
            String sessionRangeAttributeString = (String)response.sessionDescription.attributes.get((Object)"range");
            if (sessionRangeAttributeString != null) {
                try {
                    sessionTiming = RtspSessionTiming.parseTiming(sessionRangeAttributeString);
                }
                catch (ParserException e) {
                    RtspClient.this.sessionInfoListener.onSessionTimelineRequestFailed("SDP format error.", e);
                    return;
                }
            }
            if ((tracks = RtspClient.buildTrackList(response.sessionDescription, RtspClient.this.uri)).isEmpty()) {
                RtspClient.this.sessionInfoListener.onSessionTimelineRequestFailed("No playable track.", null);
                return;
            }
            RtspClient.this.sessionInfoListener.onSessionTimelineUpdated(sessionTiming, (ImmutableList<RtspMediaTrack>)tracks);
            RtspClient.this.hasUpdatedTimelineAndTracks = true;
        }

        private void onSetupResponseReceived(RtspSetupResponse response) {
            Assertions.checkState((RtspClient.this.rtspState != -1 ? 1 : 0) != 0);
            RtspClient.this.rtspState = 1;
            RtspClient.this.sessionId = response.sessionHeader.sessionId;
            RtspClient.this.continueSetupRtspTrack();
        }

        private void onPlayResponseReceived(RtspPlayResponse response) {
            Assertions.checkState((RtspClient.this.rtspState == 1 ? 1 : 0) != 0);
            RtspClient.this.rtspState = 2;
            if (RtspClient.this.keepAliveMonitor == null) {
                RtspClient.this.keepAliveMonitor = new KeepAliveMonitor(30000L);
                RtspClient.this.keepAliveMonitor.start();
            }
            RtspClient.this.pendingSeekPositionUs = -9223372036854775807L;
            RtspClient.this.playbackEventListener.onPlaybackStarted(Util.msToUs((long)response.sessionTiming.startTimeMs), response.trackTimingList);
        }

        private void onPauseResponseReceived() {
            Assertions.checkState((RtspClient.this.rtspState == 2 ? 1 : 0) != 0);
            RtspClient.this.rtspState = 1;
            RtspClient.this.hasPendingPauseRequest = false;
            if (RtspClient.this.pendingSeekPositionUs != -9223372036854775807L) {
                RtspClient.this.startPlayback(Util.usToMs((long)RtspClient.this.pendingSeekPositionUs));
            }
        }
    }

    private final class MessageSender {
        private int cSeq;
        private @MonotonicNonNull RtspRequest lastRequest;

        private MessageSender() {
        }

        public void sendOptionsRequest(Uri uri, @Nullable String sessionId) {
            this.sendRequest(this.getRequestWithCommonHeaders(4, sessionId, (Map<String, String>)ImmutableMap.of(), uri));
        }

        public void sendDescribeRequest(Uri uri, @Nullable String sessionId) {
            this.sendRequest(this.getRequestWithCommonHeaders(2, sessionId, (Map<String, String>)ImmutableMap.of(), uri));
        }

        public void sendSetupRequest(Uri trackUri, String transport, @Nullable String sessionId) {
            RtspClient.this.rtspState = 0;
            this.sendRequest(this.getRequestWithCommonHeaders(10, sessionId, (Map<String, String>)ImmutableMap.of((Object)"Transport", (Object)transport), trackUri));
        }

        public void sendPlayRequest(Uri uri, long offsetMs, String sessionId) {
            Assertions.checkState((RtspClient.this.rtspState == 1 || RtspClient.this.rtspState == 2 ? 1 : 0) != 0);
            this.sendRequest(this.getRequestWithCommonHeaders(6, sessionId, (Map<String, String>)ImmutableMap.of((Object)"Range", (Object)RtspSessionTiming.getOffsetStartTimeTiming(offsetMs)), uri));
        }

        public void sendTeardownRequest(Uri uri, String sessionId) {
            if (RtspClient.this.rtspState == -1 || RtspClient.this.rtspState == 0) {
                return;
            }
            RtspClient.this.rtspState = 0;
            this.sendRequest(this.getRequestWithCommonHeaders(12, sessionId, (Map<String, String>)ImmutableMap.of(), uri));
        }

        public void sendPauseRequest(Uri uri, String sessionId) {
            Assertions.checkState((RtspClient.this.rtspState == 2 ? 1 : 0) != 0);
            this.sendRequest(this.getRequestWithCommonHeaders(5, sessionId, (Map<String, String>)ImmutableMap.of(), uri));
            RtspClient.this.hasPendingPauseRequest = true;
        }

        public void retryLastRequest() {
            Assertions.checkStateNotNull((Object)this.lastRequest);
            ImmutableListMultimap<String, String> headersMultiMap = this.lastRequest.headers.asMultiMap();
            HashMap<String, String> lastRequestHeaders = new HashMap<String, String>();
            for (String headerName : headersMultiMap.keySet()) {
                if (headerName.equals("CSeq") || headerName.equals("User-Agent") || headerName.equals("Session") || headerName.equals("Authorization")) continue;
                lastRequestHeaders.put(headerName, (String)Iterables.getLast((Iterable)headersMultiMap.get((Object)headerName)));
            }
            this.sendRequest(this.getRequestWithCommonHeaders(this.lastRequest.method, RtspClient.this.sessionId, lastRequestHeaders, this.lastRequest.uri));
        }

        public void sendMethodNotAllowedResponse(int cSeq) {
            this.sendResponse(new RtspResponse(405, new RtspHeaders.Builder(RtspClient.this.userAgent, RtspClient.this.sessionId, cSeq).build()));
            this.cSeq = Math.max(this.cSeq, cSeq + 1);
        }

        private RtspRequest getRequestWithCommonHeaders(int method, @Nullable String sessionId, Map<String, String> additionalHeaders, Uri uri) {
            RtspHeaders.Builder headersBuilder = new RtspHeaders.Builder(RtspClient.this.userAgent, sessionId, this.cSeq++);
            if (RtspClient.this.rtspAuthenticationInfo != null) {
                Assertions.checkStateNotNull((Object)RtspClient.this.rtspAuthUserInfo);
                try {
                    headersBuilder.add("Authorization", RtspClient.this.rtspAuthenticationInfo.getAuthorizationHeaderValue(RtspClient.this.rtspAuthUserInfo, uri, method));
                }
                catch (ParserException e) {
                    RtspClient.this.dispatchRtspError(new RtspMediaSource.RtspPlaybackException(e));
                }
            }
            headersBuilder.addAll(additionalHeaders);
            return new RtspRequest(uri, method, headersBuilder.build(), "");
        }

        private void sendRequest(RtspRequest request) {
            int cSeq = Integer.parseInt((String)Assertions.checkNotNull((Object)request.headers.get("CSeq")));
            Assertions.checkState((RtspClient.this.pendingRequests.get(cSeq) == null ? 1 : 0) != 0);
            RtspClient.this.pendingRequests.append(cSeq, (Object)request);
            ImmutableList<String> message = RtspMessageUtil.serializeRequest(request);
            RtspClient.this.maybeLogMessage(message);
            RtspClient.this.messageChannel.send((List<String>)message);
            this.lastRequest = request;
        }

        private void sendResponse(RtspResponse response) {
            ImmutableList<String> message = RtspMessageUtil.serializeResponse(response);
            RtspClient.this.maybeLogMessage(message);
            RtspClient.this.messageChannel.send((List<String>)message);
        }
    }

    public static interface PlaybackEventListener {
        public void onRtspSetupCompleted();

        public void onPlaybackStarted(long var1, ImmutableList<RtspTrackTiming> var3);

        public void onPlaybackError(RtspMediaSource.RtspPlaybackException var1);
    }

    public static interface SessionInfoListener {
        public void onSessionTimelineUpdated(RtspSessionTiming var1, ImmutableList<RtspMediaTrack> var2);

        public void onSessionTimelineRequestFailed(String var1, @Nullable Throwable var2);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface RtspState {
    }
}

