/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.os.SystemClock;
import androidx.annotation.GuardedBy;
import com.google.android.exoplayer2.extractor.Extractor;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.extractor.SeekMap;
import com.google.android.exoplayer2.source.rtsp.RtpPacket;
import com.google.android.exoplayer2.source.rtsp.RtpPacketReorderingQueue;
import com.google.android.exoplayer2.source.rtsp.RtpPayloadFormat;
import com.google.android.exoplayer2.source.rtsp.reader.DefaultRtpPayloadReaderFactory;
import com.google.android.exoplayer2.source.rtsp.reader.RtpPayloadReader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.ParsableByteArray;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpExtractor
implements Extractor {
    private final RtpPayloadReader payloadReader;
    private final ParsableByteArray rtpPacketScratchBuffer;
    private final ParsableByteArray rtpPacketDataBuffer;
    private final int trackId;
    private final Object lock;
    private final RtpPacketReorderingQueue reorderingQueue;
    private @MonotonicNonNull ExtractorOutput output;
    private boolean firstPacketRead;
    private volatile long firstTimestamp;
    private volatile int firstSequenceNumber;
    @GuardedBy(value="lock")
    private boolean isSeekPending;
    @GuardedBy(value="lock")
    private long nextRtpTimestamp;
    @GuardedBy(value="lock")
    private long playbackStartTimeUs;

    public RtpExtractor(RtpPayloadFormat payloadFormat, int trackId) {
        this.trackId = trackId;
        this.payloadReader = (RtpPayloadReader)Assertions.checkNotNull((Object)new DefaultRtpPayloadReaderFactory().createPayloadReader(payloadFormat));
        this.rtpPacketScratchBuffer = new ParsableByteArray(65507);
        this.rtpPacketDataBuffer = new ParsableByteArray();
        this.lock = new Object();
        this.reorderingQueue = new RtpPacketReorderingQueue();
        this.firstTimestamp = -9223372036854775807L;
        this.firstSequenceNumber = -1;
        this.nextRtpTimestamp = -9223372036854775807L;
        this.playbackStartTimeUs = -9223372036854775807L;
    }

    public void setFirstTimestamp(long firstTimestamp) {
        this.firstTimestamp = firstTimestamp;
    }

    public void setFirstSequenceNumber(int firstSequenceNumber) {
        this.firstSequenceNumber = firstSequenceNumber;
    }

    public boolean hasReadFirstRtpPacket() {
        return this.firstPacketRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preSeek() {
        Object object = this.lock;
        synchronized (object) {
            this.isSeekPending = true;
        }
    }

    public boolean sniff(ExtractorInput input) {
        throw new UnsupportedOperationException("RTP packets are transmitted in a packet stream do not support sniffing.");
    }

    public void init(ExtractorOutput output) {
        this.payloadReader.createTracks(output, this.trackId);
        output.endTracks();
        output.seekMap((SeekMap)new SeekMap.Unseekable(-9223372036854775807L));
        this.output = output;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        Assertions.checkNotNull((Object)this.output);
        int bytesRead = input.read(this.rtpPacketScratchBuffer.getData(), 0, 65507);
        if (bytesRead == -1) {
            return -1;
        }
        if (bytesRead == 0) {
            return 0;
        }
        this.rtpPacketScratchBuffer.setPosition(0);
        this.rtpPacketScratchBuffer.setLimit(bytesRead);
        RtpPacket packet = RtpPacket.parse(this.rtpPacketScratchBuffer);
        if (packet == null) {
            return 0;
        }
        long packetArrivalTimeMs = SystemClock.elapsedRealtime();
        long packetCutoffTimeMs = RtpExtractor.getCutoffTimeMs(packetArrivalTimeMs);
        this.reorderingQueue.offer(packet, packetArrivalTimeMs);
        RtpPacket dequeuedPacket = this.reorderingQueue.poll(packetCutoffTimeMs);
        if (dequeuedPacket == null) {
            return 0;
        }
        packet = dequeuedPacket;
        if (!this.firstPacketRead) {
            if (this.firstTimestamp == -9223372036854775807L) {
                this.firstTimestamp = packet.timestamp;
            }
            if (this.firstSequenceNumber == -1) {
                this.firstSequenceNumber = packet.sequenceNumber;
            }
            this.payloadReader.onReceivingFirstPacket(this.firstTimestamp, this.firstSequenceNumber);
            this.firstPacketRead = true;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.isSeekPending) {
                if (this.nextRtpTimestamp != -9223372036854775807L && this.playbackStartTimeUs != -9223372036854775807L) {
                    this.reorderingQueue.reset();
                    this.payloadReader.seek(this.nextRtpTimestamp, this.playbackStartTimeUs);
                    this.isSeekPending = false;
                    this.nextRtpTimestamp = -9223372036854775807L;
                    this.playbackStartTimeUs = -9223372036854775807L;
                }
            } else {
                do {
                    this.rtpPacketDataBuffer.reset(packet.payloadData);
                    this.payloadReader.consume(this.rtpPacketDataBuffer, packet.timestamp, packet.sequenceNumber, packet.marker);
                } while ((packet = this.reorderingQueue.poll(packetCutoffTimeMs)) != null);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void seek(long nextRtpTimestamp, long playbackStartTimeUs) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isSeekPending) {
                this.isSeekPending = true;
            }
            this.nextRtpTimestamp = nextRtpTimestamp;
            this.playbackStartTimeUs = playbackStartTimeUs;
        }
    }

    public void release() {
    }

    private static long getCutoffTimeMs(long packetArrivalTimeMs) {
        return packetArrivalTimeMs - 30L;
    }
}

