/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.rtsp;

import android.os.Handler;
import com.google.android.exoplayer2.extractor.DefaultExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorInput;
import com.google.android.exoplayer2.extractor.ExtractorOutput;
import com.google.android.exoplayer2.extractor.PositionHolder;
import com.google.android.exoplayer2.source.rtsp.RtpDataChannel;
import com.google.android.exoplayer2.source.rtsp.RtpExtractor;
import com.google.android.exoplayer2.source.rtsp.RtspMediaTrack;
import com.google.android.exoplayer2.upstream.DataReader;
import com.google.android.exoplayer2.upstream.DataSource;
import com.google.android.exoplayer2.upstream.DataSourceUtil;
import com.google.android.exoplayer2.upstream.Loader;
import com.google.android.exoplayer2.util.Assertions;
import com.google.android.exoplayer2.util.Util;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpDataLoadable
implements Loader.Loadable {
    public final int trackId;
    public final RtspMediaTrack rtspMediaTrack;
    private final EventListener eventListener;
    private final ExtractorOutput output;
    private final Handler playbackThreadHandler;
    private final RtpDataChannel.Factory rtpDataChannelFactory;
    private @MonotonicNonNull RtpExtractor extractor;
    private volatile boolean loadCancelled;
    private volatile long pendingSeekPositionUs;
    private volatile long nextRtpTimestamp;

    public RtpDataLoadable(int trackId, RtspMediaTrack rtspMediaTrack, EventListener eventListener, ExtractorOutput output, RtpDataChannel.Factory rtpDataChannelFactory) {
        this.trackId = trackId;
        this.rtspMediaTrack = rtspMediaTrack;
        this.eventListener = eventListener;
        this.output = output;
        this.playbackThreadHandler = Util.createHandlerForCurrentLooper();
        this.rtpDataChannelFactory = rtpDataChannelFactory;
        this.pendingSeekPositionUs = -9223372036854775807L;
    }

    public void setTimestamp(long timestamp) {
        if (timestamp != -9223372036854775807L && !((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).hasReadFirstRtpPacket()) {
            this.extractor.setFirstTimestamp(timestamp);
        }
    }

    public void setSequenceNumber(int sequenceNumber) {
        if (!((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).hasReadFirstRtpPacket()) {
            this.extractor.setFirstSequenceNumber(sequenceNumber);
        }
    }

    public void cancelLoad() {
        this.loadCancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        RtpDataChannel dataChannel = null;
        try {
            dataChannel = this.rtpDataChannelFactory.createAndOpenDataChannel(this.trackId);
            String transport = dataChannel.getTransport();
            RtpDataChannel finalDataChannel = dataChannel;
            this.playbackThreadHandler.post(() -> this.eventListener.onTransportReady(transport, finalDataChannel));
            DefaultExtractorInput extractorInput = new DefaultExtractorInput((DataReader)Assertions.checkNotNull((Object)dataChannel), 0L, -1L);
            this.extractor = new RtpExtractor(this.rtspMediaTrack.payloadFormat, this.trackId);
            this.extractor.init(this.output);
            while (!this.loadCancelled) {
                int readResult;
                if (this.pendingSeekPositionUs != -9223372036854775807L) {
                    this.extractor.seek(this.nextRtpTimestamp, this.pendingSeekPositionUs);
                    this.pendingSeekPositionUs = -9223372036854775807L;
                }
                if ((readResult = this.extractor.read((ExtractorInput)extractorInput, new PositionHolder())) != -1) continue;
            }
        }
        catch (Throwable throwable) {
            DataSourceUtil.closeQuietly(dataChannel);
            throw throwable;
        }
        DataSourceUtil.closeQuietly((DataSource)dataChannel);
    }

    public void resetForSeek() {
        ((RtpExtractor)Assertions.checkNotNull((Object)this.extractor)).preSeek();
    }

    public void seekToUs(long positionUs, long nextRtpTimestamp) {
        this.pendingSeekPositionUs = positionUs;
        this.nextRtpTimestamp = nextRtpTimestamp;
    }

    public static interface EventListener {
        public void onTransportReady(String var1, RtpDataChannel var2);
    }
}

