/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.exoplayer2.source.dash;

import android.os.SystemClock;
import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.google.android.exoplayer2.source.dash.manifest.BaseUrl;
import com.google.android.exoplayer2.util.Util;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public final class BaseUrlExclusionList {
    private final Map<String, Long> excludedServiceLocations;
    private final Map<Integer, Long> excludedPriorities;
    private final Map<List<Pair<String, Integer>>, BaseUrl> selectionsTaken = new HashMap<List<Pair<String, Integer>>, BaseUrl>();
    private final Random random;

    public BaseUrlExclusionList() {
        this(new Random());
    }

    @VisibleForTesting
    BaseUrlExclusionList(Random random) {
        this.random = random;
        this.excludedServiceLocations = new HashMap<String, Long>();
        this.excludedPriorities = new HashMap<Integer, Long>();
    }

    public void exclude(BaseUrl baseUrlToExclude, long exclusionDurationMs) {
        long excludeUntilMs = SystemClock.elapsedRealtime() + exclusionDurationMs;
        BaseUrlExclusionList.addExclusion(baseUrlToExclude.serviceLocation, excludeUntilMs, this.excludedServiceLocations);
        if (baseUrlToExclude.priority != Integer.MIN_VALUE) {
            BaseUrlExclusionList.addExclusion(baseUrlToExclude.priority, excludeUntilMs, this.excludedPriorities);
        }
    }

    @Nullable
    public BaseUrl selectBaseUrl(List<BaseUrl> baseUrls) {
        BaseUrl baseUrl;
        List<BaseUrl> includedBaseUrls = this.applyExclusions(baseUrls);
        if (includedBaseUrls.size() < 2) {
            return (BaseUrl)Iterables.getFirst(includedBaseUrls, null);
        }
        Collections.sort(includedBaseUrls, BaseUrlExclusionList::compareBaseUrl);
        ArrayList<Pair> candidateKeys = new ArrayList<Pair>();
        int lowestPriority = includedBaseUrls.get((int)0).priority;
        for (int i = 0; i < includedBaseUrls.size(); ++i) {
            BaseUrl baseUrl2 = includedBaseUrls.get(i);
            if (lowestPriority != baseUrl2.priority) {
                if (candidateKeys.size() != 1) break;
                return includedBaseUrls.get(0);
            }
            candidateKeys.add(new Pair((Object)baseUrl2.serviceLocation, (Object)baseUrl2.weight));
        }
        if ((baseUrl = this.selectionsTaken.get(candidateKeys)) == null) {
            baseUrl = this.selectWeighted(includedBaseUrls.subList(0, candidateKeys.size()));
            this.selectionsTaken.put(candidateKeys, baseUrl);
        }
        return baseUrl;
    }

    public int getPriorityCountAfterExclusion(List<BaseUrl> baseUrls) {
        HashSet<Integer> priorities = new HashSet<Integer>();
        List<BaseUrl> includedBaseUrls = this.applyExclusions(baseUrls);
        for (int i = 0; i < includedBaseUrls.size(); ++i) {
            priorities.add(includedBaseUrls.get((int)i).priority);
        }
        return priorities.size();
    }

    public static int getPriorityCount(List<BaseUrl> baseUrls) {
        HashSet<Integer> priorities = new HashSet<Integer>();
        for (int i = 0; i < baseUrls.size(); ++i) {
            priorities.add(baseUrls.get((int)i).priority);
        }
        return priorities.size();
    }

    public void reset() {
        this.excludedServiceLocations.clear();
        this.excludedPriorities.clear();
        this.selectionsTaken.clear();
    }

    private List<BaseUrl> applyExclusions(List<BaseUrl> baseUrls) {
        long nowMs = SystemClock.elapsedRealtime();
        BaseUrlExclusionList.removeExpiredExclusions(nowMs, this.excludedServiceLocations);
        BaseUrlExclusionList.removeExpiredExclusions(nowMs, this.excludedPriorities);
        ArrayList<BaseUrl> includedBaseUrls = new ArrayList<BaseUrl>();
        for (int i = 0; i < baseUrls.size(); ++i) {
            BaseUrl baseUrl = baseUrls.get(i);
            if (this.excludedServiceLocations.containsKey(baseUrl.serviceLocation) || this.excludedPriorities.containsKey(baseUrl.priority)) continue;
            includedBaseUrls.add(baseUrl);
        }
        return includedBaseUrls;
    }

    private BaseUrl selectWeighted(List<BaseUrl> candidates) {
        int totalWeight = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            totalWeight += candidates.get((int)i).weight;
        }
        int randomChoice = this.random.nextInt(totalWeight);
        totalWeight = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            BaseUrl baseUrl = candidates.get(i);
            if (randomChoice >= (totalWeight += baseUrl.weight)) continue;
            return baseUrl;
        }
        return (BaseUrl)Iterables.getLast(candidates);
    }

    private static <T> void addExclusion(T toExclude, long excludeUntilMs, Map<T, Long> currentExclusions) {
        if (currentExclusions.containsKey(toExclude)) {
            excludeUntilMs = Math.max(excludeUntilMs, (Long)Util.castNonNull((Object)currentExclusions.get(toExclude)));
        }
        currentExclusions.put(toExclude, excludeUntilMs);
    }

    private static <T> void removeExpiredExclusions(long nowMs, Map<T, Long> exclusions) {
        ArrayList<T> expiredExclusions = new ArrayList<T>();
        for (Map.Entry<T, Long> entries : exclusions.entrySet()) {
            if (entries.getValue() > nowMs) continue;
            expiredExclusions.add(entries.getKey());
        }
        for (int i = 0; i < expiredExclusions.size(); ++i) {
            exclusions.remove(expiredExclusions.get(i));
        }
    }

    private static int compareBaseUrl(BaseUrl a, BaseUrl b) {
        int compare = Integer.compare(a.priority, b.priority);
        return compare != 0 ? compare : a.serviceLocation.compareTo(b.serviceLocation);
    }
}

