/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook.rtb;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.MediaView;
import com.facebook.ads.MediaViewListener;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeBannerAd;
import com.google.ads.mediation.facebook.FacebookAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdCallback;
import com.google.android.gms.ads.mediation.MediationNativeAdConfiguration;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;

public class FacebookRtbNativeAd
extends UnifiedNativeAdMapper {
    private MediationNativeAdConfiguration adConfiguration;
    private MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback;
    private NativeAdBase mNativeAdBase;
    private MediationNativeAdCallback mNativeAdCallback;
    private MediaView mMediaView;

    public FacebookRtbNativeAd(MediationNativeAdConfiguration adConfiguration, MediationAdLoadCallback<UnifiedNativeAdMapper, MediationNativeAdCallback> callback) {
        this.callback = callback;
        this.adConfiguration = adConfiguration;
    }

    public void render() {
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        String placementID = FacebookMediationAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            String errorMessage = FacebookMediationAdapter.createAdapterError(101, "Failed to request ad, placementID is null or empty.");
            Log.e((String)FacebookAdapter.TAG, (String)errorMessage);
            this.callback.onFailure(errorMessage);
            return;
        }
        FacebookAdapter.setMixedAudience((MediationAdConfiguration)this.adConfiguration);
        this.mMediaView = new MediaView(this.adConfiguration.getContext());
        try {
            this.mNativeAdBase = NativeAdBase.fromBidPayload((Context)this.adConfiguration.getContext(), (String)placementID, (String)this.adConfiguration.getBidResponse());
        }
        catch (Exception ex) {
            String errorMessage = FacebookMediationAdapter.createAdapterError(109, "Failed to create native ad from bid payload: " + ex.getMessage());
            Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            this.callback.onFailure(errorMessage);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.adConfiguration.getWatermark())) {
            this.mNativeAdBase.setExtraHints(new ExtraHints.Builder().mediationData(this.adConfiguration.getWatermark()).build());
        }
        this.mNativeAdBase.loadAd(this.mNativeAdBase.buildLoadAdConfig().withAdListener((NativeAdListener)new NativeListener(this.adConfiguration.getContext(), this.mNativeAdBase)).withBid(this.adConfiguration.getBidResponse()).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withPreloadedIconView(-1, -1).build());
    }

    public void mapNativeAd(Context context, NativeAdMapperListener mapperListener) {
        if (!this.containsRequiredFieldsForUnifiedNativeAd(this.mNativeAdBase)) {
            String message = "Ad from Facebook doesn't have all assets required for the app install format.";
            Log.w((String)FacebookAdapter.TAG, (String)message);
            mapperListener.onMappingFailed(message);
            return;
        }
        this.setHeadline(this.mNativeAdBase.getAdHeadline());
        ArrayList<FacebookAdapterNativeAdImage> images = new ArrayList<FacebookAdapterNativeAdImage>();
        images.add(new FacebookAdapterNativeAdImage());
        this.setImages(images);
        this.setBody(this.mNativeAdBase.getAdBodyText());
        if (this.mNativeAdBase.getPreloadedIconViewDrawable() == null) {
            if (this.mNativeAdBase.getAdIcon() == null) {
                this.setIcon(new FacebookAdapterNativeAdImage());
            } else {
                this.setIcon(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAdBase.getAdIcon().getUrl())));
            }
        } else {
            Drawable iconDrawable = this.mNativeAdBase.getPreloadedIconViewDrawable();
            FacebookAdapterNativeAdImage iconImage = new FacebookAdapterNativeAdImage(iconDrawable);
            this.setIcon(iconImage);
        }
        this.setCallToAction(this.mNativeAdBase.getAdCallToAction());
        this.setAdvertiser(this.mNativeAdBase.getAdvertiserName());
        this.mMediaView.setListener(new MediaViewListener(){

            public void onPlay(MediaView mediaView) {
            }

            public void onVolumeChange(MediaView mediaView, float v) {
            }

            public void onPause(MediaView mediaView) {
            }

            public void onComplete(MediaView mediaView) {
                if (FacebookRtbNativeAd.this.mNativeAdCallback != null) {
                    FacebookRtbNativeAd.this.mNativeAdCallback.onVideoComplete();
                }
            }

            public void onEnterFullscreen(MediaView mediaView) {
            }

            public void onExitFullscreen(MediaView mediaView) {
            }

            public void onFullscreenBackground(MediaView mediaView) {
            }

            public void onFullscreenForeground(MediaView mediaView) {
            }
        });
        this.setHasVideoContent(true);
        this.setMediaView((View)this.mMediaView);
        this.setStarRating(null);
        Bundle extras = new Bundle();
        extras.putCharSequence("id", (CharSequence)this.mNativeAdBase.getId());
        extras.putCharSequence("social_context", (CharSequence)this.mNativeAdBase.getAdSocialContext());
        this.setExtras(extras);
        AdOptionsView adOptionsView = new AdOptionsView(context, this.mNativeAdBase, null);
        this.setAdChoicesContent((View)adOptionsView);
        mapperListener.onMappingSuccess();
    }

    private boolean containsRequiredFieldsForUnifiedNativeAd(NativeAdBase nativeAd) {
        boolean hasNativeBannerAdAssets;
        boolean bl = hasNativeBannerAdAssets = nativeAd.getAdHeadline() != null && nativeAd.getAdBodyText() != null && nativeAd.getAdIcon() != null && nativeAd.getAdCallToAction() != null;
        if (nativeAd instanceof NativeBannerAd) {
            return hasNativeBannerAdAssets;
        }
        return hasNativeBannerAdAssets && nativeAd.getAdCoverImage() != null && this.mMediaView != null;
    }

    public void trackViews(View view, Map<String, View> clickableAssetViews, Map<String, View> nonClickableAssetViews) {
        this.setOverrideClickHandling(true);
        ArrayList<View> assetViews = new ArrayList<View>(clickableAssetViews.values());
        View iconView = clickableAssetViews.get("3003");
        if (this.mNativeAdBase instanceof NativeBannerAd) {
            if (iconView == null) {
                Log.w((String)FacebookAdapter.TAG, (String)"Missing or invalid native ad icon asset. Facebook impression recording might be impacted for this ad.");
                return;
            }
            if (!(iconView instanceof ImageView)) {
                String errorMessage = String.format("Native ad icon asset is rendered with an incompatible class type. Facebook impression recording might be impacted for this ad. Expected: ImageView, actual: %s.", iconView.getClass());
                Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
                return;
            }
            NativeBannerAd nativeBannerAd = (NativeBannerAd)this.mNativeAdBase;
            nativeBannerAd.registerViewForInteraction(view, (ImageView)iconView, assetViews);
        } else if (this.mNativeAdBase instanceof NativeAd) {
            NativeAd nativeAd = (NativeAd)this.mNativeAdBase;
            if (iconView instanceof ImageView) {
                nativeAd.registerViewForInteraction(view, this.mMediaView, (ImageView)iconView, assetViews);
            } else {
                Log.w((String)FacebookAdapter.TAG, (String)"Native icon asset is not of type ImageView. Calling registerViewForInteraction() without a reference to the icon view.");
                nativeAd.registerViewForInteraction(view, this.mMediaView, assetViews);
            }
        } else {
            Log.w((String)FacebookAdapter.TAG, (String)"Native ad type is not of type NativeAd or NativeBannerAd. It is not currently supported by the Facebook Adapter. Facebook impression recording might be impacted for this ad.");
        }
    }

    public void untrackView(View view) {
        if (this.mNativeAdBase != null) {
            this.mNativeAdBase.unregisterView();
        }
        super.untrackView(view);
    }

    private static interface NativeAdMapperListener {
        public void onMappingSuccess();

        public void onMappingFailed(String var1);
    }

    private class FacebookAdapterNativeAdImage
    extends NativeAd.Image {
        private Drawable mDrawable;
        private Uri mUri;

        public FacebookAdapterNativeAdImage() {
        }

        public FacebookAdapterNativeAdImage(Uri uri) {
            this.mUri = uri;
        }

        public FacebookAdapterNativeAdImage(Drawable drawable) {
            this.mDrawable = drawable;
        }

        protected void setDrawable(Drawable drawable) {
            this.mDrawable = drawable;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public double getScale() {
            return 1.0;
        }
    }

    private class NativeListener
    implements AdListener,
    NativeAdListener {
        private WeakReference<Context> mContext;
        private NativeAdBase mNativeAd;

        NativeListener(Context mContext, NativeAdBase mNativeAd) {
            this.mNativeAd = mNativeAd;
            this.mContext = new WeakReference<Context>(mContext);
        }

        public void onAdClicked(Ad ad) {
            FacebookRtbNativeAd.this.mNativeAdCallback.onAdOpened();
            FacebookRtbNativeAd.this.mNativeAdCallback.onAdLeftApplication();
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onAdLoaded(Ad ad) {
            if (ad != this.mNativeAd) {
                String errorMessage = FacebookMediationAdapter.createAdapterError(106, "Ad Loaded is not a Native Ad.");
                Log.e((String)FacebookAdapter.TAG, (String)errorMessage);
                FacebookRtbNativeAd.this.callback.onFailure(errorMessage);
                return;
            }
            Context context = (Context)this.mContext.get();
            if (context == null) {
                String errorMessage = FacebookMediationAdapter.createAdapterError(107, "Context is null.");
                Log.e((String)FacebookAdapter.TAG, (String)errorMessage);
                FacebookRtbNativeAd.this.callback.onFailure(errorMessage);
                return;
            }
            FacebookRtbNativeAd.this.mapNativeAd(context, new NativeAdMapperListener(){

                @Override
                public void onMappingSuccess() {
                    FacebookRtbNativeAd.this.mNativeAdCallback = (MediationNativeAdCallback)FacebookRtbNativeAd.this.callback.onSuccess((Object)FacebookRtbNativeAd.this);
                }

                @Override
                public void onMappingFailed(String message) {
                    String errorMessage = FacebookMediationAdapter.createAdapterError(108, message);
                    Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
                    FacebookRtbNativeAd.this.callback.onFailure(errorMessage);
                }
            });
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = FacebookMediationAdapter.createSdkError(adError);
            Log.w((String)FacebookAdapter.TAG, (String)errorMessage);
            FacebookRtbNativeAd.this.callback.onFailure(errorMessage);
        }

        public void onMediaDownloaded(Ad ad) {
            Log.d((String)FacebookAdapter.TAG, (String)"onMediaDownloaded");
        }
    }
}

