/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook.rtb;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdExtendedListener;
import com.facebook.ads.InterstitialAdListener;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAd;
import com.google.android.gms.ads.mediation.MediationInterstitialAdCallback;
import com.google.android.gms.ads.mediation.MediationInterstitialAdConfiguration;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookRtbInterstitialAd
implements MediationInterstitialAd,
InterstitialAdExtendedListener {
    private MediationInterstitialAdConfiguration adConfiguration;
    private MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback;
    private InterstitialAd interstitialAd;
    private MediationInterstitialAdCallback mInterstitalAdCallback;
    private AtomicBoolean showAdCalled = new AtomicBoolean();
    private AtomicBoolean didInterstitialAdClose = new AtomicBoolean();

    public FacebookRtbInterstitialAd(MediationInterstitialAdConfiguration adConfiguration, MediationAdLoadCallback<MediationInterstitialAd, MediationInterstitialAdCallback> callback) {
        this.adConfiguration = adConfiguration;
        this.callback = callback;
    }

    public void render() {
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        String placementID = FacebookMediationAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            String ErrorMessage = FacebookMediationAdapter.createAdapterError(101, "Failed to request ad, placementID is null or empty.");
            Log.e((String)FacebookMediationAdapter.TAG, (String)ErrorMessage);
            this.callback.onFailure(ErrorMessage);
            return;
        }
        FacebookMediationAdapter.setMixedAudience((MediationAdConfiguration)this.adConfiguration);
        this.interstitialAd = new InterstitialAd(this.adConfiguration.getContext(), placementID);
        if (!TextUtils.isEmpty((CharSequence)this.adConfiguration.getWatermark())) {
            this.interstitialAd.setExtraHints(new ExtraHints.Builder().mediationData(this.adConfiguration.getWatermark()).build());
        }
        this.interstitialAd.loadAd(this.interstitialAd.buildLoadAdConfig().withBid(this.adConfiguration.getBidResponse()).withAdListener((InterstitialAdListener)this).build());
    }

    public void showAd(Context context) {
        this.showAdCalled.set(true);
        if (!this.interstitialAd.show()) {
            String errorMessage = FacebookMediationAdapter.createAdapterError(110, "Failed to present interstitial ad.");
            Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            if (this.mInterstitalAdCallback != null) {
                this.mInterstitalAdCallback.onAdOpened();
                this.mInterstitalAdCallback.onAdClosed();
            }
        }
    }

    public void onInterstitialDisplayed(Ad ad) {
        if (this.mInterstitalAdCallback != null) {
            this.mInterstitalAdCallback.onAdOpened();
        }
    }

    public void onInterstitialDismissed(Ad ad) {
        if (!this.didInterstitialAdClose.getAndSet(true) && this.mInterstitalAdCallback != null) {
            this.mInterstitalAdCallback.onAdClosed();
        }
    }

    public void onError(Ad ad, AdError adError) {
        String errorMessage = FacebookMediationAdapter.createSdkError(adError);
        Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
        if (this.showAdCalled.get()) {
            if (this.mInterstitalAdCallback != null) {
                this.mInterstitalAdCallback.onAdOpened();
                this.mInterstitalAdCallback.onAdClosed();
            }
            return;
        }
        this.callback.onFailure(errorMessage);
    }

    public void onAdLoaded(Ad ad) {
        this.mInterstitalAdCallback = (MediationInterstitialAdCallback)this.callback.onSuccess((Object)this);
    }

    public void onAdClicked(Ad ad) {
        if (this.mInterstitalAdCallback != null) {
            this.mInterstitalAdCallback.onAdLeftApplication();
        }
    }

    public void onLoggingImpression(Ad ad) {
        if (this.mInterstitalAdCallback != null) {
            // empty if block
        }
    }

    public void onInterstitialActivityDestroyed() {
        if (!this.didInterstitialAdClose.getAndSet(true) && this.mInterstitalAdCallback != null) {
            this.mInterstitalAdCallback.onAdClosed();
        }
    }

    public void onRewardedAdCompleted() {
    }

    public void onRewardedAdServerSucceeded() {
    }

    public void onRewardedAdServerFailed() {
    }
}

