/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook.rtb;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdView;
import com.facebook.ads.ExtraHints;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationBannerAd;
import com.google.android.gms.ads.mediation.MediationBannerAdCallback;
import com.google.android.gms.ads.mediation.MediationBannerAdConfiguration;

public class FacebookRtbBannerAd
implements MediationBannerAd,
AdListener {
    private MediationBannerAdConfiguration adConfiguration;
    private MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback;
    private AdView adView;
    private FrameLayout mWrappedAdView;
    private MediationBannerAdCallback mBannerAdCallback;

    public FacebookRtbBannerAd(MediationBannerAdConfiguration adConfiguration, MediationAdLoadCallback<MediationBannerAd, MediationBannerAdCallback> callback) {
        this.adConfiguration = adConfiguration;
        this.callback = callback;
    }

    public void render() {
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        String placementID = FacebookMediationAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            String errorMessage = FacebookMediationAdapter.createAdapterError(101, "Failed to request ad, placementID is null or empty.");
            Log.e((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            this.callback.onFailure(errorMessage);
            return;
        }
        FacebookMediationAdapter.setMixedAudience((MediationAdConfiguration)this.adConfiguration);
        try {
            this.adView = new AdView(this.adConfiguration.getContext(), placementID, this.adConfiguration.getBidResponse());
        }
        catch (Exception exception) {
            String errorMessage = FacebookMediationAdapter.createAdapterError(111, "Failed to create banner ad: " + exception.getMessage());
            Log.e((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            this.callback.onFailure(errorMessage);
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)this.adConfiguration.getWatermark())) {
            this.adView.setExtraHints(new ExtraHints.Builder().mediationData(this.adConfiguration.getWatermark()).build());
        }
        Context context = this.adConfiguration.getContext();
        FrameLayout.LayoutParams adViewLayoutParams = new FrameLayout.LayoutParams(this.adConfiguration.getAdSize().getWidthInPixels(context), -2);
        this.mWrappedAdView = new FrameLayout(context);
        this.adView.setLayoutParams((ViewGroup.LayoutParams)adViewLayoutParams);
        this.mWrappedAdView.addView((View)this.adView);
        this.adView.loadAd(this.adView.buildLoadAdConfig().withAdListener((AdListener)this).withBid(this.adConfiguration.getBidResponse()).build());
    }

    @NonNull
    public View getView() {
        return this.mWrappedAdView;
    }

    public void onError(Ad ad, AdError adError) {
        String errorMessage = FacebookMediationAdapter.createSdkError(adError);
        Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
        this.callback.onFailure(errorMessage);
    }

    public void onAdLoaded(Ad ad) {
        this.mBannerAdCallback = (MediationBannerAdCallback)this.callback.onSuccess((Object)this);
    }

    public void onAdClicked(Ad ad) {
        if (this.mBannerAdCallback != null) {
            this.mBannerAdCallback.onAdOpened();
            this.mBannerAdCallback.onAdLeftApplication();
        }
    }

    public void onLoggingImpression(Ad ad) {
        if (this.mBannerAdCallback != null) {
            // empty if block
        }
    }
}

