/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook;

import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.NonNull;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdExperienceType;
import com.facebook.ads.ExtraHints;
import com.facebook.ads.RewardedVideoAd;
import com.facebook.ads.RewardedVideoAdExtendedListener;
import com.facebook.ads.RewardedVideoAdListener;
import com.google.ads.mediation.facebook.FacebookInitializer;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.ads.mediation.facebook.FacebookReward;
import com.google.android.gms.ads.mediation.MediationAdConfiguration;
import com.google.android.gms.ads.mediation.MediationAdLoadCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAd;
import com.google.android.gms.ads.mediation.MediationRewardedAdCallback;
import com.google.android.gms.ads.mediation.MediationRewardedAdConfiguration;
import com.google.android.gms.ads.rewarded.RewardItem;
import java.util.concurrent.atomic.AtomicBoolean;

public class FacebookRewardedAd
implements MediationRewardedAd,
RewardedVideoAdExtendedListener {
    private MediationRewardedAdConfiguration adConfiguration;
    private MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> mMediationAdLoadCallback;
    private RewardedVideoAd rewardedAd;
    private AtomicBoolean showAdCalled = new AtomicBoolean();
    private MediationRewardedAdCallback mRewardedAdCallback;
    private boolean isRtbAd = false;
    private AtomicBoolean didRewardedAdClose = new AtomicBoolean();

    public FacebookRewardedAd(MediationRewardedAdConfiguration adConfiguration, MediationAdLoadCallback<MediationRewardedAd, MediationRewardedAdCallback> callback) {
        this.adConfiguration = adConfiguration;
        this.mMediationAdLoadCallback = callback;
    }

    public void render() {
        final Context context = this.adConfiguration.getContext();
        Bundle serverParameters = this.adConfiguration.getServerParameters();
        final String placementID = FacebookMediationAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            String message = FacebookMediationAdapter.createAdapterError(101, "Failed to request ad, placementID is null or empty.");
            Log.e((String)FacebookMediationAdapter.TAG, (String)message);
            this.mMediationAdLoadCallback.onFailure(message);
            return;
        }
        String decodedBid = this.adConfiguration.getBidResponse();
        if (!TextUtils.isEmpty((CharSequence)decodedBid)) {
            this.isRtbAd = true;
        }
        FacebookMediationAdapter.setMixedAudience((MediationAdConfiguration)this.adConfiguration);
        if (this.isRtbAd) {
            this.rewardedAd = new RewardedVideoAd(context, placementID);
            if (!TextUtils.isEmpty((CharSequence)this.adConfiguration.getWatermark())) {
                this.rewardedAd.setExtraHints(new ExtraHints.Builder().mediationData(this.adConfiguration.getWatermark()).build());
            }
            this.rewardedAd.loadAd(this.rewardedAd.buildLoadAdConfig().withAdListener((RewardedVideoAdListener)this).withBid(decodedBid).withAdExperience(this.getAdExperienceType()).build());
        } else {
            FacebookInitializer.getInstance().initialize(context, placementID, new FacebookInitializer.Listener(){

                @Override
                public void onInitializeSuccess() {
                    FacebookRewardedAd.this.createAndLoadRewardedVideo(context, placementID);
                }

                @Override
                public void onInitializeError(String message) {
                    String logMessage = "Failed to load ad from Facebook: " + message;
                    String errorMessage = FacebookMediationAdapter.createAdapterError(104, logMessage);
                    Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
                    if (FacebookRewardedAd.this.mMediationAdLoadCallback != null) {
                        FacebookRewardedAd.this.mMediationAdLoadCallback.onFailure(errorMessage);
                    }
                }
            });
        }
    }

    public void showAd(Context context) {
        this.showAdCalled.set(true);
        if (!this.rewardedAd.show()) {
            String errorMessage = FacebookMediationAdapter.createAdapterError(110, "Failed to present rewarded ad.");
            Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            if (this.mRewardedAdCallback != null) {
                this.mRewardedAdCallback.onAdFailedToShow(errorMessage);
            }
            this.rewardedAd.destroy();
            return;
        }
        if (this.mRewardedAdCallback != null) {
            this.mRewardedAdCallback.onVideoStart();
            this.mRewardedAdCallback.onAdOpened();
        }
    }

    @NonNull
    AdExperienceType getAdExperienceType() {
        return AdExperienceType.AD_EXPERIENCE_TYPE_REWARDED;
    }

    private void createAndLoadRewardedVideo(Context context, String placementID) {
        this.rewardedAd = new RewardedVideoAd(context, placementID);
        this.rewardedAd.loadAd(this.rewardedAd.buildLoadAdConfig().withAdListener((RewardedVideoAdListener)this).withAdExperience(this.getAdExperienceType()).build());
    }

    public void onRewardedVideoCompleted() {
        this.mRewardedAdCallback.onVideoComplete();
        this.mRewardedAdCallback.onUserEarnedReward((RewardItem)new FacebookReward());
    }

    public void onError(Ad ad, AdError adError) {
        String errorMessage = FacebookMediationAdapter.createSdkError(adError);
        if (this.showAdCalled.get()) {
            Log.w((String)FacebookMediationAdapter.TAG, (String)("Failed to present rewarded ad: " + errorMessage));
            if (this.mRewardedAdCallback != null) {
                this.mRewardedAdCallback.onAdFailedToShow(errorMessage);
            }
        } else {
            Log.w((String)FacebookMediationAdapter.TAG, (String)("Failed to load rewarded ad: " + errorMessage));
            if (this.mMediationAdLoadCallback != null) {
                this.mMediationAdLoadCallback.onFailure(errorMessage);
            }
        }
        this.rewardedAd.destroy();
    }

    public void onAdLoaded(Ad ad) {
        if (this.mMediationAdLoadCallback != null) {
            this.mRewardedAdCallback = (MediationRewardedAdCallback)this.mMediationAdLoadCallback.onSuccess((Object)this);
        }
    }

    public void onAdClicked(Ad ad) {
        if (this.mRewardedAdCallback != null && !this.isRtbAd) {
            this.mRewardedAdCallback.reportAdClicked();
        }
    }

    public void onLoggingImpression(Ad ad) {
        if (this.mRewardedAdCallback != null && !this.isRtbAd) {
            this.mRewardedAdCallback.reportAdImpression();
        }
    }

    public void onRewardedVideoClosed() {
        if (!this.didRewardedAdClose.getAndSet(true) && this.mRewardedAdCallback != null) {
            this.mRewardedAdCallback.onAdClosed();
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
        }
    }

    public void onRewardedVideoActivityDestroyed() {
        if (!this.didRewardedAdClose.getAndSet(true) && this.mRewardedAdCallback != null) {
            this.mRewardedAdCallback.onAdClosed();
        }
        if (this.rewardedAd != null) {
            this.rewardedAd.destroy();
        }
    }
}

