/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook;

import android.content.Context;
import com.facebook.ads.AudienceNetworkAds;
import java.util.ArrayList;

class FacebookInitializer
implements AudienceNetworkAds.InitListener {
    private static FacebookInitializer instance;
    private boolean mIsInitializing = false;
    private boolean mIsInitialized = false;
    private ArrayList<Listener> mListeners = new ArrayList();

    static FacebookInitializer getInstance() {
        if (instance == null) {
            instance = new FacebookInitializer();
        }
        return instance;
    }

    private FacebookInitializer() {
    }

    void initialize(Context context, String placementId, Listener listener) {
        ArrayList<String> placements = new ArrayList<String>();
        placements.add(placementId);
        FacebookInitializer.getInstance().initialize(context, placements, listener);
    }

    void initialize(Context context, ArrayList<String> placements, Listener listener) {
        if (this.mIsInitializing) {
            this.mListeners.add(listener);
            return;
        }
        if (this.mIsInitialized) {
            listener.onInitializeSuccess();
            return;
        }
        this.mIsInitializing = true;
        FacebookInitializer.getInstance().mListeners.add(listener);
        AudienceNetworkAds.buildInitSettings((Context)context).withMediationService("GOOGLE:6.4.0.0").withPlacementIds(placements).withInitListener((AudienceNetworkAds.InitListener)this).initialize();
    }

    public void onInitialized(AudienceNetworkAds.InitResult initResult) {
        this.mIsInitializing = false;
        this.mIsInitialized = initResult.isSuccess();
        for (Listener listener : this.mListeners) {
            if (initResult.isSuccess()) {
                listener.onInitializeSuccess();
                continue;
            }
            listener.onInitializeError(initResult.getMessage());
        }
        this.mListeners.clear();
    }

    static interface Listener {
        public void onInitializeSuccess();

        public void onInitializeError(String var1);
    }
}

