/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.mediation.facebook;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.facebook.ads.Ad;
import com.facebook.ads.AdError;
import com.facebook.ads.AdListener;
import com.facebook.ads.AdOptionsView;
import com.facebook.ads.AdSettings;
import com.facebook.ads.AdSize;
import com.facebook.ads.AdView;
import com.facebook.ads.InterstitialAd;
import com.facebook.ads.InterstitialAdExtendedListener;
import com.facebook.ads.InterstitialAdListener;
import com.facebook.ads.MediaView;
import com.facebook.ads.MediaViewListener;
import com.facebook.ads.NativeAd;
import com.facebook.ads.NativeAdBase;
import com.facebook.ads.NativeAdLayout;
import com.facebook.ads.NativeAdListener;
import com.facebook.ads.NativeBannerAd;
import com.google.ads.mediation.facebook.FacebookExtras;
import com.google.ads.mediation.facebook.FacebookInitializer;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.MediationUtils;
import com.google.android.gms.ads.formats.NativeAd;
import com.google.android.gms.ads.mediation.MediationAdRequest;
import com.google.android.gms.ads.mediation.MediationBannerAdapter;
import com.google.android.gms.ads.mediation.MediationBannerListener;
import com.google.android.gms.ads.mediation.MediationInterstitialAdapter;
import com.google.android.gms.ads.mediation.MediationInterstitialListener;
import com.google.android.gms.ads.mediation.MediationNativeAdapter;
import com.google.android.gms.ads.mediation.MediationNativeListener;
import com.google.android.gms.ads.mediation.NativeMediationAdRequest;
import com.google.android.gms.ads.mediation.UnifiedNativeAdMapper;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

@Keep
public final class FacebookAdapter
extends FacebookMediationAdapter
implements MediationBannerAdapter,
MediationInterstitialAdapter,
MediationNativeAdapter {
    public static final String KEY_ID = "id";
    public static final String KEY_SOCIAL_CONTEXT_ASSET = "social_context";
    private static final int MAX_STAR_RATING = 5;
    private MediationBannerListener mBannerListener;
    private MediationInterstitialListener mInterstitialListener;
    private MediationNativeListener mNativeListener;
    private AdView mAdView;
    private FrameLayout mWrappedAdView;
    private boolean isNativeBanner;
    private InterstitialAd mInterstitialAd;
    private AtomicBoolean showInterstitialCalled = new AtomicBoolean();
    private AtomicBoolean didInterstitialAdClose = new AtomicBoolean();
    private NativeAd mNativeAd;
    private NativeBannerAd mNativeBannerAd;
    private boolean mIsImpressionRecorded;
    private MediaView mMediaView;

    public void onDestroy() {
        if (this.mAdView != null) {
            this.mAdView.destroy();
        }
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.destroy();
        }
        if (this.mNativeAd != null) {
            this.mNativeAd.unregisterView();
            this.mNativeAd.destroy();
        }
        if (this.mMediaView != null) {
            this.mMediaView.destroy();
        }
        if (this.mNativeBannerAd != null) {
            this.mNativeBannerAd.unregisterView();
            this.mNativeBannerAd.destroy();
        }
    }

    public void onPause() {
    }

    public void onResume() {
    }

    public void requestBannerAd(final Context context, MediationBannerListener listener, Bundle serverParameters, final com.google.android.gms.ads.AdSize adSize, final MediationAdRequest adRequest, Bundle mediationExtras) {
        this.mBannerListener = listener;
        final String placementID = FacebookAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            Log.e((String)TAG, (String)FacebookAdapter.createAdapterError(101, "Failed to request ad: placementID is null or empty."));
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 101);
            return;
        }
        final AdSize facebookAdSize = this.getAdSize(context, adSize);
        if (facebookAdSize == null) {
            Log.w((String)TAG, (String)FacebookAdapter.createAdapterError(102, "There is no matching Facebook ad size for Google ad size: " + adSize.toString()));
            this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)this, 102);
            return;
        }
        FacebookInitializer.getInstance().initialize(context, placementID, new FacebookInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                FacebookAdapter.this.mAdView = new AdView(context, placementID, facebookAdSize);
                FacebookAdapter.this.buildAdRequest(adRequest);
                FrameLayout.LayoutParams adViewLayoutParams = new FrameLayout.LayoutParams(adSize.getWidthInPixels(context), -2);
                FacebookAdapter.this.mWrappedAdView = new FrameLayout(context);
                FacebookAdapter.this.mAdView.setLayoutParams((ViewGroup.LayoutParams)adViewLayoutParams);
                FacebookAdapter.this.mWrappedAdView.addView((View)FacebookAdapter.this.mAdView);
                FacebookAdapter.this.mAdView.loadAd(FacebookAdapter.this.mAdView.buildLoadAdConfig().withAdListener((AdListener)new BannerListener()).build());
            }

            @Override
            public void onInitializeError(String message) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)FacebookMediationAdapter.createAdapterError(104, message));
                if (FacebookAdapter.this.mBannerListener != null) {
                    FacebookAdapter.this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)FacebookAdapter.this, 104);
                }
            }
        });
    }

    public View getBannerView() {
        return this.mWrappedAdView;
    }

    public void requestInterstitialAd(final Context context, MediationInterstitialListener listener, Bundle serverParameters, final MediationAdRequest adRequest, Bundle mediationExtras) {
        this.mInterstitialListener = listener;
        final String placementID = FacebookAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            Log.e((String)TAG, (String)FacebookAdapter.createAdapterError(101, "Failed to request ad, placementID is null or empty."));
            this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)this, 101);
            return;
        }
        FacebookInitializer.getInstance().initialize(context, placementID, new FacebookInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                FacebookAdapter.this.createAndLoadInterstitial(context, placementID, adRequest);
            }

            @Override
            public void onInitializeError(String message) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)FacebookMediationAdapter.createAdapterError(104, message));
                if (FacebookAdapter.this.mInterstitialListener != null) {
                    FacebookAdapter.this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)FacebookAdapter.this, 104);
                }
            }
        });
    }

    public void showInterstitial() {
        this.showInterstitialCalled.set(true);
        if (!this.mInterstitialAd.show()) {
            String errorMessage = FacebookAdapter.createAdapterError(110, "Failed to present interstitial ad.");
            Log.w((String)TAG, (String)errorMessage);
            if (this.mInterstitialListener != null) {
                this.mInterstitialListener.onAdOpened((MediationInterstitialAdapter)this);
                this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)this);
            }
        }
    }

    public void requestNativeAd(final Context context, MediationNativeListener listener, Bundle serverParameters, final NativeMediationAdRequest mediationAdRequest, final Bundle mediationExtras) {
        this.mNativeListener = listener;
        final String placementID = FacebookAdapter.getPlacementID(serverParameters);
        if (TextUtils.isEmpty((CharSequence)placementID)) {
            Log.e((String)TAG, (String)FacebookAdapter.createAdapterError(101, "Failed to request ad, placementID is null or empty."));
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 101);
            return;
        }
        if (!mediationAdRequest.isUnifiedNativeAdRequested()) {
            Log.e((String)TAG, (String)FacebookAdapter.createAdapterError(105, "Unified Native Ads should be requested."));
            this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)this, 105);
            return;
        }
        FacebookInitializer.getInstance().initialize(context, placementID, new FacebookInitializer.Listener(){

            @Override
            public void onInitializeSuccess() {
                FacebookAdapter.this.createAndLoadNativeAd(context, placementID, mediationAdRequest, mediationExtras);
            }

            @Override
            public void onInitializeError(String message) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)FacebookMediationAdapter.createAdapterError(104, message));
                if (FacebookAdapter.this.mNativeListener != null) {
                    FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 104);
                }
            }
        });
    }

    private void buildAdRequest(MediationAdRequest adRequest) {
        if (adRequest != null) {
            if (adRequest.taggedForChildDirectedTreatment() == 1) {
                AdSettings.setMixedAudience((boolean)true);
            } else if (adRequest.taggedForChildDirectedTreatment() == 0) {
                AdSettings.setMixedAudience((boolean)false);
            }
        }
    }

    private void createAndLoadInterstitial(Context context, String placementID, MediationAdRequest adRequest) {
        this.mInterstitialAd = new InterstitialAd(context, placementID);
        this.buildAdRequest(adRequest);
        this.mInterstitialAd.loadAd(this.mInterstitialAd.buildLoadAdConfig().withAdListener((InterstitialAdListener)new InterstitialListener()).build());
    }

    private void createAndLoadNativeAd(Context context, String placementID, NativeMediationAdRequest adRequest, Bundle mediationExtras) {
        if (mediationExtras != null) {
            this.isNativeBanner = mediationExtras.getBoolean(FacebookExtras.NATIVE_BANNER);
        }
        if (this.isNativeBanner) {
            this.mNativeBannerAd = new NativeBannerAd(context, placementID);
            this.buildAdRequest((MediationAdRequest)adRequest);
            this.mNativeBannerAd.loadAd(this.mNativeBannerAd.buildLoadAdConfig().withAdListener((NativeAdListener)new NativeBannerListener(context, this.mNativeBannerAd)).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withPreloadedIconView(-1, -1).build());
        } else {
            this.mMediaView = new MediaView(context);
            this.mNativeAd = new NativeAd(context, placementID);
            this.buildAdRequest((MediationAdRequest)adRequest);
            this.mNativeAd.loadAd(this.mNativeAd.buildLoadAdConfig().withAdListener((NativeAdListener)new NativeListener(context, this.mNativeAd)).withMediaCacheFlag(NativeAdBase.MediaCacheFlag.ALL).withPreloadedIconView(-1, -1).build());
        }
    }

    @Nullable
    private AdSize getAdSize(@NonNull Context context, @NonNull com.google.android.gms.ads.AdSize adSize) {
        int width = adSize.getWidth();
        if (width < 0) {
            float density = context.getResources().getDisplayMetrics().density;
            width = Math.round((float)adSize.getWidthInPixels(context) / density);
        }
        ArrayList<com.google.android.gms.ads.AdSize> potentials = new ArrayList<com.google.android.gms.ads.AdSize>(3);
        potentials.add(0, new com.google.android.gms.ads.AdSize(width, 50));
        potentials.add(1, new com.google.android.gms.ads.AdSize(width, 90));
        potentials.add(2, new com.google.android.gms.ads.AdSize(width, 250));
        Log.i((String)TAG, (String)("Potential ad sizes: " + potentials.toString()));
        com.google.android.gms.ads.AdSize closestSize = MediationUtils.findClosestSize((Context)context, (com.google.android.gms.ads.AdSize)adSize, potentials);
        if (closestSize == null) {
            return null;
        }
        Log.i((String)TAG, (String)("Found closest ad size: " + closestSize.toString()));
        int adHeight = closestSize.getHeight();
        if (adHeight == AdSize.BANNER_HEIGHT_50.getHeight()) {
            return AdSize.BANNER_HEIGHT_50;
        }
        if (adHeight == AdSize.BANNER_HEIGHT_90.getHeight()) {
            return AdSize.BANNER_HEIGHT_90;
        }
        if (adHeight == AdSize.RECTANGLE_HEIGHT_250.getHeight()) {
            return AdSize.RECTANGLE_HEIGHT_250;
        }
        return null;
    }

    private static interface NativeAdMapperListener {
        public void onMappingSuccess();

        public void onMappingFailed(String var1);
    }

    private class FacebookAdapterNativeAdImage
    extends NativeAd.Image {
        private Drawable mDrawable;
        private Uri mUri;

        public FacebookAdapterNativeAdImage() {
        }

        public FacebookAdapterNativeAdImage(Uri uri) {
            this.mUri = uri;
        }

        public FacebookAdapterNativeAdImage(Drawable drawable) {
            this.mDrawable = drawable;
        }

        protected void setDrawable(Drawable drawable) {
            this.mDrawable = drawable;
        }

        public Drawable getDrawable() {
            return this.mDrawable;
        }

        public Uri getUri() {
            return this.mUri;
        }

        public double getScale() {
            return 1.0;
        }
    }

    class UnifiedAdMapper
    extends UnifiedNativeAdMapper {
        private NativeAd mNativeAd;
        private NativeBannerAd mNativeBannerAd;

        public UnifiedAdMapper(NativeAd nativeAd) {
            this.mNativeAd = nativeAd;
        }

        public UnifiedAdMapper(NativeBannerAd nativeBannerAd) {
            this.mNativeBannerAd = nativeBannerAd;
        }

        public void mapUnifiedNativeAd(Context context, NativeAdMapperListener mapperListener) {
            if (FacebookAdapter.this.isNativeBanner) {
                if (!this.containsRequiredFieldsForNativeBannerAd(this.mNativeBannerAd)) {
                    String message = "Ad from Facebook doesn't have all assets required for the Native Banner Ad format.";
                    Log.w((String)FacebookMediationAdapter.TAG, (String)message);
                    mapperListener.onMappingFailed(message);
                    return;
                }
                this.setHeadline(this.mNativeBannerAd.getAdHeadline());
                this.setBody(this.mNativeBannerAd.getAdBodyText());
                if (this.mNativeBannerAd.getPreloadedIconViewDrawable() == null) {
                    if (this.mNativeBannerAd.getAdIcon() == null) {
                        this.setIcon(new FacebookAdapterNativeAdImage());
                    } else {
                        this.setIcon(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeBannerAd.getAdIcon().getUrl())));
                    }
                } else {
                    Drawable iconDrawable = this.mNativeBannerAd.getPreloadedIconViewDrawable();
                    FacebookAdapterNativeAdImage iconImage = new FacebookAdapterNativeAdImage(iconDrawable);
                    this.setIcon(iconImage);
                }
                this.setCallToAction(this.mNativeBannerAd.getAdCallToAction());
                this.setAdvertiser(this.mNativeBannerAd.getAdvertiserName());
                Bundle extras = new Bundle();
                extras.putCharSequence(FacebookAdapter.KEY_ID, (CharSequence)this.mNativeBannerAd.getId());
                extras.putCharSequence(FacebookAdapter.KEY_SOCIAL_CONTEXT_ASSET, (CharSequence)this.mNativeBannerAd.getAdSocialContext());
                this.setExtras(extras);
            } else {
                if (!this.containsRequiredFieldsForUnifiedNativeAd(this.mNativeAd)) {
                    String message = "Ad from Facebook doesn't have all assets required for the Native Ad format.";
                    Log.w((String)FacebookMediationAdapter.TAG, (String)message);
                    mapperListener.onMappingFailed(message);
                    return;
                }
                this.setHeadline(this.mNativeAd.getAdHeadline());
                ArrayList<FacebookAdapterNativeAdImage> images = new ArrayList<FacebookAdapterNativeAdImage>();
                images.add(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAd.getAdCoverImage().toString())));
                this.setImages(images);
                this.setBody(this.mNativeAd.getAdBodyText());
                if (this.mNativeAd.getPreloadedIconViewDrawable() == null) {
                    if (this.mNativeAd.getAdIcon() == null) {
                        this.setIcon(new FacebookAdapterNativeAdImage());
                    } else {
                        this.setIcon(new FacebookAdapterNativeAdImage(Uri.parse((String)this.mNativeAd.getAdIcon().getUrl())));
                    }
                } else {
                    Drawable iconDrawable = this.mNativeAd.getPreloadedIconViewDrawable();
                    FacebookAdapterNativeAdImage iconImage = new FacebookAdapterNativeAdImage(iconDrawable);
                    this.setIcon(iconImage);
                }
                this.setCallToAction(this.mNativeAd.getAdCallToAction());
                this.setAdvertiser(this.mNativeAd.getAdvertiserName());
                FacebookAdapter.this.mMediaView.setListener(new MediaViewListener(){

                    public void onPlay(MediaView mediaView) {
                    }

                    public void onVolumeChange(MediaView mediaView, float v) {
                    }

                    public void onPause(MediaView mediaView) {
                    }

                    public void onComplete(MediaView mediaView) {
                        if (FacebookAdapter.this.mNativeListener != null) {
                            FacebookAdapter.this.mNativeListener.onVideoEnd((MediationNativeAdapter)FacebookAdapter.this);
                        }
                    }

                    public void onEnterFullscreen(MediaView mediaView) {
                    }

                    public void onExitFullscreen(MediaView mediaView) {
                    }

                    public void onFullscreenBackground(MediaView mediaView) {
                    }

                    public void onFullscreenForeground(MediaView mediaView) {
                    }
                });
                this.setMediaView((View)FacebookAdapter.this.mMediaView);
                this.setHasVideoContent(true);
                Double starRating = this.getRating(this.mNativeAd.getAdStarRating());
                if (starRating != null) {
                    this.setStarRating(starRating);
                }
                Bundle extras = new Bundle();
                extras.putCharSequence(FacebookAdapter.KEY_ID, (CharSequence)this.mNativeAd.getId());
                extras.putCharSequence(FacebookAdapter.KEY_SOCIAL_CONTEXT_ASSET, (CharSequence)this.mNativeAd.getAdSocialContext());
                this.setExtras(extras);
            }
            NativeAdLayout nativeAdLayout = new NativeAdLayout(context);
            AdOptionsView adOptionsView = FacebookAdapter.this.isNativeBanner ? new AdOptionsView(context, (NativeAdBase)this.mNativeBannerAd, nativeAdLayout) : new AdOptionsView(context, (NativeAdBase)this.mNativeAd, nativeAdLayout);
            this.setAdChoicesContent((View)adOptionsView);
            mapperListener.onMappingSuccess();
        }

        private boolean containsRequiredFieldsForUnifiedNativeAd(NativeAd nativeAd) {
            return nativeAd.getAdHeadline() != null && nativeAd.getAdCoverImage() != null && nativeAd.getAdBodyText() != null && nativeAd.getAdIcon() != null && nativeAd.getAdCallToAction() != null && FacebookAdapter.this.mMediaView != null;
        }

        private boolean containsRequiredFieldsForNativeBannerAd(NativeBannerAd nativeBannerAd) {
            return nativeBannerAd.getAdHeadline() != null && nativeBannerAd.getAdBodyText() != null && nativeBannerAd.getAdIcon() != null && nativeBannerAd.getAdCallToAction() != null;
        }

        public void trackViews(View view, Map<String, View> clickableAssetViews, Map<String, View> nonClickableAssetViews) {
            this.setOverrideImpressionRecording(true);
            this.setOverrideClickHandling(true);
            Object iconView = null;
            ArrayList<View> assetViews = new ArrayList<View>();
            for (Map.Entry<String, View> clickableAssets : clickableAssetViews.entrySet()) {
                assetViews.add(clickableAssets.getValue());
                if (!clickableAssets.getKey().equals("3003")) continue;
                iconView = clickableAssets.getValue();
            }
            if (FacebookAdapter.this.isNativeBanner) {
                if (iconView == null) {
                    Log.w((String)FacebookMediationAdapter.TAG, (String)"Missing or invalid native ad icon asset. Facebook impression recording might be impacted for this ad.");
                    return;
                }
                if (!(iconView instanceof ImageView)) {
                    String errorMessage = String.format("Native ad icon asset is rendered with an incompatible class type. Facebook impression recording might be impacted for this ad. Expected: ImageView, actual: %s.", iconView.getClass());
                    Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
                    return;
                }
                this.mNativeBannerAd.registerViewForInteraction(view, (ImageView)iconView);
                return;
            }
            if (iconView instanceof ImageView) {
                this.mNativeAd.registerViewForInteraction(view, FacebookAdapter.this.mMediaView, (ImageView)iconView, assetViews);
            } else {
                Log.w((String)FacebookMediationAdapter.TAG, (String)"Native icon asset is not of type ImageView. Calling registerViewForInteraction() without a reference to the icon view.");
                this.mNativeAd.registerViewForInteraction(view, FacebookAdapter.this.mMediaView, assetViews);
            }
        }

        public void untrackView(View view) {
            if (FacebookAdapter.this.isNativeBanner && this.mNativeBannerAd != null) {
                this.mNativeBannerAd.unregisterView();
            } else if (this.mNativeAd != null) {
                this.mNativeAd.unregisterView();
            }
            super.untrackView(view);
        }

        private Double getRating(NativeAdBase.Rating rating) {
            if (rating == null) {
                return null;
            }
            return 5.0 * rating.getValue() / rating.getScale();
        }
    }

    private class NativeListener
    implements AdListener,
    NativeAdListener {
        private WeakReference<Context> mContext;
        private NativeAd mNativeAd;

        private NativeListener(Context context, NativeAd nativeAd) {
            this.mContext = new WeakReference<Context>(context);
            this.mNativeAd = nativeAd;
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mNativeListener.onAdClicked((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdOpened((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdLeftApplication((MediationNativeAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
            if (FacebookAdapter.this.mIsImpressionRecorded) {
                Log.d((String)FacebookMediationAdapter.TAG, (String)"Received onLoggingImpression callback for a native whose impression is already recorded. Ignoring the duplicate callback.");
                return;
            }
            FacebookAdapter.this.mNativeListener.onAdImpression((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mIsImpressionRecorded = true;
        }

        public void onAdLoaded(Ad ad) {
            if (ad != this.mNativeAd) {
                String errorMessage = FacebookMediationAdapter.createAdapterError(106, "Ad loaded is not a native ad.");
                Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
                FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 106);
                return;
            }
            Context context = (Context)this.mContext.get();
            if (context == null) {
                String errorMessage = FacebookMediationAdapter.createAdapterError(107, "Failed to create ad options view, Context is null.");
                Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
                FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 107);
                return;
            }
            final UnifiedAdMapper mapper = new UnifiedAdMapper(this.mNativeAd);
            mapper.mapUnifiedNativeAd(context, new NativeAdMapperListener(){

                @Override
                public void onMappingSuccess() {
                    FacebookAdapter.this.mNativeListener.onAdLoaded((MediationNativeAdapter)FacebookAdapter.this, (UnifiedNativeAdMapper)mapper);
                }

                @Override
                public void onMappingFailed(String message) {
                    String errorMessage = FacebookMediationAdapter.createAdapterError(108, message);
                    Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
                    FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 108);
                }
            });
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = FacebookMediationAdapter.createSdkError(adError);
            if (!TextUtils.isEmpty((CharSequence)adError.getErrorMessage())) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, adError.getErrorCode());
        }

        public void onMediaDownloaded(Ad ad) {
            Log.d((String)FacebookMediationAdapter.TAG, (String)"onMediaDownloaded");
        }
    }

    private class NativeBannerListener
    implements AdListener,
    NativeAdListener {
        private WeakReference<Context> mContext;
        private NativeBannerAd mNativeBannerAd;

        private NativeBannerListener(Context context, NativeBannerAd nativeBannerAd) {
            this.mContext = new WeakReference<Context>(context);
            this.mNativeBannerAd = nativeBannerAd;
        }

        public void onMediaDownloaded(Ad ad) {
            Log.d((String)FacebookMediationAdapter.TAG, (String)"onMediaDownloaded");
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = FacebookMediationAdapter.createSdkError(adError);
            if (!TextUtils.isEmpty((CharSequence)adError.getErrorMessage())) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            }
            FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, adError.getErrorCode());
        }

        public void onAdLoaded(Ad ad) {
            if (ad != this.mNativeBannerAd) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)FacebookMediationAdapter.createAdapterError(106, "Ad loaded is not a native banner ad."));
                FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 106);
                return;
            }
            Context context = (Context)this.mContext.get();
            if (context == null) {
                Log.w((String)FacebookMediationAdapter.TAG, (String)FacebookMediationAdapter.createAdapterError(107, "Failed to create ad options view, Context is null."));
                FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 107);
                return;
            }
            final UnifiedAdMapper mapper = new UnifiedAdMapper(this.mNativeBannerAd);
            mapper.mapUnifiedNativeAd(context, new NativeAdMapperListener(){

                @Override
                public void onMappingSuccess() {
                    FacebookAdapter.this.mNativeListener.onAdLoaded((MediationNativeAdapter)FacebookAdapter.this, (UnifiedNativeAdMapper)mapper);
                }

                @Override
                public void onMappingFailed(String message) {
                    String errorMessage = FacebookMediationAdapter.createAdapterError(108, message);
                    Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
                    FacebookAdapter.this.mNativeListener.onAdFailedToLoad((MediationNativeAdapter)FacebookAdapter.this, 108);
                }
            });
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mNativeListener.onAdClicked((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdOpened((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mNativeListener.onAdLeftApplication((MediationNativeAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
            if (FacebookAdapter.this.mIsImpressionRecorded) {
                Log.d((String)FacebookMediationAdapter.TAG, (String)"Received onLoggingImpression callback for a native whose impression is already recorded. Ignoring the duplicate callback.");
                return;
            }
            FacebookAdapter.this.mNativeListener.onAdImpression((MediationNativeAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mIsImpressionRecorded = true;
        }
    }

    private class InterstitialListener
    implements InterstitialAdExtendedListener {
        private InterstitialListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdClicked((MediationInterstitialAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mInterstitialListener.onAdLeftApplication((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdLoaded((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = FacebookMediationAdapter.createSdkError(adError);
            Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            if (FacebookAdapter.this.showInterstitialCalled.get()) {
                FacebookAdapter.this.mInterstitialListener.onAdOpened((MediationInterstitialAdapter)FacebookAdapter.this);
                FacebookAdapter.this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)FacebookAdapter.this);
                return;
            }
            FacebookAdapter.this.mInterstitialListener.onAdFailedToLoad((MediationInterstitialAdapter)FacebookAdapter.this, adError.getErrorCode());
        }

        public void onInterstitialDismissed(Ad ad) {
            if (!FacebookAdapter.this.didInterstitialAdClose.getAndSet(true)) {
                FacebookAdapter.this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)FacebookAdapter.this);
            }
        }

        public void onInterstitialDisplayed(Ad ad) {
            FacebookAdapter.this.mInterstitialListener.onAdOpened((MediationInterstitialAdapter)FacebookAdapter.this);
        }

        public void onInterstitialActivityDestroyed() {
            if (!FacebookAdapter.this.didInterstitialAdClose.getAndSet(true)) {
                FacebookAdapter.this.mInterstitialListener.onAdClosed((MediationInterstitialAdapter)FacebookAdapter.this);
            }
        }

        public void onRewardedAdCompleted() {
        }

        public void onRewardedAdServerSucceeded() {
        }

        public void onRewardedAdServerFailed() {
        }
    }

    private class BannerListener
    implements AdListener {
        private BannerListener() {
        }

        public void onAdClicked(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdClicked((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdOpened((MediationBannerAdapter)FacebookAdapter.this);
            FacebookAdapter.this.mBannerListener.onAdLeftApplication((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onLoggingImpression(Ad ad) {
        }

        public void onAdLoaded(Ad ad) {
            FacebookAdapter.this.mBannerListener.onAdLoaded((MediationBannerAdapter)FacebookAdapter.this);
        }

        public void onError(Ad ad, AdError adError) {
            String errorMessage = FacebookMediationAdapter.createSdkError(adError);
            Log.w((String)FacebookMediationAdapter.TAG, (String)errorMessage);
            FacebookAdapter.this.mBannerListener.onAdFailedToLoad((MediationBannerAdapter)FacebookAdapter.this, adError.getErrorCode());
        }
    }
}

