/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;

public final class ImportDeclaration
extends Node {
    private NameExpr name;
    private boolean static_;
    private boolean asterisk;
    private boolean isEmptyImportDeclaration;

    private ImportDeclaration() {
        this.isEmptyImportDeclaration = true;
        this.static_ = false;
        this.asterisk = false;
    }

    private ImportDeclaration(int beginLine, int beginColumn, int endLine, int endColumn) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.isEmptyImportDeclaration = true;
        this.static_ = false;
        this.asterisk = false;
    }

    public static ImportDeclaration createEmptyDeclaration() {
        return new ImportDeclaration();
    }

    public static ImportDeclaration createEmptyDeclaration(int beginLine, int beginColumn, int endLine, int endColumn) {
        return new ImportDeclaration(beginLine, beginColumn, endLine, endColumn);
    }

    public ImportDeclaration(NameExpr name, boolean isStatic, boolean isAsterisk) {
        this.setAsterisk(isAsterisk);
        this.setName(name);
        this.setStatic(isStatic);
        this.isEmptyImportDeclaration = false;
    }

    public ImportDeclaration(int beginLine, int beginColumn, int endLine, int endColumn, NameExpr name, boolean isStatic, boolean isAsterisk) {
        super(beginLine, beginColumn, endLine, endColumn);
        this.setAsterisk(isAsterisk);
        this.setName(name);
        this.setStatic(isStatic);
        this.isEmptyImportDeclaration = false;
    }

    public boolean isEmptyImportDeclaration() {
        return this.isEmptyImportDeclaration;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public NameExpr getName() {
        if (this.isEmptyImportDeclaration) {
            throw new UnsupportedOperationException("Empty import declarations have no name");
        }
        return this.name;
    }

    public boolean isAsterisk() {
        return this.asterisk;
    }

    public boolean isStatic() {
        return this.static_;
    }

    public void setAsterisk(boolean asterisk) {
        if (this.isEmptyImportDeclaration && asterisk) {
            throw new UnsupportedOperationException("Empty import cannot have asterisk");
        }
        this.asterisk = asterisk;
    }

    public void setName(NameExpr name) {
        if (this.isEmptyImportDeclaration) {
            throw new UnsupportedOperationException("Empty import cannot have name");
        }
        this.name = name;
        this.setAsParentNodeOf(this.name);
    }

    public void setStatic(boolean static_) {
        if (this.isEmptyImportDeclaration && static_) {
            throw new UnsupportedOperationException("Empty import cannot be static");
        }
        this.static_ = static_;
    }
}

