/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.compiler.ProcessorUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

final class RequestOptionsOverrideGenerator {
    private final TypeElement baseRequestOptionsType;
    private ProcessorUtil processorUtil;

    RequestOptionsOverrideGenerator(ProcessingEnvironment processingEnv, ProcessorUtil processorUtil) {
        this.processorUtil = processorUtil;
        this.baseRequestOptionsType = processingEnv.getElementUtils().getTypeElement("com.bumptech.glide.request.BaseRequestOptions");
    }

    List<MethodSpec> generateInstanceMethodOverridesForRequestOptions(TypeName typeToOverrideIn) {
        return this.generateInstanceMethodOverridesForRequestOptions(typeToOverrideIn, Collections.emptySet());
    }

    List<MethodSpec> generateInstanceMethodOverridesForRequestOptions(final TypeName typeToOverrideIn, final Set<String> excludedMethods) {
        return FluentIterable.from(this.processorUtil.findInstanceMethodsReturning(this.baseRequestOptionsType, this.baseRequestOptionsType)).filter((Predicate)new Predicate<ExecutableElement>(){

            public boolean apply(ExecutableElement input) {
                return !excludedMethods.contains(input.getSimpleName().toString());
            }
        }).transform((Function)new Function<ExecutableElement, MethodSpec>(){

            public MethodSpec apply(ExecutableElement input) {
                return RequestOptionsOverrideGenerator.this.generateRequestOptionOverride(typeToOverrideIn, input);
            }
        }).toList();
    }

    private MethodSpec generateRequestOptionOverride(TypeName typeToOverrideIn, ExecutableElement methodToOverride) {
        MethodSpec.Builder result = this.processorUtil.overriding(methodToOverride).returns(typeToOverrideIn);
        result.addCode(CodeBlock.builder().add("return ($T) super.$N(", new Object[]{typeToOverrideIn, methodToOverride.getSimpleName()}).add(FluentIterable.from((Iterable)result.build().parameters).transform((Function)new Function<ParameterSpec, String>(){

            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on((String)", ")), new Object[0]).add(");\n", new Object[0]).build());
        if (methodToOverride.getSimpleName().toString().contains("transform") && methodToOverride.isVarArgs()) {
            result.addModifiers(new Modifier[]{Modifier.FINAL}).addAnnotation(SafeVarargs.class).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"varargs"}).build());
        }
        for (AnnotationMirror annotationMirror : methodToOverride.getAnnotationMirrors()) {
            result.addAnnotation(AnnotationSpec.get((AnnotationMirror)annotationMirror));
        }
        return result.build();
    }
}

