/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.annotation.compiler;

import com.bumptech.glide.annotation.GlideExtension;
import com.bumptech.glide.annotation.GlideOption;
import com.bumptech.glide.annotation.compiler.GlideAnnotationProcessor;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

final class ProcessorUtil {
    private static final String GLIDE_MODULE_PACKAGE_NAME = "com.bumptech.glide.module";
    private static final String APP_GLIDE_MODULE_SIMPLE_NAME = "AppGlideModule";
    private static final String LIBRARY_GLIDE_MODULE_SIMPLE_NAME = "LibraryGlideModule";
    private static final String APP_GLIDE_MODULE_QUALIFIED_NAME = "com.bumptech.glide.module.AppGlideModule";
    private static final String LIBRARY_GLIDE_MODULE_QUALIFIED_NAME = "com.bumptech.glide.module.LibraryGlideModule";
    private static final String COMPILER_PACKAGE_NAME = GlideAnnotationProcessor.class.getPackage().getName();
    private static final ClassName SUPPORT_NONNULL_ANNOTATION = ClassName.get((String)"android.support.annotation", (String)"NonNull", (String[])new String[0]);
    private static final ClassName JETBRAINS_NOTNULL_ANNOTATION = ClassName.get((String)"org.jetbrains.annotations", (String)"NotNull", (String[])new String[0]);
    private static final ClassName ANDROIDX_NONNULL_ANNOTATION = ClassName.get((String)"androidx.annotation", (String)"NonNull", (String[])new String[0]);
    private static final ClassName SUPPORT_CHECK_RESULT_ANNOTATION = ClassName.get((String)"android.support.annotation", (String)"CheckResult", (String[])new String[0]);
    private static final ClassName ANDROIDX_CHECK_RESULT_ANNOTATION = ClassName.get((String)"androidx.annotation", (String)"CheckResult", (String[])new String[0]);
    private static final ClassName SUPPORT_VISIBLE_FOR_TESTING = ClassName.get((String)"android.support.annotation", (String)"VisibleForTesting", (String[])new String[0]);
    private static final ClassName ANDROIDX_VISIBLE_FOR_TESTING = ClassName.get((String)"androidx.annotation", (String)"VisibleForTesting", (String[])new String[0]);
    private final ProcessingEnvironment processingEnv;
    private final TypeElement appGlideModuleType;
    private final TypeElement libraryGlideModuleType;
    private int round;

    ProcessorUtil(ProcessingEnvironment processingEnv) {
        this.processingEnv = processingEnv;
        this.appGlideModuleType = processingEnv.getElementUtils().getTypeElement(APP_GLIDE_MODULE_QUALIFIED_NAME);
        this.libraryGlideModuleType = processingEnv.getElementUtils().getTypeElement(LIBRARY_GLIDE_MODULE_QUALIFIED_NAME);
    }

    void process() {
        ++this.round;
    }

    boolean isAppGlideModule(TypeElement element) {
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.appGlideModuleType.asType());
    }

    boolean isLibraryGlideModule(TypeElement element) {
        return this.processingEnv.getTypeUtils().isAssignable(element.asType(), this.libraryGlideModuleType.asType());
    }

    boolean isExtension(TypeElement element) {
        return element.getAnnotation(GlideExtension.class) != null;
    }

    int getOverrideType(ExecutableElement element) {
        GlideOption glideOption = element.getAnnotation(GlideOption.class);
        return glideOption.override();
    }

    void writeIndexer(TypeSpec indexer) {
        this.writeClass(COMPILER_PACKAGE_NAME, indexer);
    }

    void writeClass(String packageName, TypeSpec clazz) {
        try {
            this.debugLog("Writing class:\n" + String.valueOf(clazz));
            JavaFile.builder((String)packageName, (TypeSpec)clazz).skipJavaLangImports(true).build().writeTo(this.processingEnv.getFiler());
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    List<ExecutableElement> findAnnotatedElementsInClasses(Set<String> classNames, Class<? extends Annotation> annotationClass) {
        ArrayList<ExecutableElement> result = new ArrayList<ExecutableElement>();
        for (String glideExtensionClassName : classNames) {
            TypeElement glideExtension = this.processingEnv.getElementUtils().getTypeElement(glideExtensionClassName);
            for (Element element : glideExtension.getEnclosedElements()) {
                if (element.getAnnotation(annotationClass) == null) continue;
                result.add((ExecutableElement)element);
            }
        }
        return result;
    }

    List<TypeElement> getElementsFor(Class<? extends Annotation> clazz, RoundEnvironment env) {
        Set<? extends Element> annotatedElements = env.getElementsAnnotatedWith(clazz);
        return ElementFilter.typesIn(annotatedElements);
    }

    CodeBlock generateSeeMethodJavadoc(ExecutableElement method) {
        return this.generateSeeMethodJavadoc(this.getJavadocSafeName(method.getEnclosingElement()), method.getSimpleName().toString(), method.getParameters());
    }

    CodeBlock generateSeeMethodJavadoc(TypeName nameOfClassContainingMethod, String methodSimpleName, List<? extends VariableElement> methodParameters) {
        return this.generateSeeMethodJavadocInternal(nameOfClassContainingMethod, methodSimpleName, Lists.transform(methodParameters, (Function)new Function<VariableElement, Object>(){

            public Object apply(VariableElement input) {
                return ProcessorUtil.this.getJavadocSafeName(input);
            }
        }));
    }

    CodeBlock generateSeeMethodJavadoc(TypeName nameOfClassContainingMethod, MethodSpec methodSpec) {
        return this.generateSeeMethodJavadocInternal(nameOfClassContainingMethod, methodSpec.name, Lists.transform((List)methodSpec.parameters, (Function)new Function<ParameterSpec, Object>(){

            public Object apply(ParameterSpec input) {
                return input.type;
            }
        }));
    }

    private CodeBlock generateSeeMethodJavadocInternal(TypeName nameOfClassContainingMethod, String methodName, List<Object> safeParameterNames) {
        StringBuilder javadocString = new StringBuilder("@see $T#$L(");
        ArrayList<Object> javadocArgs = new ArrayList<Object>();
        javadocArgs.add(nameOfClassContainingMethod);
        javadocArgs.add(methodName);
        for (Object param : safeParameterNames) {
            javadocString.append("$T, ");
            javadocArgs.add(param);
        }
        if (javadocArgs.size() > 2) {
            javadocString = new StringBuilder(javadocString.substring(0, javadocString.length() - 2));
        }
        javadocString.append(")\n");
        return CodeBlock.of((String)javadocString.toString(), (Object[])javadocArgs.toArray(new Object[0]));
    }

    private TypeName getJavadocSafeName(Element element) {
        TypeMirror type;
        Types typeUtils = this.processingEnv.getTypeUtils();
        if (typeUtils.asElement(type = element.asType()) == null) {
            return ClassName.get((TypeMirror)element.asType());
        }
        Name simpleName = typeUtils.asElement(type).getSimpleName();
        return ClassName.bestGuess((String)simpleName.toString());
    }

    void debugLog(String toLog) {
    }

    void infoLog(String toLog) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "[" + this.round + "] " + toLog);
    }

    static CodeBlock generateCastingSuperCall(TypeName toReturn, MethodSpec method) {
        return CodeBlock.builder().add("return ($T) super.$N(", new Object[]{toReturn, method.name}).add(FluentIterable.from((Iterable)method.parameters).transform((Function)new Function<ParameterSpec, String>(){

            public String apply(ParameterSpec input) {
                return input.name;
            }
        }).join(Joiner.on((String)",")), new Object[0]).add(");\n", new Object[0]).build();
    }

    MethodSpec.Builder overriding(ExecutableElement method) {
        String methodName = method.getSimpleName().toString();
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName).addAnnotation(Override.class);
        Set<Modifier> modifiers = method.getModifiers();
        modifiers = new LinkedHashSet<Modifier>(modifiers);
        modifiers.remove((Object)Modifier.ABSTRACT);
        Modifier defaultModifier = null;
        try {
            defaultModifier = Modifier.valueOf("DEFAULT");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        modifiers.remove((Object)defaultModifier);
        builder = builder.addModifiers(modifiers);
        for (TypeParameterElement typeParameterElement : method.getTypeParameters()) {
            TypeVariable var = (TypeVariable)typeParameterElement.asType();
            builder = builder.addTypeVariable(TypeVariableName.get((TypeVariable)var));
        }
        builder = builder.returns(TypeName.get((TypeMirror)method.getReturnType())).addParameters(this.getParameters(method)).varargs(method.isVarArgs());
        for (TypeMirror typeMirror : method.getThrownTypes()) {
            builder = builder.addException(TypeName.get((TypeMirror)typeMirror));
        }
        return builder;
    }

    List<ParameterSpec> getParameters(ExecutableElement method) {
        return this.getParameters(method.getParameters());
    }

    List<ParameterSpec> getParameters(List<? extends VariableElement> parameters) {
        ArrayList<ParameterSpec> result = new ArrayList<ParameterSpec>();
        for (VariableElement variableElement : parameters) {
            result.add(this.getParameter(variableElement));
        }
        return ProcessorUtil.dedupedParameters(result);
    }

    private static List<ParameterSpec> dedupedParameters(List<ParameterSpec> parameters) {
        boolean hasDupes = false;
        HashSet<String> names = new HashSet<String>();
        for (ParameterSpec parameter : parameters) {
            String name = parameter.name;
            if (names.contains(name)) {
                hasDupes = true;
                continue;
            }
            names.add(name);
        }
        if (hasDupes) {
            List<ParameterSpec> copy = parameters;
            parameters = new ArrayList<ParameterSpec>();
            for (int i = 0; i < copy.size(); ++i) {
                ParameterSpec parameter = copy.get(i);
                parameters.add(ParameterSpec.builder((TypeName)parameter.type, (String)(parameter.name + i), (Modifier[])new Modifier[0]).addModifiers((Iterable)parameter.modifiers).addAnnotations((Iterable)parameter.annotations).build());
            }
        }
        return parameters;
    }

    private ParameterSpec getParameter(VariableElement parameter) {
        TypeName type = TypeName.get((TypeMirror)parameter.asType());
        return ParameterSpec.builder((TypeName)type, (String)ProcessorUtil.computeParameterName(parameter, type), (Modifier[])new Modifier[0]).addModifiers(parameter.getModifiers()).addAnnotations(this.getAnnotations(parameter)).build();
    }

    private static String computeParameterName(VariableElement parameter, TypeName type) {
        Object name;
        Object rawClassName = type.withoutAnnotations().toString();
        if (type.isPrimitive() || type.isBoxedPrimitive()) {
            name = ProcessorUtil.getSmartPrimitiveParameterName(parameter);
        } else {
            if (((String)rawClassName).contains("<") && ((String)rawClassName).contains(">")) {
                String[] preGenericSplit = ((String)rawClassName).split("<");
                String preGeneric = preGenericSplit[0];
                String[] stringArray = ((String)rawClassName).split(">");
                String postGeneric = stringArray[stringArray.length - 1];
                rawClassName = stringArray.length > 1 ? preGeneric + postGeneric : preGeneric;
            }
            String[] qualifiers = ((String)rawClassName).split("\\.");
            rawClassName = qualifiers[qualifiers.length - 1];
            rawClassName = ProcessorUtil.applySmartParameterNameReplacements((String)rawClassName);
            boolean allCaps = true;
            for (char c : ((String)rawClassName).toCharArray()) {
                if (!Character.isLowerCase(c)) continue;
                allCaps = false;
                break;
            }
            if (allCaps) {
                name = ((String)rawClassName).toLowerCase(Locale.ROOT);
            } else {
                int n;
                boolean bl = false;
                char[] chars = ((String)rawClassName).toCharArray();
                int charArrayLength = chars.length;
                for (int i = 0; i < charArrayLength; ++i) {
                    char c = chars[i];
                    if (!Character.isUpperCase(c)) continue;
                    n = i;
                }
                rawClassName = ((String)rawClassName).substring(n, ((String)rawClassName).length());
                name = Character.toLowerCase(((String)rawClassName).charAt(0)) + ((String)rawClassName).substring(1, ((String)rawClassName).length());
            }
        }
        return name;
    }

    private static String getSmartPrimitiveParameterName(VariableElement parameter) {
        for (AnnotationMirror annotationMirror : parameter.getAnnotationMirrors()) {
            String annotationName = annotationMirror.getAnnotationType().toString().toUpperCase(Locale.ROOT);
            if (annotationName.endsWith("RES")) {
                return "id";
            }
            if (!annotationName.endsWith("RANGE")) continue;
            return "value";
        }
        return parameter.getSimpleName().toString();
    }

    private static String applySmartParameterNameReplacements(String name) {
        name = name.replace("[]", "s");
        name = name.replace(Class.class.getSimpleName(), "clazz");
        name = name.replace(Object.class.getSimpleName(), "o");
        return name;
    }

    private List<AnnotationSpec> getAnnotations(VariableElement element) {
        ArrayList<AnnotationSpec> result = new ArrayList<AnnotationSpec>();
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            result.add(this.maybeConvertSupportLibraryAnnotation(annotationMirror));
        }
        return result;
    }

    private AnnotationSpec maybeConvertSupportLibraryAnnotation(AnnotationMirror mirror) {
        String annotationName = mirror.getAnnotationType().asElement().toString();
        boolean preferAndroidX = this.visibleForTesting().equals((Object)ANDROIDX_VISIBLE_FOR_TESTING);
        ImmutableBiMap map = ImmutableBiMap.builder().put((Object)SUPPORT_NONNULL_ANNOTATION, (Object)ANDROIDX_NONNULL_ANNOTATION).put((Object)SUPPORT_CHECK_RESULT_ANNOTATION, (Object)ANDROIDX_CHECK_RESULT_ANNOTATION).put((Object)SUPPORT_VISIBLE_FOR_TESTING, (Object)ANDROIDX_VISIBLE_FOR_TESTING).build();
        ClassName remapped = null;
        if (preferAndroidX && annotationName.startsWith("android.support.annotation")) {
            remapped = ClassName.get((TypeElement)((TypeElement)mirror.getAnnotationType().asElement()));
        } else if (!preferAndroidX && annotationName.startsWith("androidx.annotation")) {
            remapped = ClassName.get((TypeElement)((TypeElement)mirror.getAnnotationType().asElement()));
        }
        if (remapped != null && map.containsKey(remapped)) {
            return AnnotationSpec.builder((ClassName)((ClassName)map.get((Object)remapped))).build();
        }
        return AnnotationSpec.get((AnnotationMirror)mirror);
    }

    ClassName visibleForTesting() {
        return this.findAnnotationClassName(ANDROIDX_VISIBLE_FOR_TESTING, SUPPORT_VISIBLE_FOR_TESTING);
    }

    ClassName nonNull() {
        return this.findAnnotationClassName(ANDROIDX_NONNULL_ANNOTATION, SUPPORT_NONNULL_ANNOTATION);
    }

    ClassName checkResult() {
        return this.findAnnotationClassName(ANDROIDX_CHECK_RESULT_ANNOTATION, SUPPORT_CHECK_RESULT_ANNOTATION);
    }

    static List<ClassName> nonNulls() {
        return ImmutableList.of((Object)SUPPORT_NONNULL_ANNOTATION, (Object)JETBRAINS_NOTNULL_ANNOTATION, (Object)ANDROIDX_NONNULL_ANNOTATION);
    }

    private ClassName findAnnotationClassName(ClassName androidxName, ClassName supportName) {
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement visibleForTestingTypeElement = elements.getTypeElement(androidxName.reflectionName());
        if (visibleForTestingTypeElement != null) {
            return androidxName;
        }
        return supportName;
    }

    List<ExecutableElement> findInstanceMethodsReturning(TypeElement clazz, TypeMirror returnType) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter((Predicate)new FilterPublicMethods(returnType, MethodType.INSTANCE)).transform((Function)new ToMethod()).toList();
    }

    List<ExecutableElement> findInstanceMethodsReturning(TypeElement clazz, TypeElement returnType) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter((Predicate)new FilterPublicMethods(returnType, MethodType.INSTANCE)).transform((Function)new ToMethod()).toList();
    }

    List<ExecutableElement> findStaticMethodsReturning(TypeElement clazz, TypeElement returnType) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter((Predicate)new FilterPublicMethods(returnType, MethodType.STATIC)).transform((Function)new ToMethod()).toList();
    }

    List<ExecutableElement> findStaticMethods(TypeElement clazz) {
        return FluentIterable.from(clazz.getEnclosedElements()).filter((Predicate)new FilterPublicMethods((TypeMirror)null, MethodType.STATIC)).transform((Function)new ToMethod()).toList();
    }

    ImmutableSet<String> findClassValuesFromAnnotationOnClassAsNames(Element clazz, Class<? extends Annotation> annotationClass) {
        String annotationClassName = annotationClass.getName();
        AnnotationValue excludedModuleAnnotationValue = null;
        for (AnnotationMirror annotationMirror : clazz.getAnnotationMirrors()) {
            if (!annotationClassName.equals(annotationMirror.getAnnotationType().toString())) continue;
            Set<Map.Entry<? extends ExecutableElement, ? extends AnnotationValue>> entries = annotationMirror.getElementValues().entrySet();
            if (entries.size() != 1) {
                throw new IllegalArgumentException("Expected single value, but found: " + String.valueOf(entries));
            }
            excludedModuleAnnotationValue = entries.iterator().next().getValue();
            if (excludedModuleAnnotationValue != null) continue;
            throw new IllegalArgumentException("Failed to find value for: " + String.valueOf(annotationClass) + " from mirrors: " + String.valueOf(clazz.getAnnotationMirrors()));
        }
        if (excludedModuleAnnotationValue == null) {
            return ImmutableSet.of();
        }
        Object value = excludedModuleAnnotationValue.getValue();
        if (value instanceof List) {
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            for (Object o : (List)value) {
                AnnotationValue av = (AnnotationValue)o;
                linkedHashSet.add(ProcessorUtil.qualifiedNameFromTypeMirror((TypeMirror)av.getValue()));
            }
            return ImmutableSet.copyOf(linkedHashSet);
        }
        return ImmutableSet.of((Object)ProcessorUtil.qualifiedNameFromTypeMirror((TypeMirror)value));
    }

    static String qualifiedNameFromTypeMirror(TypeMirror type) {
        if (type.getKind() == TypeKind.ERROR) {
            throw new IllegalArgumentException("Unresolved class type in annotation: " + String.valueOf(type));
        }
        if (type.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)type;
            TypeElement te = (TypeElement)dt.asElement();
            return te.getQualifiedName().toString();
        }
        return type.toString();
    }

    boolean isReturnValueTypeMatching(ExecutableElement method, TypeElement expectedReturnType) {
        return this.isReturnValueTypeMatching(method, expectedReturnType.asType());
    }

    private boolean isReturnValueTypeMatching(ExecutableElement method, TypeMirror expectedReturnType) {
        return this.processingEnv.getTypeUtils().isAssignable(method.getReturnType(), expectedReturnType);
    }

    private final class FilterPublicMethods
    implements Predicate<Element> {
        @Nullable
        private final TypeMirror returnType;
        private final MethodType methodType;

        FilterPublicMethods(TypeMirror returnType, MethodType methodType) {
            this.returnType = returnType;
            this.methodType = methodType;
        }

        FilterPublicMethods(TypeElement returnType, MethodType methodType) {
            this(returnType != null ? returnType.asType() : null, methodType);
        }

        public boolean apply(@Nullable Element input) {
            if (input == null || input.getKind() != ElementKind.METHOD || !input.getModifiers().contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            boolean isStatic = input.getModifiers().contains((Object)Modifier.STATIC);
            if (this.methodType == MethodType.STATIC && !isStatic) {
                return false;
            }
            if (this.methodType == MethodType.INSTANCE && isStatic) {
                return false;
            }
            ExecutableElement method = (ExecutableElement)input;
            return this.returnType == null || ProcessorUtil.this.isReturnValueTypeMatching(method, this.returnType);
        }
    }

    private static enum MethodType {
        STATIC,
        INSTANCE;

    }

    private static final class ToMethod
    implements Function<Element, ExecutableElement> {
        private ToMethod() {
        }

        @Nullable
        public ExecutableElement apply(@Nullable Element input) {
            return (ExecutableElement)input;
        }
    }
}

