/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imagepipeline.image;

import android.graphics.Bitmap;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.imagepipeline.image.BaseCloseableStaticBitmap;
import com.facebook.imagepipeline.image.CloseableBitmap;
import com.facebook.imagepipeline.image.DefaultCloseableStaticBitmap;
import com.facebook.imagepipeline.image.QualityInfo;
import com.facebook.infer.annotation.Nullsafe;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public interface CloseableStaticBitmap
extends CloseableBitmap {
    public CloseableReference<Bitmap> cloneUnderlyingBitmapReference();

    public int getExifOrientation();

    public int getRotationAngle();

    public CloseableReference<Bitmap> convertToBitmapReference();

    public static CloseableStaticBitmap of(Bitmap bitmap, ResourceReleaser<Bitmap> resourceReleaser, QualityInfo qualityInfo, int rotationAngle) {
        return CloseableStaticBitmap.of(bitmap, resourceReleaser, qualityInfo, rotationAngle, 0);
    }

    public static CloseableStaticBitmap of(CloseableReference<Bitmap> bitmapReference, QualityInfo qualityInfo, int rotationAngle) {
        return CloseableStaticBitmap.of(bitmapReference, qualityInfo, rotationAngle, 0);
    }

    public static CloseableStaticBitmap of(Bitmap bitmap, ResourceReleaser<Bitmap> resourceReleaser, QualityInfo qualityInfo, int rotationAngle, int orientation) {
        if (BaseCloseableStaticBitmap.shouldUseSimpleCloseableStaticBitmap()) {
            return new BaseCloseableStaticBitmap(bitmap, resourceReleaser, qualityInfo, rotationAngle, orientation);
        }
        return new DefaultCloseableStaticBitmap(bitmap, resourceReleaser, qualityInfo, rotationAngle, orientation);
    }

    public static CloseableStaticBitmap of(CloseableReference<Bitmap> bitmapReference, QualityInfo qualityInfo, int rotationAngle, int exifOrientation) {
        if (BaseCloseableStaticBitmap.shouldUseSimpleCloseableStaticBitmap()) {
            return new BaseCloseableStaticBitmap(bitmapReference, qualityInfo, rotationAngle, exifOrientation);
        }
        return new DefaultCloseableStaticBitmap(bitmapReference, qualityInfo, rotationAngle, exifOrientation);
    }
}

