/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.imageformat;

import com.facebook.common.internal.Ints;
import com.facebook.common.internal.Preconditions;
import com.facebook.common.webp.WebpSupportStatus;
import com.facebook.imageformat.DefaultImageFormats;
import com.facebook.imageformat.ImageFormat;
import com.facebook.imageformat.ImageFormatCheckerUtils;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class DefaultImageFormatChecker
implements ImageFormat.FormatChecker {
    final int MAX_HEADER_LENGTH = Ints.max((int[])new int[]{21, 20, JPEG_HEADER_LENGTH, PNG_HEADER_LENGTH, 6, BMP_HEADER_LENGTH, ICO_HEADER_LENGTH, 12});
    private boolean mUseNewOrder = false;
    private static final int SIMPLE_WEBP_HEADER_LENGTH = 20;
    private static final int EXTENDED_WEBP_HEADER_LENGTH = 21;
    private static final byte[] JPEG_HEADER = new byte[]{-1, -40, -1};
    private static final int JPEG_HEADER_LENGTH = JPEG_HEADER.length;
    private static final byte[] PNG_HEADER = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private static final int PNG_HEADER_LENGTH = PNG_HEADER.length;
    private static final byte[] GIF_HEADER_87A = ImageFormatCheckerUtils.asciiBytes("GIF87a");
    private static final byte[] GIF_HEADER_89A = ImageFormatCheckerUtils.asciiBytes("GIF89a");
    private static final int GIF_HEADER_LENGTH = 6;
    private static final byte[] BMP_HEADER = ImageFormatCheckerUtils.asciiBytes("BM");
    private static final int BMP_HEADER_LENGTH = BMP_HEADER.length;
    private static final byte[] ICO_HEADER = new byte[]{0, 0, 1, 0};
    private static final int ICO_HEADER_LENGTH = ICO_HEADER.length;
    private static final byte[] HEIF_HEADER_PREFIX = ImageFormatCheckerUtils.asciiBytes("ftyp");
    private static final byte[][] HEIF_HEADER_SUFFIXES = new byte[][]{ImageFormatCheckerUtils.asciiBytes("heic"), ImageFormatCheckerUtils.asciiBytes("heix"), ImageFormatCheckerUtils.asciiBytes("hevc"), ImageFormatCheckerUtils.asciiBytes("hevx"), ImageFormatCheckerUtils.asciiBytes("mif1"), ImageFormatCheckerUtils.asciiBytes("msf1")};
    private static final int HEIF_HEADER_LENGTH = 12;
    private static final byte[] DNG_HEADER_II = new byte[]{73, 73, 42, 0};
    private static final byte[] DNG_HEADER_MM = new byte[]{77, 77, 0, 42};
    private static final int DNG_HEADER_LENGTH = DNG_HEADER_II.length;

    public void setUseNewOrder(boolean useNewOrder) {
        this.mUseNewOrder = useNewOrder;
    }

    @Override
    public int getHeaderSize() {
        return this.MAX_HEADER_LENGTH;
    }

    @Override
    @Nullable
    public final ImageFormat determineFormat(byte[] headerBytes, int headerSize) {
        Preconditions.checkNotNull((Object)headerBytes);
        if (!this.mUseNewOrder && WebpSupportStatus.isWebpHeader((byte[])headerBytes, (int)0, (int)headerSize)) {
            return DefaultImageFormatChecker.getWebpFormat(headerBytes, headerSize);
        }
        if (DefaultImageFormatChecker.isJpegHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.JPEG;
        }
        if (DefaultImageFormatChecker.isPngHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.PNG;
        }
        if (this.mUseNewOrder && WebpSupportStatus.isWebpHeader((byte[])headerBytes, (int)0, (int)headerSize)) {
            return DefaultImageFormatChecker.getWebpFormat(headerBytes, headerSize);
        }
        if (DefaultImageFormatChecker.isGifHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.GIF;
        }
        if (DefaultImageFormatChecker.isBmpHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.BMP;
        }
        if (DefaultImageFormatChecker.isIcoHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.ICO;
        }
        if (DefaultImageFormatChecker.isHeifHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.HEIF;
        }
        if (DefaultImageFormatChecker.isDngHeader(headerBytes, headerSize)) {
            return DefaultImageFormats.DNG;
        }
        return ImageFormat.UNKNOWN;
    }

    private static ImageFormat getWebpFormat(byte[] imageHeaderBytes, int headerSize) {
        Preconditions.checkArgument((Boolean)WebpSupportStatus.isWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize));
        if (WebpSupportStatus.isSimpleWebpHeader((byte[])imageHeaderBytes, (int)0)) {
            return DefaultImageFormats.WEBP_SIMPLE;
        }
        if (WebpSupportStatus.isLosslessWebpHeader((byte[])imageHeaderBytes, (int)0)) {
            return DefaultImageFormats.WEBP_LOSSLESS;
        }
        if (WebpSupportStatus.isExtendedWebpHeader((byte[])imageHeaderBytes, (int)0, (int)headerSize)) {
            if (WebpSupportStatus.isAnimatedWebpHeader((byte[])imageHeaderBytes, (int)0)) {
                return DefaultImageFormats.WEBP_ANIMATED;
            }
            if (WebpSupportStatus.isExtendedWebpHeaderWithAlpha((byte[])imageHeaderBytes, (int)0)) {
                return DefaultImageFormats.WEBP_EXTENDED_WITH_ALPHA;
            }
            return DefaultImageFormats.WEBP_EXTENDED;
        }
        return ImageFormat.UNKNOWN;
    }

    private static boolean isJpegHeader(byte[] imageHeaderBytes, int headerSize) {
        return headerSize >= JPEG_HEADER.length && ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, JPEG_HEADER);
    }

    private static boolean isPngHeader(byte[] imageHeaderBytes, int headerSize) {
        return headerSize >= PNG_HEADER.length && ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, PNG_HEADER);
    }

    private static boolean isGifHeader(byte[] imageHeaderBytes, int headerSize) {
        if (headerSize < 6) {
            return false;
        }
        return ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, GIF_HEADER_87A) || ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, GIF_HEADER_89A);
    }

    private static boolean isBmpHeader(byte[] imageHeaderBytes, int headerSize) {
        if (headerSize < BMP_HEADER.length) {
            return false;
        }
        return ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, BMP_HEADER);
    }

    private static boolean isIcoHeader(byte[] imageHeaderBytes, int headerSize) {
        if (headerSize < ICO_HEADER.length) {
            return false;
        }
        return ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, ICO_HEADER);
    }

    private static boolean isHeifHeader(byte[] imageHeaderBytes, int headerSize) {
        if (headerSize < 12) {
            return false;
        }
        byte boxLength = imageHeaderBytes[3];
        if (boxLength < 8) {
            return false;
        }
        if (!ImageFormatCheckerUtils.hasPatternAt(imageHeaderBytes, HEIF_HEADER_PREFIX, 4)) {
            return false;
        }
        for (byte[] heifFtype : HEIF_HEADER_SUFFIXES) {
            if (!ImageFormatCheckerUtils.hasPatternAt(imageHeaderBytes, heifFtype, 8)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDngHeader(byte[] imageHeaderBytes, int headerSize) {
        return headerSize >= DNG_HEADER_LENGTH && (ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, DNG_HEADER_II) || ImageFormatCheckerUtils.startsWithPattern(imageHeaderBytes, DNG_HEADER_MM));
    }
}

