/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.util;

import android.util.Base64;
import com.facebook.infer.annotation.Nullsafe;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class SecureHashUtil {
    static final byte[] HEX_CHAR_TABLE = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    private static final int BUFFER_SIZE = 4096;

    public static String makeSHA1Hash(String text) {
        try {
            return SecureHashUtil.makeSHA1Hash(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeSHA1Hash(byte[] bytes) {
        return SecureHashUtil.makeHash(bytes, "SHA-1");
    }

    public static String makeSHA256Hash(byte[] bytes) {
        return SecureHashUtil.makeHash(bytes, "SHA-256");
    }

    public static String makeSHA1HashBase64(byte[] bytes) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            md.update(bytes, 0, bytes.length);
            byte[] sha1hash = md.digest();
            return Base64.encodeToString((byte[])sha1hash, (int)11);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeMD5Hash(String text) {
        try {
            return SecureHashUtil.makeMD5Hash(text.getBytes("utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String makeMD5Hash(byte[] bytes) {
        return SecureHashUtil.makeHash(bytes, "MD5");
    }

    public static String makeMD5Hash(InputStream stream) throws IOException {
        return SecureHashUtil.makeHash(stream, "MD5");
    }

    public static String convertToHex(byte[] raw) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder(raw.length);
        for (byte b : raw) {
            int v = b & 0xFF;
            sb.append((char)HEX_CHAR_TABLE[v >>> 4]);
            sb.append((char)HEX_CHAR_TABLE[v & 0xF]);
        }
        return sb.toString();
    }

    private static String makeHash(byte[] bytes, String algorithm) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            md.update(bytes, 0, bytes.length);
            byte[] hash = md.digest();
            return SecureHashUtil.convertToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String makeHash(InputStream stream, String algorithm) throws IOException {
        try {
            int read;
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] buffer = new byte[4096];
            while ((read = stream.read(buffer)) > 0) {
                md.update(buffer, 0, read);
            }
            byte[] hash = md.digest();
            return SecureHashUtil.convertToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

