/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.common.references;

import com.facebook.common.logging.FLog;
import com.facebook.common.references.CloseableReference;
import com.facebook.common.references.ResourceReleaser;
import com.facebook.infer.annotation.Nullsafe;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.STRICT)
public class FinalizerCloseableReference<T>
extends CloseableReference<T> {
    private static final String TAG = "FinalizerCloseableReference";

    FinalizerCloseableReference(T t, ResourceReleaser<T> resourceReleaser, CloseableReference.LeakHandler leakHandler, @Nullable Throwable stacktrace) {
        super(t, resourceReleaser, leakHandler, stacktrace, true);
    }

    @Override
    public CloseableReference<T> clone() {
        return this;
    }

    @Override
    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void finalize() throws Throwable {
        try {
            FinalizerCloseableReference finalizerCloseableReference = this;
            synchronized (finalizerCloseableReference) {
                if (this.mIsClosed) {
                    return;
                }
            }
            Object ref = this.mSharedReference.get();
            FLog.w(TAG, "Finalized without closing: %x %x (type = %s)", System.identityHashCode(this), System.identityHashCode(this.mSharedReference), ref == null ? null : ref.getClass().getName());
            this.mSharedReference.deleteReference();
            return;
        }
        finally {
            super.finalize();
        }
    }
}

